/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import de.maxhenkel.voicechat.events.ClientVoiceChatConnectedEvent;
import de.maxhenkel.voicechat.events.ClientVoiceChatDisconnectedEvent;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.network.NetworkManager;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class ForgeClientCompatibilityManager
extends ClientCompatibilityManager {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private final List<ClientCompatibilityManager.RenderNameplateEvent> renderNameplateEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.RenderNameplateEvent>();
    private final List<ClientCompatibilityManager.RenderHUDEvent> renderHUDEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.RenderHUDEvent>();
    private final List<ClientCompatibilityManager.KeyboardEvent> keyboardEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.KeyboardEvent>();
    private final List<ClientCompatibilityManager.MouseEvent> mouseEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.MouseEvent>();
    private final List<Runnable> inputEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> disconnectEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> joinWorldEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<ClientVoicechatConnection>> voicechatConnectEvents = new CopyOnWriteArrayList<Consumer<ClientVoicechatConnection>>();
    private final List<Runnable> voicechatDisconnectEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<Integer>> publishServerEvents = new CopyOnWriteArrayList<Consumer<Integer>>();
    private boolean changingServer;

    public void onRenderName(Entity entity, String str, double x, double y, double z, int maxDistance) {
        this.renderNameplateEvents.forEach(renderNameplateEvent -> renderNameplateEvent.render(entity, str, x, y, z, maxDistance));
        if (this.minecraft.field_71439_g == null) {
            return;
        }
        this.renderNameplateEvents.forEach(renderNameplateEvent -> renderNameplateEvent.render(entity, str, x, y, z, maxDistance));
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (!RenderGameOverlayEvent.ElementType.HOTBAR.equals((Object)event.getType())) {
            return;
        }
        this.renderHUDEvents.forEach(renderHUDEvent -> renderHUDEvent.render(event.getPartialTicks()));
    }

    public void onTickKey() {
        this.keyboardEvents.forEach(ClientCompatibilityManager.KeyboardEvent::onKeyboardEvent);
    }

    public void onTickMouse() {
        this.mouseEvents.forEach(ClientCompatibilityManager.MouseEvent::onMouseEvent);
    }

    @SubscribeEvent
    public void onInput(TickEvent.ClientTickEvent event) {
        this.inputEvents.forEach(Runnable::run);
    }

    public void onDisconnect() {
        this.disconnectEvents.forEach(Runnable::run);
    }

    @SubscribeEvent
    public void onChangeServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (this.minecraft.field_71439_g == null) {
            return;
        }
        this.changingServer = true;
    }

    public void onRespawn() {
        if (this.changingServer) {
            this.changingServer = false;
            this.onJoinWorld();
        }
    }

    public void onJoinWorld() {
        this.joinWorldEvents.forEach(Runnable::run);
    }

    public void onOpenPort(int port) {
        this.publishServerEvents.forEach(consumer -> consumer.accept(port));
    }

    @Override
    public void onRenderNamePlate(ClientCompatibilityManager.RenderNameplateEvent onRenderNamePlate) {
        this.renderNameplateEvents.add(onRenderNamePlate);
    }

    @Override
    public void onRenderHUD(ClientCompatibilityManager.RenderHUDEvent onRenderHUD) {
        this.renderHUDEvents.add(onRenderHUD);
    }

    @Override
    public void onKeyboardEvent(ClientCompatibilityManager.KeyboardEvent onKeyboardEvent) {
        this.keyboardEvents.add(onKeyboardEvent);
    }

    @Override
    public void onMouseEvent(ClientCompatibilityManager.MouseEvent onMouseEvent) {
        this.mouseEvents.add(onMouseEvent);
    }

    @Override
    public int getBoundKeyOf(KeyBinding keyBinding) {
        return keyBinding.func_151463_i();
    }

    @Override
    public void onHandleKeyBinds(Runnable onHandleKeyBinds) {
        this.inputEvents.add(onHandleKeyBinds);
    }

    @Override
    public KeyBinding registerKeyBinding(KeyBinding keyBinding) {
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        return keyBinding;
    }

    @Override
    public void emitVoiceChatConnectedEvent(ClientVoicechatConnection client) {
        this.voicechatConnectEvents.forEach(consumer -> consumer.accept(client));
        MinecraftForge.EVENT_BUS.post((Event)new ClientVoiceChatConnectedEvent(client));
    }

    @Override
    public void emitVoiceChatDisconnectedEvent() {
        this.voicechatDisconnectEvents.forEach(Runnable::run);
        MinecraftForge.EVENT_BUS.post((Event)new ClientVoiceChatDisconnectedEvent());
    }

    @Override
    public void onVoiceChatConnected(Consumer<ClientVoicechatConnection> onVoiceChatConnected) {
        this.voicechatConnectEvents.add(onVoiceChatConnected);
    }

    @Override
    public void onVoiceChatDisconnected(Runnable onVoiceChatDisconnected) {
        this.voicechatDisconnectEvents.add(onVoiceChatDisconnected);
    }

    @Override
    public void emitDisconnectedEvent() {
        this.disconnectEvents.forEach(Runnable::run);
    }

    @Override
    public void onDisconnect(Runnable onDisconnect) {
        this.disconnectEvents.add(onDisconnect);
    }

    @Override
    public void onJoinWorld(Runnable onJoinWorld) {
        this.joinWorldEvents.add(onJoinWorld);
    }

    @Override
    public void onPublishServer(Consumer<Integer> onPublishServer) {
        this.publishServerEvents.add(onPublishServer);
    }

    @Override
    public SocketAddress getSocketAddress(NetworkManager connection) {
        return connection.channel().remoteAddress();
    }
}

