/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.natives.RNNoiseManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class VoiceActivationSlider
extends DebouncedSlider
implements MicTestButton.MicListener {
    private static final ResourceLocation SLIDER = new ResourceLocation("voicechat", "textures/gui/voice_activation_slider.png");
    private static final ITextComponent NO_ACTIVATION = new TextComponentTranslation("message.voicechat.voice_activation.disabled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    private final SlidingMaxSmooth micValue;

    public VoiceActivationSlider(int id, int x, int y, int width, int height) {
        super(id, x, y, width, height, AudioUtils.dbToPerc(VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.get().floatValue()));
        this.updateMessage();
        this.micValue = new SlidingMaxSmooth();
    }

    public boolean shouldShowSlider() {
        if (!MicrophoneActivationType.VOICE.equals((Object)VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get())) {
            return false;
        }
        if (!RNNoiseManager.canUseDenoiser()) {
            return true;
        }
        return VoicechatClient.CLIENT_CONFIG.vad.get() == false;
    }

    @Override
    public void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        super.func_146119_b(mc, mouseX, mouseY);
        mc.func_110434_K().func_110577_a(SLIDER);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = (int)((double)(this.func_146117_b() - 2) * this.micValue.smoothMax());
        this.func_73729_b(this.field_146128_h + 1, this.field_146129_i + 1, 0, 0, width, 18);
    }

    @Override
    protected void renderSlider(Minecraft mc) {
        boolean shouldShow = this.shouldShowSlider();
        if (shouldShow != this.field_146124_l) {
            this.field_146124_l = shouldShow;
            this.updateMessage();
        }
        if (!this.field_146124_l) {
            return;
        }
        super.renderSlider(mc);
    }

    @Override
    protected void updateMessage() {
        if (!this.field_146124_l) {
            this.field_146126_j = "";
            return;
        }
        long db = Math.round(AudioUtils.percToDb(this.value));
        TextComponentTranslation component = new TextComponentTranslation("message.voicechat.voice_activation", new Object[]{db});
        if (db >= -10L) {
            component.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        }
        this.field_146126_j = component.func_150254_d();
    }

    @Nullable
    public ITextComponent getHoverText() {
        if (!this.field_146124_l) {
            return null;
        }
        if (this.value >= 1.0) {
            return NO_ACTIVATION;
        }
        return null;
    }

    @Override
    public void applyDebounced() {
        VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.set(AudioUtils.percToDb(this.value)).save();
    }

    @Override
    public void onMicValue(double dB) {
        this.micValue.add(AudioUtils.dbToPerc(dB));
    }

    public boolean isHovered() {
        return this.field_146123_n;
    }

    @Override
    public void onStop() {
        this.micValue.reset();
    }

    private static class SlidingMaxSmooth {
        private final double[] values = new double[15];
        private int n;
        private int p;
        private static final double SMOOTHING_PER_SEC = 25.0;
        private double smoothed;
        private long lastNs = -1L;

        private SlidingMaxSmooth() {
        }

        public void add(double x) {
            if (this.n < this.values.length) {
                ++this.n;
            }
            this.values[this.p] = x;
            this.p = (this.p + 1) % this.values.length;
        }

        public double max() {
            if (this.n == 0) {
                return 0.0;
            }
            int len = Math.min(this.n, this.values.length);
            double max = this.values[0];
            for (int i = 1; i < len; ++i) {
                if (!(this.values[i] > max)) continue;
                max = this.values[i];
            }
            return max;
        }

        public double smoothMax() {
            long nowNanos = System.nanoTime();
            double target = this.max();
            if (this.lastNs < 0L) {
                this.lastNs = nowNanos;
                this.smoothed = target;
                return this.smoothed;
            }
            double dt = (double)(nowNanos - this.lastNs) / 1.0E9;
            this.lastNs = nowNanos;
            double alpha = dt * 25.0;
            if (alpha > 1.0) {
                alpha = 1.0;
            }
            if (alpha < 0.0) {
                alpha = 0.0;
            }
            this.smoothed += (target - this.smoothed) * alpha;
            return this.smoothed;
        }

        public void reset() {
            this.n = 0;
            this.p = 0;
            this.smoothed = 0.0;
            this.lastNs = -1L;
        }
    }
}

