/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.config;

import com.sun.jna.Platform;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.configbuilder.ConfigBuilder;
import de.maxhenkel.voicechat.configbuilder.MigratableConfig;
import de.maxhenkel.voicechat.configbuilder.entry.ConfigEntry;
import de.maxhenkel.voicechat.configbuilder.entry.DoubleConfigEntry;
import de.maxhenkel.voicechat.integration.freecam.FreecamMode;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.macos.VersionCheck;
import de.maxhenkel.voicechat.voice.client.GroupPlayerIconOrientation;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.speaker.AudioType;

public class ClientConfig {
    private static final int CONFIG_VERSION = 1;
    public ConfigEntry<Integer> configVersion;
    public ConfigEntry<Boolean> onboardingFinished;
    public DoubleConfigEntry voiceChatVolume;
    public ConfigEntry<Double> voiceActivationThreshold;
    public ConfigEntry<Boolean> vad;
    public ConfigEntry<Double> microphoneGain;
    public ConfigEntry<Boolean> agc;
    public ConfigEntry<MicrophoneActivationType> microphoneActivationType;
    public ConfigEntry<Integer> outputBufferSize;
    public ConfigEntry<Integer> audioPacketThreshold;
    public ConfigEntry<Integer> voiceDeactivationDelay;
    public ConfigEntry<Integer> pttDeactivationDelay;
    public ConfigEntry<String> microphone;
    public ConfigEntry<String> speaker;
    public ConfigEntry<Boolean> muted;
    public ConfigEntry<Boolean> disabled;
    public ConfigEntry<Boolean> hideIcons;
    public ConfigEntry<Boolean> showNametagIcons;
    public ConfigEntry<Boolean> showHudIcons;
    public ConfigEntry<Boolean> showGroupHud;
    public ConfigEntry<Boolean> showOwnGroupIcon;
    public ConfigEntry<Double> groupHudIconScale;
    public ConfigEntry<GroupPlayerIconOrientation> groupPlayerIconOrientation;
    public ConfigEntry<Integer> groupPlayerIconPosX;
    public ConfigEntry<Integer> groupPlayerIconPosY;
    public ConfigEntry<Integer> hudIconPosX;
    public ConfigEntry<Integer> hudIconPosY;
    public ConfigEntry<Double> hudIconScale;
    public ConfigEntry<String> recordingDestination;
    public ConfigEntry<Integer> recordingQuality;
    public ConfigEntry<Boolean> denoiser;
    public ConfigEntry<Boolean> runLocalServer;
    public ConfigEntry<Boolean> javaMicrophoneImplementation;
    public ConfigEntry<Boolean> showFakePlayersDisconnected;
    public ConfigEntry<Boolean> offlinePlayerVolumeAdjustment;
    public ConfigEntry<AudioType> audioType;
    public ConfigEntry<Boolean> useNatives;
    public ConfigEntry<FreecamMode> freecamMode;
    public ConfigEntry<Boolean> muteOnJoin;

    public ClientConfig(ConfigBuilder builder) {
        builder.header(String.format("%s client config v%s", CommonCompatibilityManager.INSTANCE.getModName(), CommonCompatibilityManager.INSTANCE.getModVersion()));
        this.configVersion = builder.integerEntry("config_version", (Integer)1, "The config version - Used for migration", "WARNING: DO NOT CHANGE THIS VALUE");
        this.onboardingFinished = builder.booleanEntry("onboarding_finished", false, "If the voice chat onboarding process has been finished");
        this.voiceChatVolume = builder.doubleEntry("voice_chat_volume", (Double)1.0, 0.0, 3.0, "The voice chat volume");
        this.voiceActivationThreshold = builder.doubleEntry("voice_activation_threshold", (Double)-50.0, -127.0, 0.0, "The threshold for the voice activation method (in dB)");
        this.vad = builder.booleanEntry("voice_activity_detection", true, "If automatic voice detection should be used");
        this.microphoneGain = builder.doubleEntry("microphone_gain", (Double)0.0, -40.0, 24.0, "The voice chat microphone gain");
        this.agc = builder.booleanEntry("automatic_gain_control", true, "Enable automatic gain control");
        this.microphoneActivationType = builder.enumEntry("microphone_activation_type", MicrophoneActivationType.PTT, "The microphone activation method", "Valid values are 'PTT' and 'VOICE'");
        this.outputBufferSize = builder.integerEntry("output_buffer_size", (Integer)5, 1, 16, "The size of the audio output buffer (in packets)", "Higher values mean a higher latency but less crackling", "Increase this value if you have an unstable internet connection");
        this.audioPacketThreshold = builder.integerEntry("audio_packet_threshold", (Integer)3, 0, 16, "The maximum number of audio packets that should be held back if a packet arrives out of order or is dropped", "This prevents audio packets that are only slightly out of order from being discarded", "Set this to 0 to disable");
        this.voiceDeactivationDelay = builder.integerEntry("voice_deactivation_delay", (Integer)25, 0, 100, "The time it takes for the microphone to deactivate when using voice activation", "A value of 1 means 20 milliseconds, 2=40 ms, 3=60 ms, and so on");
        this.pttDeactivationDelay = builder.integerEntry("ptt_deactivation_delay", (Integer)5, 0, 100, "The time it takes for the microphone to deactivate when using push to talk", "A value of 1 means 20 milliseconds, 2=40 ms, 3=60 ms, and so on");
        this.microphone = builder.stringEntry("microphone", "", "The microphone used by the voice chat", "Leave blank to use the default device");
        this.speaker = builder.stringEntry("speaker", "", "The speaker used by the voice chat", "Leave blank to use the default device");
        this.muted = builder.booleanEntry("muted", true, "If the microphone is muted (only relevant for the voice activation method)");
        this.disabled = builder.booleanEntry("disabled", false, "If the voice chat is disabled (both sound and microphone off)");
        this.hideIcons = builder.booleanEntry("hide_icons", false, "If the voice chat HUD, group chat HUD, and other in-game icons should be hidden");
        this.showNametagIcons = builder.booleanEntry("show_nametag_icons", true, "If the voice chat icons next to player names should be visible");
        this.showHudIcons = builder.booleanEntry("show_hud_icons", true, "If the voice chat icons on the HUD should be visible");
        this.showGroupHud = builder.booleanEntry("show_group_hud", true, "If the group chat HUD should be visible");
        this.showOwnGroupIcon = builder.booleanEntry("show_own_group_icon", true, "If your own player icon should be displayed in the group chat HUD when you are in a group");
        this.groupHudIconScale = builder.doubleEntry("group_hud_icon_scale", (Double)2.0, 0.01, 10.0, "The scale of the player icons in the group chat HUD");
        this.groupPlayerIconOrientation = builder.enumEntry("group_player_icon_orientation", GroupPlayerIconOrientation.VERTICAL, "The orientation of the player icons in the group chat HUD", "Valid values are 'VERTICAL' and 'HORIZONTAL'");
        this.groupPlayerIconPosX = builder.integerEntry("group_player_icon_pos_x", (Integer)4, Integer.MIN_VALUE, Integer.MAX_VALUE, "The X position of the player icons in the group chat HUD", "Negative values mean anchoring to the right instead");
        this.groupPlayerIconPosY = builder.integerEntry("group_player_icon_pos_y", (Integer)4, Integer.MIN_VALUE, Integer.MAX_VALUE, "The Y position of the player icons in the group chat HUD", "Negative values mean anchoring to the bottom instead");
        this.hudIconPosX = builder.integerEntry("hud_icon_pos_x", (Integer)16, Integer.MIN_VALUE, Integer.MAX_VALUE, "The X position of the icons in the voice chat HUD", "Negative values mean anchoring to the right instead");
        this.hudIconPosY = builder.integerEntry("hud_icon_pos_y", (Integer)-16, Integer.MIN_VALUE, Integer.MAX_VALUE, "The Y position of the icons in the voice chat HUD", "Negative values mean anchoring to the bottom instead");
        this.hudIconScale = builder.doubleEntry("hud_icon_scale", (Double)1.0, 0.01, 10.0, "The scale of the icons in the voice chat HUD, such as microphone or connection status");
        this.recordingDestination = builder.stringEntry("recording_destination", "", "The location where recordings should be saved", "Leave blank to use the default location");
        this.recordingQuality = builder.integerEntry("recording_quality", (Integer)2, 0, 9, "The quality of the recorded voice chat audio", "0 = highest quality, 9 = lowest quality");
        this.denoiser = builder.booleanEntry("denoiser", true, "If noise suppression should be enabled");
        this.runLocalServer = builder.booleanEntry("run_local_server", true, "If the voice chat should work in singleplayer or in worlds shared over LAN");
        this.javaMicrophoneImplementation = builder.booleanEntry("java_microphone_implementation", true, "Whether to use the Java implementation of microphone capture instead of OpenAL");
        this.showFakePlayersDisconnected = builder.booleanEntry("show_fake_players_disconnected", false, "If fake players should have the disconnected icon above their head");
        this.offlinePlayerVolumeAdjustment = builder.booleanEntry("offline_player_volume_adjustment", false, "If the volume adjustment interface should also display offline players");
        this.audioType = builder.enumEntry("audio_type", AudioType.NORMAL, "The 3D audio type", "Valid values are 'NORMAL', 'REDUCED', and 'OFF'");
        this.useNatives = builder.booleanEntry("use_natives", true, "If the mod should load native libraries on the client", "When disabled, the Java Opus implementation will be used instead, automatic gain control won't be available, noise suppression won't be available, and you won't be able to record the voice chat audio");
        this.freecamMode = builder.enumEntry("freecam_mode", FreecamMode.CAMERA, "How listening to other players should work when using freecam mods", "Valid values are 'CAMERA' and 'PLAYER'", "CAMERA: You will hear the voice chat around your camera. Whether you will still be able to hear the voice chat when the camera is far away from your character depends on the voice chat broadcast range of the server", "PLAYER: You will hear the voice chat around your character no matter where your camera is");
        this.muteOnJoin = builder.booleanEntry("mute_on_join", false, "If enabled, you will be automatically muted when joining a world");
        if (!this.javaMicrophoneImplementation.get().booleanValue()) {
            this.javaMicrophoneImplementation.set(true).save();
        }
        if (Platform.isMac() && this.useNatives.get().booleanValue() && !VersionCheck.isMacOSNativeCompatible()) {
            this.useNatives.set(false).save();
        }
    }

    public static void migrate(MigratableConfig migratableConfig) {
        String configVersionString = migratableConfig.get("config_version");
        int configVersion = 0;
        if (configVersionString != null) {
            try {
                configVersion = Integer.parseInt(configVersionString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (configVersion == 0) {
            ClientConfig.migrateFrom0To1(migratableConfig);
            configVersion = 1;
        }
    }

    private static void migrateFrom0To1(MigratableConfig migratableConfig) {
        Voicechat.LOGGER.info("Migrating config from version 0 to 1", new Object[0]);
        migratableConfig.set("config_version", "1");
        migratableConfig.set("denoiser", "true");
        migratableConfig.set("voice_activation_threshold", "-50");
        migratableConfig.set("onboarding_finished", "false");
    }
}

