/*
 * Decompiled with CFR 0.152.
 */
package glmath.glm.mat._4;

import glmath.glm.Glm;
import glmath.glm.mat._3.Mat3;
import glmath.glm.mat._4.matrixQuery;
import glmath.glm.quat.Quat;
import glmath.glm.vec._3.Vec3;
import glmath.glm.vec._4.Vec4;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class Mat4
extends matrixQuery {
    public Mat4() {
        this(1.0f);
    }

    public Mat4(float f) {
        this(f, 0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 0.0f, f);
    }

    public Mat4(Vec4 v) {
        this(v.x, 0.0f, 0.0f, 0.0f, 0.0f, v.y, 0.0f, 0.0f, 0.0f, 0.0f, v.z, 0.0f, 0.0f, 0.0f, 0.0f, v.w);
    }

    public Mat4(float[] f) {
        this(f, 0);
    }

    public Mat4(float[] f, int offset2) {
        this(f[offset2 + 0], f[offset2 + 1], f[offset2 + 2], f[offset2 + 3], f[offset2 + 4], f[offset2 + 5], f[offset2 + 6], f[offset2 + 7], f[offset2 + 8], f[offset2 + 9], f[offset2 + 10], f[offset2 + 11], f[offset2 + 12], f[offset2 + 13], f[offset2 + 14], f[offset2 + 15]);
    }

    public Mat4(Mat3 mat) {
        this(mat.m00, mat.m01, mat.m02, 0.0f, mat.m10, mat.m11, mat.m12, 0.0f, mat.m20, mat.m21, mat.m22, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Mat4(Mat4 mat) {
        this(mat.m00, mat.m01, mat.m02, mat.m03, mat.m10, mat.m11, mat.m12, mat.m13, mat.m20, mat.m21, mat.m22, mat.m23, mat.m30, mat.m31, mat.m32, mat.m33);
    }

    public Mat4(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        this((float)m00, (float)m01, (float)m02, (float)m03, (float)m10, (float)m11, (float)m12, (float)m13, (float)m20, (float)m21, (float)m22, (float)m23, (float)m30, (float)m31, (float)m32, (float)m33);
    }

    public Mat4(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    public Mat4 set() {
        return this.set(0.0f);
    }

    public Mat4 set(float f) {
        return this.set(f, 0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 0.0f, f);
    }

    public Mat4 set(Vec4 v) {
        return this.set(v.x, 0.0f, 0.0f, 0.0f, 0.0f, v.y, 0.0f, 0.0f, 0.0f, 0.0f, v.z, 0.0f, 0.0f, 0.0f, 0.0f, v.w);
    }

    public Mat4 set(Vec3 v) {
        return this.set(v.x, 0.0f, 0.0f, 0.0f, 0.0f, v.y, 0.0f, 0.0f, 0.0f, 0.0f, v.z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Mat4 set(Mat4 mat) {
        return this.set(mat.m00, mat.m01, mat.m02, mat.m03, mat.m10, mat.m11, mat.m12, mat.m13, mat.m20, mat.m21, mat.m22, mat.m23, mat.m30, mat.m31, mat.m32, mat.m33);
    }

    public Mat4 set(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        return this.set((float)m00, (float)m01, (float)m02, (float)m03, (float)m10, (float)m11, (float)m12, (float)m13, (float)m20, (float)m21, (float)m22, (float)m23, (float)m30, (float)m31, (float)m32, (float)m33);
    }

    public Mat4 set(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
        return this;
    }

    public Mat4 set(int column, int row, float value) {
        if (column >= 0 && column < 4 && row >= 0 && row < 4) {
            float[] f = this.toFa_();
            f[column * 4 + row] = value;
            this.set(f);
        }
        return this;
    }

    public Mat4 set(float[] f) {
        return this.set(f, 0);
    }

    public Mat4 set(float[] f, int offset2) {
        this.set(f[offset2 + 0], f[offset2 + 1], f[offset2 + 2], f[offset2 + 3], f[offset2 + 4], f[offset2 + 5], f[offset2 + 6], f[offset2 + 7], f[offset2 + 8], f[offset2 + 9], f[offset2 + 10], f[offset2 + 11], f[offset2 + 12], f[offset2 + 13], f[offset2 + 14], f[offset2 + 15]);
        return this;
    }

    public Mat4 c0(Vec4 v) {
        return this.set(v.x, v.y, v.z, v.w, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33);
    }

    public Mat4 c0(Vec3 v, float f) {
        return this.set(v.x, v.y, v.z, f, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33);
    }

    public Mat4 c0(float x, float y, float z, float w) {
        return this.set(x, y, z, w, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33);
    }

    public Mat4 c1(Vec4 v) {
        return this.set(this.m00, this.m01, this.m02, this.m03, v.x, v.y, v.z, v.w, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33);
    }

    public Mat4 c1(Vec3 v, float f) {
        return this.set(this.m00, this.m01, this.m02, this.m03, v.x, v.y, v.z, f, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33);
    }

    public Mat4 c1(float x, float y, float z, float w) {
        return this.set(this.m00, this.m01, this.m02, this.m03, x, y, z, w, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33);
    }

    public Mat4 c2(Vec4 v) {
        return this.set(this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, v.x, v.y, v.z, v.w, this.m30, this.m31, this.m32, this.m33);
    }

    public Mat4 c2(Vec3 v, float f) {
        return this.set(this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, v.x, v.y, v.z, f, this.m30, this.m31, this.m32, this.m33);
    }

    public Mat4 c2(float x, float y, float z, float w) {
        return this.set(this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, x, y, z, w, this.m30, this.m31, this.m32, this.m33);
    }

    public Mat4 c3(Vec4 v) {
        return this.set(this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, v.x, v.y, v.z, v.w);
    }

    public Mat4 c3(Vec3 v, float f) {
        return this.set(this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, v.x, v.y, v.z, f);
    }

    public Mat4 c3(float x, float y, float z, float w) {
        return this.set(this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, x, y, z, w);
    }

    public Mat4 identity() {
        return this.set(1.0f);
    }

    public Mat4 cleanTranslation() {
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m33 = 1.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        return this;
    }

    public Vec4 mul(Vec4 v) {
        return this.mul(v, v);
    }

    public Vec4 mul_(Vec4 v) {
        return this.mul(v, new Vec4());
    }

    public Vec4 mul(Vec4 right, Vec4 res) {
        res.set(this.m00 * right.x + this.m10 * right.y + this.m20 * right.z + this.m30 * right.w, this.m01 * right.x + this.m11 * right.y + this.m21 * right.z + this.m31 * right.w, this.m02 * right.x + this.m12 * right.y + this.m22 * right.z + this.m32 * right.w, this.m03 * right.x + this.m13 * right.y + this.m23 * right.z + this.m33 * right.w);
        return res;
    }

    public Mat4 mul_(Mat4 right) {
        return this.mul(right, new Mat4());
    }

    public Mat4 mul(Mat4 right) {
        return this.mul(right, this);
    }

    public Mat4 mul(Mat4 right, Mat4 dest) {
        dest.set(this.m00 * right.m00 + this.m10 * right.m01 + this.m20 * right.m02 + this.m30 * right.m03, this.m01 * right.m00 + this.m11 * right.m01 + this.m21 * right.m02 + this.m31 * right.m03, this.m02 * right.m00 + this.m12 * right.m01 + this.m22 * right.m02 + this.m32 * right.m03, this.m03 * right.m00 + this.m13 * right.m01 + this.m23 * right.m02 + this.m33 * right.m03, this.m00 * right.m10 + this.m10 * right.m11 + this.m20 * right.m12 + this.m30 * right.m13, this.m01 * right.m10 + this.m11 * right.m11 + this.m21 * right.m12 + this.m31 * right.m13, this.m02 * right.m10 + this.m12 * right.m11 + this.m22 * right.m12 + this.m32 * right.m13, this.m03 * right.m10 + this.m13 * right.m11 + this.m23 * right.m12 + this.m33 * right.m13, this.m00 * right.m20 + this.m10 * right.m21 + this.m20 * right.m22 + this.m30 * right.m23, this.m01 * right.m20 + this.m11 * right.m21 + this.m21 * right.m22 + this.m31 * right.m23, this.m02 * right.m20 + this.m12 * right.m21 + this.m22 * right.m22 + this.m32 * right.m23, this.m03 * right.m20 + this.m13 * right.m21 + this.m23 * right.m22 + this.m33 * right.m23, this.m00 * right.m30 + this.m10 * right.m31 + this.m20 * right.m32 + this.m30 * right.m33, this.m01 * right.m30 + this.m11 * right.m31 + this.m21 * right.m32 + this.m31 * right.m33, this.m02 * right.m30 + this.m12 * right.m31 + this.m22 * right.m32 + this.m32 * right.m33, this.m03 * right.m30 + this.m13 * right.m31 + this.m23 * right.m32 + this.m33 * right.m33);
        return dest;
    }

    public static Mat4 cast_(Quat q) {
        return Mat4.cast(q, new Mat4());
    }

    public static Mat4 cast(Quat q, Mat4 res) {
        res.m00 = 1.0f - 2.0f * q.y * q.y - 2.0f * q.z * q.z;
        res.m01 = 2.0f * q.x * q.y + 2.0f * q.w * q.z;
        res.m02 = 2.0f * q.x * q.z - 2.0f * q.w * q.y;
        res.m03 = 0.0f;
        res.m10 = 2.0f * q.x * q.y - 2.0f * q.w * q.z;
        res.m11 = 1.0f - 2.0f * q.x * q.x - 2.0f * q.z * q.z;
        res.m12 = 2.0f * q.y * q.z + 2.0f * q.w * q.x;
        res.m13 = 0.0f;
        res.m20 = 2.0f * q.x * q.z + 2.0f * q.w * q.y;
        res.m21 = 2.0f * q.y * q.z - 2.0f * q.w * q.x;
        res.m22 = 1.0f - 2.0f * q.x * q.x - 2.0f * q.y * q.y;
        res.m23 = 0.0f;
        res.m30 = 0.0f;
        res.m31 = 0.0f;
        res.m32 = 0.0f;
        res.m33 = 1.0f;
        return res;
    }

    public boolean equals3(Mat4 other) {
        return this.equals3(other, 2);
    }

    public boolean equals3(Mat4 other, int maxUlps) {
        if (!Glm.compareFloatEquals(this.m00, other.m00, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m01, other.m01, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m02, other.m02, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m10, other.m10, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m11, other.m11, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m12, other.m12, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m20, other.m20, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m21, other.m21, maxUlps)) {
            return false;
        }
        return Glm.compareFloatEquals(this.m22, other.m22, maxUlps);
    }

    public boolean equals(Mat4 other) {
        return this.equals(other, 2);
    }

    public boolean equals(Mat4 other, int maxUlps) {
        if (!Glm.compareFloatEquals(this.m00, other.m00, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m01, other.m01, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m02, other.m02, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m03, other.m03, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m10, other.m10, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m11, other.m11, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m12, other.m12, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m13, other.m13, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m20, other.m20, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m21, other.m21, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m22, other.m22, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m23, other.m23, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m30, other.m30, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m31, other.m31, maxUlps)) {
            return false;
        }
        if (!Glm.compareFloatEquals(this.m32, other.m32, maxUlps)) {
            return false;
        }
        return Glm.compareFloatEquals(this.m33, other.m33, maxUlps);
    }

    public Mat3 toMat3_() {
        return this.toMat3(new Mat3());
    }

    public Mat3 toMat3(Mat3 res) {
        return res.set(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public float[] toFa_() {
        return this.toFa(new float[16]);
    }

    public float[] toFa(float[] res) {
        return this.toFa(res, 0);
    }

    public float[] toFa(float[] res, int index) {
        res[index + 0] = this.m00;
        res[index + 1] = this.m01;
        res[index + 2] = this.m02;
        res[index + 3] = this.m03;
        res[index + 4] = this.m10;
        res[index + 5] = this.m11;
        res[index + 6] = this.m12;
        res[index + 7] = this.m13;
        res[index + 8] = this.m20;
        res[index + 9] = this.m21;
        res[index + 10] = this.m22;
        res[index + 11] = this.m23;
        res[index + 12] = this.m30;
        res[index + 13] = this.m31;
        res[index + 14] = this.m32;
        res[index + 15] = this.m33;
        return res;
    }

    public ByteBuffer toDbb_() {
        return this.toDbb(ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()));
    }

    public ByteBuffer toDbb(ByteBuffer res) {
        return this.toDbb(res, 0);
    }

    public ByteBuffer toDbb(ByteBuffer res, int index) {
        res.putFloat(index + 0, this.m00);
        res.putFloat(index + 4, this.m01);
        res.putFloat(index + 8, this.m02);
        res.putFloat(index + 12, this.m03);
        res.putFloat(index + 16, this.m10);
        res.putFloat(index + 20, this.m11);
        res.putFloat(index + 24, this.m12);
        res.putFloat(index + 28, this.m13);
        res.putFloat(index + 32, this.m20);
        res.putFloat(index + 36, this.m21);
        res.putFloat(index + 40, this.m22);
        res.putFloat(index + 44, this.m23);
        res.putFloat(index + 48, this.m30);
        res.putFloat(index + 52, this.m31);
        res.putFloat(index + 56, this.m32);
        res.putFloat(index + 60, this.m33);
        return res;
    }

    public FloatBuffer toDfb_() {
        return this.toDfb(ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer());
    }

    public FloatBuffer toDfb(FloatBuffer res) {
        return this.toDfb(res, 0);
    }

    public FloatBuffer toDfb(FloatBuffer res, int index) {
        res.put(index + 0, this.m00);
        res.put(index + 1, this.m01);
        res.put(index + 2, this.m02);
        res.put(index + 3, this.m03);
        res.put(index + 4, this.m10);
        res.put(index + 5, this.m11);
        res.put(index + 6, this.m12);
        res.put(index + 7, this.m13);
        res.put(index + 8, this.m20);
        res.put(index + 9, this.m21);
        res.put(index + 10, this.m22);
        res.put(index + 11, this.m23);
        res.put(index + 12, this.m30);
        res.put(index + 13, this.m31);
        res.put(index + 14, this.m32);
        res.put(index + 15, this.m33);
        return res;
    }

    public void print() {
        this.print("", true);
    }

    public void print(String title) {
        this.print(title, true);
    }

    public void print(boolean outStream) {
        this.print("", outStream);
    }

    public void print(String title, boolean outStream) {
        String res = title + "\n| " + this.m00 + " " + this.m10 + " " + this.m20 + " " + this.m30 + " |\n| " + this.m01 + " " + this.m11 + " " + this.m21 + " " + this.m31 + " |\n| " + this.m02 + " " + this.m12 + " " + this.m22 + " " + this.m32 + " |\n| " + this.m03 + " " + this.m13 + " " + this.m23 + " " + this.m33 + " |\n";
        if (outStream) {
            System.out.print(res);
        } else {
            System.err.print(res);
        }
    }
}

