/*
 * Decompiled with CFR 0.152.
 */
package glmath.glm.mat._3;

import glmath.glm.mat._3.matrixQuery;
import glmath.glm.mat._4.Mat4;
import glmath.glm.quat.Quat;
import glmath.glm.vec._2.Vec2;
import glmath.glm.vec._3.Vec3;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class Mat3
extends matrixQuery {
    public Mat3() {
        this(1.0f);
    }

    public Mat3(float f) {
        this(f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, f);
    }

    public Mat3(Vec3 v) {
        this(v.x, 0.0f, 0.0f, 0.0f, v.y, 0.0f, 0.0f, 0.0f, v.z);
    }

    public Mat3(Mat3 mat) {
        this(mat.m00, mat.m01, mat.m02, mat.m10, mat.m11, mat.m12, mat.m20, mat.m21, mat.m22);
    }

    public Mat3(Mat4 mat) {
        this(mat.m00, mat.m01, mat.m02, mat.m10, mat.m11, mat.m12, mat.m20, mat.m21, mat.m22);
    }

    public Mat3(float[] f) {
        this(f, 0);
    }

    public Mat3(float[] f, int offset2) {
        this(f[offset2 + 0], f[offset2 + 1], f[offset2 + 2], f[offset2 + 3], f[offset2 + 4], f[offset2 + 5], f[offset2 + 6], f[offset2 + 7], f[offset2 + 8]);
    }

    public Mat3(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this((float)m00, (float)m01, (float)m02, (float)m10, (float)m11, (float)m12, (float)m20, (float)m21, (float)m22);
    }

    public Mat3(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public static Mat3 cast(Quat q) {
        Mat3 result = new Mat3();
        result.m00 = 1.0f - 2.0f * q.y * q.y - 2.0f * q.z * q.z;
        result.m01 = 2.0f * q.x * q.y + 2.0f * q.w * q.z;
        result.m02 = 2.0f * q.x * q.z - 2.0f * q.w * q.y;
        result.m10 = 2.0f * q.x * q.y - 2.0f * q.w * q.z;
        result.m11 = 1.0f - 2.0f * q.x * q.x - 2.0f * q.z * q.z;
        result.m12 = 2.0f * q.y * q.z + 2.0f * q.w * q.x;
        result.m20 = 2.0f * q.x * q.z + 2.0f * q.w * q.y;
        result.m21 = 2.0f * q.y * q.z - 2.0f * q.w * q.x;
        result.m22 = 1.0f - 2.0f * q.x * q.x - 2.0f * q.y * q.y;
        return result;
    }

    public Mat3 set() {
        return this.set(1.0f);
    }

    public Mat3 set(float f) {
        return this.set(f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, f);
    }

    public Mat3 set(Mat3 m) {
        return this.set(m.m00, m.m01, m.m02, m.m10, m.m11, m.m12, m.m20, m.m21, m.m22);
    }

    public Mat3 set(Mat4 m) {
        return this.set(m.m00, m.m01, m.m02, m.m10, m.m11, m.m12, m.m20, m.m21, m.m22);
    }

    public Mat3 set(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        return this;
    }

    public Mat3 set(int column, int row, float value) {
        if (column >= 0 && column < 3 && row >= 0 && row < 3) {
            float[] f = this.toFa_();
            f[column * 3 + row] = value;
            this.set(f);
        }
        return this;
    }

    public Mat3 set(float[] f) {
        return this.set(f, 0);
    }

    public Mat3 set(float[] f, int offset2) {
        this.set(f[offset2 + 0], f[offset2 + 1], f[offset2 + 2], f[offset2 + 3], f[offset2 + 4], f[offset2 + 5], f[offset2 + 6], f[offset2 + 7], f[offset2 + 8]);
        return this;
    }

    public Mat3 c0(Vec3 v) {
        return this.set(v.x, v.y, v.z, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public Mat3 c0(Vec2 v, float f) {
        return this.set(v.x, v.y, f, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public Mat3 c0(float x, float y, float z) {
        return this.set(x, y, z, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public Mat3 c1(Vec3 v) {
        return this.set(this.m00, this.m01, this.m02, v.x, v.y, v.z, this.m20, this.m21, this.m22);
    }

    public Mat3 c1(Vec2 v, float f) {
        return this.set(this.m00, this.m01, this.m02, v.x, v.y, f, this.m20, this.m21, this.m22);
    }

    public Mat3 c1(float x, float y, float z) {
        return this.set(this.m00, this.m01, this.m02, x, y, z, this.m20, this.m21, this.m22);
    }

    public Mat3 c2(Vec3 v) {
        return this.set(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, v.x, v.y, v.z);
    }

    public Mat3 c2(Vec2 v, float f) {
        return this.set(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, v.x, v.y, f);
    }

    public Mat3 c2(float x, float y, float z) {
        return this.set(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, x, y, z);
    }

    public Mat3 identity() {
        return this.set();
    }

    public Vec3 mul(Vec3 v) {
        return this.mul(v, new Vec3());
    }

    public Vec3 mul_(Vec3 v) {
        return this.mul(v, v);
    }

    public Vec3 mul(Vec3 right, Vec3 res) {
        res.set(this.m00 * right.x + this.m10 * right.y + this.m20 * right.z, this.m01 * right.x + this.m11 * right.y + this.m21 * right.z, this.m02 * right.x + this.m12 * right.y + this.m22 * right.z);
        return res;
    }

    public Mat3 mul_(Mat3 right) {
        return this.mul(right, new Mat3());
    }

    public Mat3 mul(Mat3 right) {
        return this.mul(right, this);
    }

    public Mat3 mul(Mat3 right, Mat3 dest) {
        dest.set(this.m00 * right.m00 + this.m10 * right.m01 + this.m20 * right.m02, this.m01 * right.m00 + this.m11 * right.m01 + this.m21 * right.m02, this.m02 * right.m00 + this.m12 * right.m01 + this.m22 * right.m02, this.m00 * right.m10 + this.m10 * right.m11 + this.m20 * right.m12, this.m01 * right.m10 + this.m11 * right.m11 + this.m21 * right.m12, this.m02 * right.m10 + this.m12 * right.m11 + this.m22 * right.m12, this.m00 * right.m20 + this.m10 * right.m21 + this.m20 * right.m22, this.m01 * right.m20 + this.m11 * right.m21 + this.m21 * right.m22, this.m02 * right.m20 + this.m12 * right.m21 + this.m22 * right.m22);
        return dest;
    }

    public boolean equals(Mat3 other) {
        return this.equals(other, 2);
    }

    public boolean equals(Mat3 other, int maxUlps) {
        if (!Mat3.compareFloatEquals(this.m00, other.m00, maxUlps)) {
            return false;
        }
        if (!Mat3.compareFloatEquals(this.m01, other.m01, maxUlps)) {
            return false;
        }
        if (!Mat3.compareFloatEquals(this.m02, other.m02, maxUlps)) {
            return false;
        }
        if (!Mat3.compareFloatEquals(this.m10, other.m10, maxUlps)) {
            return false;
        }
        if (!Mat3.compareFloatEquals(this.m11, other.m11, maxUlps)) {
            return false;
        }
        if (!Mat3.compareFloatEquals(this.m12, other.m12, maxUlps)) {
            return false;
        }
        if (!Mat3.compareFloatEquals(this.m20, other.m20, maxUlps)) {
            return false;
        }
        if (!Mat3.compareFloatEquals(this.m21, other.m21, maxUlps)) {
            return false;
        }
        return Mat3.compareFloatEquals(this.m22, other.m22, maxUlps);
    }

    public static boolean compareFloatEquals(float expected, float actual, int maxUlps) {
        int expectedBits = Float.floatToIntBits(expected) < 0 ? Integer.MIN_VALUE - Float.floatToIntBits(expected) : Float.floatToIntBits(expected);
        int actualBits = Float.floatToIntBits(actual) < 0 ? Integer.MIN_VALUE - Float.floatToIntBits(actual) : Float.floatToIntBits(actual);
        int difference = expectedBits > actualBits ? expectedBits - actualBits : actualBits - expectedBits;
        System.out.println("expected: " + expected + ", actual: " + actual);
        System.out.println("diff " + difference);
        return !Float.isNaN(expected) && !Float.isNaN(actual) && difference <= maxUlps;
    }

    public Mat4 toMat4_() {
        return this.toMat4(new Mat4());
    }

    public Mat4 toMat4(Mat4 res) {
        return res.set(this.m00, this.m01, this.m02, 0.0f, this.m10, this.m11, this.m12, 0.0f, this.m20, this.m21, this.m22, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public float[] toFa_() {
        return this.toFa(new float[9], 0);
    }

    public float[] toFa(float[] res) {
        return this.toFa(res, 0);
    }

    public float[] toFa(float[] res, int index) {
        res[index + 0] = this.m00;
        res[index + 1] = this.m01;
        res[index + 2] = this.m02;
        res[index + 3] = this.m10;
        res[index + 4] = this.m11;
        res[index + 5] = this.m12;
        res[index + 6] = this.m20;
        res[index + 7] = this.m21;
        res[index + 8] = this.m22;
        return res;
    }

    public ByteBuffer toDbb_() {
        return this.toDbb(ByteBuffer.allocateDirect(36).order(ByteOrder.nativeOrder()));
    }

    public ByteBuffer toDbb(ByteBuffer res) {
        return this.toDbb(res, 0);
    }

    public ByteBuffer toDbb(ByteBuffer res, int index) {
        res.putFloat(index + 0, this.m00);
        res.putFloat(index + 4, this.m01);
        res.putFloat(index + 8, this.m02);
        res.putFloat(index + 12, this.m10);
        res.putFloat(index + 16, this.m11);
        res.putFloat(index + 20, this.m12);
        res.putFloat(index + 24, this.m20);
        res.putFloat(index + 28, this.m21);
        res.putFloat(index + 32, this.m22);
        return res;
    }

    public FloatBuffer toDfb_() {
        return this.toDfb(ByteBuffer.allocateDirect(36).order(ByteOrder.nativeOrder()).asFloatBuffer());
    }

    public FloatBuffer toDfb(FloatBuffer res) {
        return this.toDfb(res, 0);
    }

    public FloatBuffer toDfb(FloatBuffer res, int index) {
        res.put(index + 0, this.m00);
        res.put(index + 1, this.m01);
        res.put(index + 2, this.m02);
        res.put(index + 3, this.m10);
        res.put(index + 4, this.m11);
        res.put(index + 5, this.m12);
        res.put(index + 6, this.m20);
        res.put(index + 7, this.m21);
        res.put(index + 8, this.m22);
        return res;
    }

    public void print() {
        this.print("", true);
    }

    public void print(String title) {
        this.print(title, true);
    }

    public void print(boolean outStream) {
        this.print("", outStream);
    }

    public void print(String title, boolean outStream) {
        String res = title + "\n| " + this.m00 + " " + this.m10 + " " + this.m20 + " |\n| " + this.m01 + " " + this.m11 + " " + this.m21 + " |\n| " + this.m02 + " " + this.m12 + " " + this.m22 + " |\n";
        if (outStream) {
            System.out.print(res);
        } else {
            System.err.print(res);
        }
    }
}

