/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.bomb.BlockTaint;
import com.hbm.config.BombConfig;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Meteorite {
    public void generate(World world, Random rand, int x, int y, int z) {
        List list = world.func_72839_b(null, new AxisAlignedBB((double)x - 7.5, (double)y - 7.5, (double)z - 7.5, (double)x + 7.5, (double)y + 7.5, (double)z + 7.5));
        y = Library.getGroundHeight(world, x, z);
        for (Entity e : list) {
            e.func_70097_a(ModDamageSource.meteorite, 1000.0f);
        }
        if (GeneralConfig.enableSpecialMeteors) {
            switch (rand.nextInt(300)) {
                case 0: {
                    ArrayList<ItemStack> list0 = new ArrayList<ItemStack>();
                    list0.add(new ItemStack(ModBlocks.block_meteor));
                    this.generateBox(world, rand, x, y, z, list0);
                    return;
                }
                case 1: {
                    ArrayList<ItemStack> list1 = new ArrayList<ItemStack>(this.getRandomOre(rand));
                    int i = list1.size();
                    for (int j = 0; j < i; ++j) {
                        list1.add(new ItemStack(Blocks.field_150348_b));
                    }
                    this.generateSphere7x7(world, rand, x, y, z, list1);
                    return;
                }
                case 2: {
                    ArrayList<ItemStack> list2 = new ArrayList<ItemStack>(this.getRandomOre(rand));
                    int k = list2.size() / 2;
                    for (int j = 0; j < k; ++j) {
                        list2.add(new ItemStack(Blocks.field_150348_b));
                    }
                    this.generateSphere5x5(world, rand, x, y, z, list2);
                    return;
                }
                case 3: {
                    ArrayList<ItemStack> list3 = new ArrayList<ItemStack>(this.getRandomOre(rand));
                    this.generateBox(world, rand, x, y, z, list3);
                    return;
                }
                case 4: {
                    world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 15.0f, true);
                    ExplosionLarge.spawnRubble(world, x, y, z, 25);
                    return;
                }
                case 5: {
                    ArrayList<ItemStack> list4 = new ArrayList<ItemStack>();
                    list4.add(new ItemStack(ModBlocks.block_meteor_treasure));
                    list4.add(new ItemStack(ModBlocks.block_meteor_broken));
                    this.generateSphere7x7(world, rand, x, y, z, list4);
                    return;
                }
                case 6: {
                    ArrayList<ItemStack> list5 = new ArrayList<ItemStack>();
                    list5.add(new ItemStack(ModBlocks.block_meteor_treasure));
                    list5.add(new ItemStack(ModBlocks.block_meteor_treasure));
                    list5.add(new ItemStack(ModBlocks.block_meteor_broken));
                    this.generateSphere5x5(world, rand, x, y, z, list5);
                    return;
                }
                case 7: {
                    ArrayList<ItemStack> list6 = new ArrayList<ItemStack>();
                    list6.add(new ItemStack(ModBlocks.block_meteor_treasure));
                    this.generateBox(world, rand, x, y, z, list6);
                    return;
                }
                case 8: {
                    ArrayList<ItemStack> list7 = new ArrayList<ItemStack>();
                    list7.add(new ItemStack(ModBlocks.block_meteor_treasure));
                    ArrayList<ItemStack> list8 = new ArrayList<ItemStack>();
                    list8.add(new ItemStack(ModBlocks.toxic_block));
                    this.generateSphere7x7(world, rand, x, y, z, list7);
                    this.generateSphere5x5(world, rand, x, y, z, list8);
                    return;
                }
                case 9: {
                    ArrayList<ItemStack> list9 = new ArrayList<ItemStack>();
                    list9.add(new ItemStack(ModBlocks.block_meteor_broken));
                    this.generateSphere9x9(world, rand, x, y, z, list9);
                    this.generateSphere7x7(world, rand, x, y, z, this.getRandomOre(rand));
                    return;
                }
                case 10: {
                    ArrayList<ItemStack> list10 = new ArrayList<ItemStack>();
                    list10.add(new ItemStack(ModBlocks.block_meteor_broken));
                    this.generateSphere5x5(world, rand, x, y, z, list10);
                    world.func_180501_a(new BlockPos(x, y, z), ModBlocks.taint.func_176223_P().func_177226_a((IProperty)BlockTaint.TEXTURE, (Comparable)Integer.valueOf(9)), 2);
                    return;
                }
                case 11: {
                    world.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(world, BombConfig.fatmanRadius, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                    if (rand.nextInt(100) == 0 || MainRegistry.polaroidID == 11) {
                        EntityNukeTorex.statFacBale(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, BombConfig.fatmanRadius);
                    } else {
                        EntityNukeTorex.statFac(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, BombConfig.fatmanRadius);
                    }
                    return;
                }
                case 12: {
                    world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 10.0f, true);
                    ItemStack stack = new ItemStack(ModItems.gun_b92);
                    stack.func_151001_c("\u00a79Star Blaster\u00a7r");
                    EntityItem blaster = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack);
                    world.func_72838_d((Entity)blaster);
                    return;
                }
            }
        }
        switch (rand.nextInt(3)) {
            case 0: {
                this.generateLarge(world, rand, x, y, z);
                break;
            }
            case 1: {
                this.generateMedium(world, rand, x, y, z);
                break;
            }
            case 2: {
                this.generateSmall(world, rand, x, y, z);
            }
        }
    }

    public void generateLarge(World world, Random rand, int x, int y, int z) {
        int hull = rand.nextInt(4);
        int outerPadding = 0;
        if (hull == 2) {
            outerPadding = 1 + rand.nextInt(2);
        } else if (hull == 3) {
            outerPadding = 2;
        }
        int innerPadding = rand.nextInt(hull == 0 ? 3 : 2);
        int core = rand.nextInt(2);
        if (innerPadding > 0) {
            core = 2;
        }
        ArrayList<ItemStack> hullL = new ArrayList<ItemStack>();
        switch (hull) {
            case 0: {
                hullL.add(new ItemStack(ModBlocks.block_meteor_molten));
                break;
            }
            case 1: {
                hullL.add(new ItemStack(ModBlocks.block_meteor_cobble));
                break;
            }
            case 2: {
                for (int i = 0; i < 99; ++i) {
                    hullL.add(new ItemStack(ModBlocks.block_meteor_broken));
                }
                hullL.add(new ItemStack(ModBlocks.block_meteor_treasure));
                break;
            }
            case 3: {
                hullL.add(new ItemStack(ModBlocks.block_meteor_molten));
                hullL.add(new ItemStack(ModBlocks.block_meteor_broken));
            }
        }
        ArrayList<ItemStack> opL = new ArrayList<ItemStack>();
        switch (outerPadding) {
            case 0: {
                opL.add(new ItemStack(ModBlocks.block_meteor_cobble));
                break;
            }
            case 1: {
                for (int i = 0; i < 99; ++i) {
                    opL.add(new ItemStack(ModBlocks.block_meteor_broken));
                }
                opL.add(new ItemStack(ModBlocks.block_meteor_treasure));
                break;
            }
            case 2: {
                opL.add(new ItemStack(ModBlocks.block_meteor_cobble));
                opL.add(new ItemStack(ModBlocks.block_meteor_broken));
            }
        }
        ArrayList<ItemStack> ipL = new ArrayList<ItemStack>();
        switch (innerPadding) {
            case 0: {
                for (int i = 0; i < 99; ++i) {
                    ipL.add(new ItemStack(ModBlocks.block_meteor_broken));
                }
                ipL.add(new ItemStack(ModBlocks.block_meteor_treasure));
                break;
            }
            case 1: {
                ipL.add(new ItemStack(ModBlocks.block_meteor_broken));
                break;
            }
            case 2: {
                ipL.add(new ItemStack(ModBlocks.block_meteor_cobble));
            }
        }
        ArrayList<ItemStack> coreL = new ArrayList<ItemStack>();
        switch (core) {
            case 0: {
                coreL.add(new ItemStack(ModBlocks.block_meteor));
                break;
            }
            case 1: {
                coreL.add(new ItemStack(ModBlocks.block_meteor_treasure));
                break;
            }
            case 2: {
                coreL.addAll(this.getRandomOre(rand));
            }
        }
        switch (rand.nextInt(5)) {
            case 0: {
                this.genL1(world, rand, x, y, z, hullL, opL, ipL, coreL);
                break;
            }
            case 1: {
                this.genL2(world, rand, x, y, z, hullL, opL, ipL, coreL);
                break;
            }
            case 2: {
                this.genL3(world, rand, x, y, z, hullL, opL, ipL, coreL);
                break;
            }
            case 3: {
                this.genL4(world, rand, x, y, z, hullL, opL, ipL, coreL);
                break;
            }
            case 4: {
                this.genL5(world, rand, x, y, z, hullL, opL, ipL, coreL);
            }
        }
    }

    public void generateMedium(World world, Random rand, int x, int y, int z) {
        int hull = rand.nextInt(4);
        int outerPadding = 0;
        if (hull == 2) {
            outerPadding = 1 + rand.nextInt(2);
        } else if (hull == 3) {
            outerPadding = 2;
        }
        int innerPadding = rand.nextInt(hull == 0 ? 3 : 2);
        int core = rand.nextInt(2);
        if (innerPadding > 0) {
            core = 2;
        }
        ArrayList<ItemStack> hullL = new ArrayList<ItemStack>();
        switch (hull) {
            case 0: {
                hullL.add(new ItemStack(ModBlocks.block_meteor_molten));
                break;
            }
            case 1: {
                hullL.add(new ItemStack(ModBlocks.block_meteor_cobble));
                break;
            }
            case 2: {
                for (int i = 0; i < 99; ++i) {
                    hullL.add(new ItemStack(ModBlocks.block_meteor_broken));
                }
                hullL.add(new ItemStack(ModBlocks.block_meteor_treasure));
                break;
            }
            case 3: {
                hullL.add(new ItemStack(ModBlocks.block_meteor_molten));
                hullL.add(new ItemStack(ModBlocks.block_meteor_broken));
            }
        }
        ArrayList<ItemStack> opL = new ArrayList<ItemStack>();
        switch (outerPadding) {
            case 0: {
                opL.add(new ItemStack(ModBlocks.block_meteor_cobble));
                break;
            }
            case 1: {
                for (int i = 0; i < 99; ++i) {
                    opL.add(new ItemStack(ModBlocks.block_meteor_broken));
                }
                opL.add(new ItemStack(ModBlocks.block_meteor_treasure));
                break;
            }
            case 2: {
                opL.add(new ItemStack(ModBlocks.block_meteor_cobble));
                opL.add(new ItemStack(ModBlocks.block_meteor_broken));
            }
        }
        ArrayList<ItemStack> ipL = new ArrayList<ItemStack>();
        switch (innerPadding) {
            case 0: {
                for (int i = 0; i < 99; ++i) {
                    ipL.add(new ItemStack(ModBlocks.block_meteor_broken));
                }
                ipL.add(new ItemStack(ModBlocks.block_meteor_treasure));
                break;
            }
            case 1: {
                ipL.add(new ItemStack(ModBlocks.block_meteor_broken));
                break;
            }
            case 2: {
                ipL.add(new ItemStack(ModBlocks.block_meteor_cobble));
            }
        }
        ArrayList<ItemStack> coreL = new ArrayList<ItemStack>();
        switch (core) {
            case 0: {
                coreL.add(new ItemStack(ModBlocks.block_meteor));
                break;
            }
            case 1: {
                coreL.add(new ItemStack(ModBlocks.block_meteor_treasure));
                break;
            }
            case 2: {
                coreL.addAll(this.getRandomOre(rand));
            }
        }
        ArrayList<ItemStack> sCore = new ArrayList<ItemStack>();
        switch (core) {
            case 0: {
                sCore.add(new ItemStack(ModBlocks.block_meteor));
                break;
            }
            case 1: {
                sCore.add(new ItemStack(ModBlocks.block_meteor_treasure));
                break;
            }
            case 2: {
                sCore.add(new ItemStack(ModBlocks.block_meteor_treasure));
                sCore.add(new ItemStack(ModBlocks.block_meteor));
            }
        }
        switch (rand.nextInt(6)) {
            case 0: {
                this.genM1(world, rand, x, y, z, hullL, opL, ipL, sCore);
                break;
            }
            case 1: {
                this.genM2(world, rand, x, y, z, hullL, opL, ipL, coreL);
                break;
            }
            case 2: {
                this.genM3(world, rand, x, y, z, hullL, opL, ipL, coreL);
                break;
            }
            case 3: {
                this.genM4(world, rand, x, y, z, hullL, opL, ipL, coreL);
                break;
            }
            case 4: {
                this.genM5(world, rand, x, y, z, hullL, opL, ipL, coreL);
                break;
            }
            case 5: {
                this.genM6(world, rand, x, y, z, hullL, opL, ipL, coreL);
            }
        }
    }

    public void generateSmall(World world, Random rand, int x, int y, int z) {
        int hull = rand.nextInt(4);
        int core = rand.nextInt(3);
        ArrayList<ItemStack> hullL = new ArrayList<ItemStack>();
        switch (hull) {
            case 0: {
                hullL.add(new ItemStack(ModBlocks.block_meteor_molten));
                break;
            }
            case 1: {
                hullL.add(new ItemStack(ModBlocks.block_meteor_cobble));
                break;
            }
            case 2: {
                for (int i = 0; i < 99; ++i) {
                    hullL.add(new ItemStack(ModBlocks.block_meteor_broken));
                }
                hullL.add(new ItemStack(ModBlocks.block_meteor_treasure));
                break;
            }
            case 3: {
                hullL.add(new ItemStack(ModBlocks.block_meteor_molten));
                hullL.add(new ItemStack(ModBlocks.block_meteor_broken));
            }
        }
        ArrayList<ItemStack> sCore = new ArrayList<ItemStack>();
        switch (core) {
            case 0: {
                sCore.add(new ItemStack(ModBlocks.block_meteor));
                break;
            }
            case 1: {
                sCore.add(new ItemStack(ModBlocks.block_meteor_treasure));
                break;
            }
            case 2: {
                sCore.add(new ItemStack(ModBlocks.block_meteor_treasure));
                sCore.add(new ItemStack(ModBlocks.block_meteor));
            }
        }
        this.generateBox(world, rand, x, y, z, hullL);
        this.setRandomBlock(world, (BlockPos)new BlockPos.MutableBlockPos(x, y, z), rand, sCore.size(), sCore);
    }

    public void genL1(World world, Random rand, int x, int y, int z, List<ItemStack> hull, List<ItemStack> op, List<ItemStack> ip, List<ItemStack> core) {
        this.generateSphere7x7(world, rand, x, y, z, hull);
        this.generateStar5x5(world, rand, x, y, z, op);
        this.generateStar3x3(world, rand, x, y, z, ip);
        this.setRandomBlock(world, (BlockPos)new BlockPos.MutableBlockPos(x, y, z), rand, core.size(), core);
    }

    public void genL2(World world, Random rand, int x, int y, int z, List<ItemStack> hull, List<ItemStack> op, List<ItemStack> ip, List<ItemStack> core) {
        this.generateSphere7x7(world, rand, x, y, z, hull);
        this.generateSphere5x5(world, rand, x, y, z, op);
        this.generateStar3x3(world, rand, x, y, z, ip);
        this.setRandomBlock(world, (BlockPos)new BlockPos.MutableBlockPos(x, y, z), rand, core.size(), core);
    }

    public void genL3(World world, Random rand, int x, int y, int z, List<ItemStack> hull, List<ItemStack> op, List<ItemStack> ip, List<ItemStack> core) {
        this.generateSphere7x7(world, rand, x, y, z, hull);
        this.generateSphere5x5(world, rand, x, y, z, op);
        this.generateBox(world, rand, x, y, z, ip);
        this.setRandomBlock(world, (BlockPos)new BlockPos.MutableBlockPos(x, y, z), rand, core.size(), core);
    }

    public void genL4(World world, Random rand, int x, int y, int z, List<ItemStack> hull, List<ItemStack> op, List<ItemStack> ip, List<ItemStack> core) {
        this.generateSphere7x7(world, rand, x, y, z, hull);
        this.generateSphere5x5(world, rand, x, y, z, op);
        this.generateBox(world, rand, x, y, z, ip);
        this.generateStar3x3(world, rand, x, y, z, this.getRandomOre(rand));
        this.setRandomBlock(world, (BlockPos)new BlockPos.MutableBlockPos(x, y, z), rand, core.size(), core);
    }

    public void genL5(World world, Random rand, int x, int y, int z, List<ItemStack> hull, List<ItemStack> op, List<ItemStack> ip, List<ItemStack> core) {
        this.generateSphere7x7(world, rand, x, y, z, hull);
        this.generateSphere5x5(world, rand, x, y, z, op);
        this.generateStar5x5(world, rand, x, y, z, ip);
        this.generateStar3x3(world, rand, x, y, z, this.getRandomOre(rand));
        this.setRandomBlock(world, (BlockPos)new BlockPos.MutableBlockPos(x, y, z), rand, core.size(), core);
    }

    public void genM1(World world, Random rand, int x, int y, int z, List<ItemStack> hull, List<ItemStack> op, List<ItemStack> ip, List<ItemStack> core) {
        this.generateSphere5x5(world, rand, x, y, z, hull);
        this.setRandomBlock(world, (BlockPos)new BlockPos.MutableBlockPos(x, y, z), rand, core.size(), core);
    }

    public void genM2(World world, Random rand, int x, int y, int z, List<ItemStack> hull, List<ItemStack> op, List<ItemStack> ip, List<ItemStack> core) {
        this.generateSphere5x5(world, rand, x, y, z, hull);
        this.generateStar3x3(world, rand, x, y, z, op);
        this.setRandomBlock(world, (BlockPos)new BlockPos.MutableBlockPos(x, y, z), rand, core.size(), core);
    }

    public void genM3(World world, Random rand, int x, int y, int z, List<ItemStack> hull, List<ItemStack> op, List<ItemStack> ip, List<ItemStack> core) {
        this.generateSphere5x5(world, rand, x, y, z, hull);
        this.generateBox(world, rand, x, y, z, op);
        this.setRandomBlock(world, (BlockPos)new BlockPos.MutableBlockPos(x, y, z), rand, core.size(), core);
    }

    public void genM4(World world, Random rand, int x, int y, int z, List<ItemStack> hull, List<ItemStack> op, List<ItemStack> ip, List<ItemStack> core) {
        this.generateSphere5x5(world, rand, x, y, z, hull);
        this.generateBox(world, rand, x, y, z, op);
        this.generateStar3x3(world, rand, x, y, z, ip);
        this.setRandomBlock(world, (BlockPos)new BlockPos.MutableBlockPos(x, y, z), rand, core.size(), core);
    }

    public void genM5(World world, Random rand, int x, int y, int z, List<ItemStack> hull, List<ItemStack> op, List<ItemStack> ip, List<ItemStack> core) {
        this.generateSphere5x5(world, rand, x, y, z, hull);
        this.generateBox(world, rand, x, y, z, ip);
        this.setRandomBlock(world, (BlockPos)new BlockPos.MutableBlockPos(x, y, z), rand, core.size(), core);
    }

    public void genM6(World world, Random rand, int x, int y, int z, List<ItemStack> hull, List<ItemStack> op, List<ItemStack> ip, List<ItemStack> core) {
        this.generateSphere5x5(world, rand, x, y, z, hull);
        this.generateBox(world, rand, x, y, z, ip);
        this.generateStar3x3(world, rand, x, y, z, this.getRandomOre(rand));
        this.setRandomBlock(world, (BlockPos)new BlockPos.MutableBlockPos(x, y, z), rand, core.size(), core);
    }

    public void generateSphere7x7(World world, Random rand, int x, int y, int z, List<ItemStack> set) {
        int c;
        int b;
        int a;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int setSize = set.size();
        for (a = -3; a < 4; ++a) {
            for (b = -1; b < 2; ++b) {
                for (c = -1; c < 2; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -1; a < 2; ++a) {
            for (b = -3; b < 4; ++b) {
                for (c = -1; c < 2; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -1; a < 2; ++a) {
            for (b = -1; b < 2; ++b) {
                for (c = -3; c < 4; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -2; a < 3; ++a) {
            for (b = -2; b < 3; ++b) {
                for (c = -1; c < 2; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -1; a < 2; ++a) {
            for (b = -2; b < 3; ++b) {
                for (c = -2; c < 3; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -2; a < 3; ++a) {
            for (b = -1; b < 2; ++b) {
                for (c = -2; c < 3; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
    }

    public void generateSphere5x5(World world, Random rand, int x, int y, int z, List<ItemStack> set) {
        int c;
        int b;
        int a;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int setSize = set.size();
        for (a = -2; a < 3; ++a) {
            for (b = -1; b < 2; ++b) {
                for (c = -1; c < 2; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -1; a < 2; ++a) {
            for (b = -2; b < 3; ++b) {
                for (c = -1; c < 2; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -1; a < 2; ++a) {
            for (b = -1; b < 2; ++b) {
                for (c = -2; c < 3; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
    }

    public void generateSphere9x9(World world, Random rand, int x, int y, int z, List<ItemStack> set) {
        int c;
        int b;
        int a;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int setSize = set.size();
        for (a = -4; a < 5; ++a) {
            for (b = -1; b < 2; ++b) {
                for (c = -1; c < 2; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -1; a < 2; ++a) {
            for (b = -4; b < 5; ++b) {
                for (c = -1; c < 2; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -1; a < 2; ++a) {
            for (b = -1; b < 2; ++b) {
                for (c = -4; c < 5; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -1; a < 2; ++a) {
            for (b = -3; b < 4; ++b) {
                for (c = -3; c < 4; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -3; a < 4; ++a) {
            for (b = -1; b < 2; ++b) {
                for (c = -3; c < 4; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -3; a < 4; ++a) {
            for (b = -3; b < 4; ++b) {
                for (c = -1; c < 2; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -3; a < 4; ++a) {
            for (b = -2; b < 3; ++b) {
                for (c = -2; c < 3; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -2; a < 3; ++a) {
            for (b = -3; b < 4; ++b) {
                for (c = -2; c < 3; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        for (a = -2; a < 3; ++a) {
            for (b = -2; b < 3; ++b) {
                for (c = -3; c < 4; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
    }

    public void generateBox(World world, Random rand, int x, int y, int z, List<ItemStack> set) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int setSize = set.size();
        for (int a = -1; a < 2; ++a) {
            for (int b = -1; b < 2; ++b) {
                for (int c = -1; c < 2; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
    }

    public void setRandomBlock(World world, BlockPos mPos, Random rand, int setSize, List<ItemStack> set) {
        this.setBlock(world, mPos, set.get(rand.nextInt(setSize)));
    }

    public void setBlock(World world, BlockPos mPos, ItemStack stack) {
        if (world.func_180495_p(mPos).func_177230_c().func_149638_a(null) < 3000000.0f) {
            world.func_180501_a(mPos, Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P(), 2);
        }
    }

    public void generateStar5x5(World world, Random rand, int x, int y, int z, List<ItemStack> set) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int setSize = set.size();
        for (int a = -1; a < 2; ++a) {
            for (int b = -1; b < 2; ++b) {
                for (int c = -1; c < 2; ++c) {
                    this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + a, y + b, z + c), rand, setSize, set);
                }
            }
        }
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + 2, y, z), rand, setSize, set);
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x - 2, y, z), rand, setSize, set);
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x, y + 2, z), rand, setSize, set);
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x, y - 2, z), rand, setSize, set);
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x, y, z + 2), rand, setSize, set);
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x, y, z - 2), rand, setSize, set);
    }

    public void generateStar3x3(World world, Random rand, int x, int y, int z, List<ItemStack> set) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int setSize = set.size();
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x, y, z), rand, setSize, set);
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x + 1, y, z), rand, setSize, set);
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x - 1, y, z), rand, setSize, set);
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x, y + 1, z), rand, setSize, set);
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x, y - 1, z), rand, setSize, set);
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x, y, z + 1), rand, setSize, set);
        this.setRandomBlock(world, (BlockPos)mPos.func_181079_c(x, y, z - 1), rand, setSize, set);
    }

    public List<ItemStack> getRandomOre(Random rand) {
        int i;
        ArrayList<ItemStack> ores = new ArrayList<ItemStack>();
        for (i = 0; i < 3; ++i) {
            ores.add(new ItemStack(ModBlocks.ore_meteor_uranium));
        }
        for (i = 0; i < 5; ++i) {
            ores.add(new ItemStack(ModBlocks.ore_meteor_thorium));
        }
        for (i = 0; i < 6; ++i) {
            ores.add(new ItemStack(ModBlocks.ore_meteor_titanium));
        }
        for (i = 0; i < 7; ++i) {
            ores.add(new ItemStack(ModBlocks.ore_meteor_sulfur));
        }
        for (i = 0; i < 8; ++i) {
            ores.add(new ItemStack(ModBlocks.ore_meteor_copper));
        }
        for (i = 0; i < 5; ++i) {
            ores.add(new ItemStack(ModBlocks.ore_meteor_tungsten));
        }
        for (i = 0; i < 7; ++i) {
            ores.add(new ItemStack(ModBlocks.ore_meteor_aluminium));
        }
        for (i = 0; i < 6; ++i) {
            ores.add(new ItemStack(ModBlocks.ore_meteor_lead));
        }
        for (i = 0; i < 4; ++i) {
            ores.add(new ItemStack(ModBlocks.ore_meteor_lithium));
        }
        for (i = 0; i < 1; ++i) {
            ores.add(new ItemStack(ModBlocks.ore_meteor_starmetal));
        }
        return ores;
    }
}

