/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.rbmk.RBMKBase;
import com.hbm.blocks.machine.rbmk.RBMKRod;
import com.hbm.config.MobConfig;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.DataValueString;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemRBMKRod;
import com.hbm.lib.ForgeDirection;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.tileentity.machine.rbmk.IRBMKFluxReceiver;
import com.hbm.tileentity.machine.rbmk.IRBMKLoadable;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKAbsorber;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControl;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKModerator;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKReflector;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class TileEntityRBMKRod
extends TileEntityRBMKSlottedBase
implements IRBMKFluxReceiver,
IRBMKLoadable {
    public double fluxFast;
    public double fluxSlow;
    public boolean hasRod;
    public double fluxOut = 0.0;
    public float fuelR;
    public float fuelG;
    public float fuelB;
    public float cherenkovR;
    public float cherenkovG;
    public float cherenkovB;
    public static final ForgeDirection[] fluxDirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    protected static IRBMKFluxReceiver.NType stream;

    public TileEntityRBMKRod() {
        super(1);
    }

    @Override
    public String getName() {
        return "container.rbmkRod";
    }

    @Override
    public boolean isModerated() {
        return ((RBMKRod)this.func_145838_q()).moderated;
    }

    @Override
    public void receiveFlux(IRBMKFluxReceiver.NType type, double flux) {
        switch (type) {
            case FAST: {
                this.fluxFast += flux;
                break;
            }
            case SLOW: {
                this.fluxSlow += flux;
            }
        }
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            Item item = this.inventory.getStackInSlot(0).func_77973_b();
            if (item instanceof ItemRBMKRod) {
                ItemRBMKRod rod = (ItemRBMKRod)item;
                this.fuelR = rod.fuelR;
                this.fuelG = rod.fuelG;
                this.fuelB = rod.fuelB;
                this.cherenkovR = rod.cherenkovR;
                this.cherenkovG = rod.cherenkovG;
                this.cherenkovB = rod.cherenkovB;
                double fluxIn = this.fluxFromType(rod.nType);
                this.fluxOut = rod.burn(this.field_145850_b, this.inventory.getStackInSlot(0), fluxIn);
                IRBMKFluxReceiver.NType rType = rod.rType;
                rod.updateHeat(this.field_145850_b, this.inventory.getStackInSlot(0), 1.0);
                this.heat += rod.provideHeat(this.field_145850_b, this.inventory.getStackInSlot(0), this.heat, 1.0);
                if (!this.hasLid()) {
                    RadiationSavedData.incrementRad(this.field_145850_b, this.field_174879_c, (float)((this.fluxFast + this.fluxSlow) * (double)0.05f), (float)((this.fluxFast + this.fluxSlow) * 10.0));
                } else {
                    double meltdownPercent = ItemRBMKRod.getMeltdownPercent(this.inventory.getStackInSlot(0));
                    if (meltdownPercent > 0.0) {
                        RadiationSavedData.incrementRad(this.field_145850_b, this.field_174879_c, (float)((this.fluxFast + this.fluxSlow) * (double)0.05f * meltdownPercent * 0.01), (float)((this.fluxFast + this.fluxSlow) * meltdownPercent * 0.1));
                    }
                }
                super.func_73660_a();
                this.fluxFast = 0.0;
                this.fluxSlow = 0.0;
                if (this.heat > this.maxHeat()) {
                    this.meltdown();
                    return;
                }
                if (this.fluxOut > 0.0) {
                    this.spreadFlux(this.isModerated() ? IRBMKFluxReceiver.NType.SLOW : rType, this.fluxOut);
                }
                this.hasRod = true;
            } else {
                this.fluxFast = 0.0;
                this.fluxSlow = 0.0;
                this.hasRod = false;
                super.func_73660_a();
            }
        }
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        if (itemStack.func_77973_b() instanceof ItemRBMKRod) {
            return !(ItemRBMKRod.getMeltdownPercent(itemStack) > 0.0);
        }
        return true;
    }

    private double fluxFromType(IRBMKFluxReceiver.NType type) {
        switch (type) {
            case SLOW: {
                return this.fluxFast * 0.5 + this.fluxSlow;
            }
            case FAST: {
                return this.fluxFast + this.fluxSlow * 0.3;
            }
            case ANY: {
                return this.fluxFast + this.fluxSlow;
            }
        }
        return 0.0;
    }

    protected void spreadFlux(IRBMKFluxReceiver.NType type, double fluxOut) {
        int range = RBMKDials.getFluxRange(this.field_145850_b);
        for (ForgeDirection dir : fluxDirs) {
            stream = type;
            double flux = fluxOut;
            for (int i = 1; i <= range && !((flux = this.runInteraction(this.field_174879_c.func_177958_n() + dir.offsetX * i, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ * i, flux)) <= 0.0); ++i) {
            }
        }
    }

    protected double runInteraction(int x, int y, int z, double flux) {
        IRBMKFluxReceiver rod;
        TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileEntityRBMKBase) {
            TileEntityRBMKBase base = (TileEntityRBMKBase)te;
            if (!base.hasLid()) {
                RadiationSavedData.incrementRad(this.field_145850_b, this.field_174879_c, (float)(flux * (double)0.05f), Float.MAX_VALUE);
            }
            if (base.isModerated()) {
                stream = IRBMKFluxReceiver.NType.SLOW;
            }
        }
        if (te instanceof TileEntityRBMKRod) {
            rod = (TileEntityRBMKRod)te;
            if (((TileEntityRBMKRod)rod).inventory.getStackInSlot(0).func_77973_b() instanceof ItemRBMKRod) {
                ((TileEntityRBMKRod)rod).receiveFlux(stream, flux);
                return 0.0;
            }
        }
        if (te instanceof IRBMKFluxReceiver) {
            rod = (IRBMKFluxReceiver)te;
            rod.receiveFlux(stream, flux);
            return 0.0;
        }
        if (te instanceof TileEntityRBMKControl) {
            TileEntityRBMKControl control = (TileEntityRBMKControl)te;
            if (control.getMult() == 0.0) {
                return 0.0;
            }
            return flux *= control.getMult();
        }
        if (te instanceof TileEntityRBMKModerator) {
            stream = IRBMKFluxReceiver.NType.SLOW;
            return flux;
        }
        if (te instanceof TileEntityRBMKReflector) {
            this.receiveFlux(this.isModerated() ? IRBMKFluxReceiver.NType.SLOW : stream, flux);
            return 0.0;
        }
        if (te instanceof TileEntityRBMKAbsorber) {
            return 0.0;
        }
        if (te instanceof TileEntityRBMKBase) {
            return flux;
        }
        int limit = RBMKDials.getColumnHeight(this.field_145850_b);
        int hits = 0;
        for (int h = 0; h <= limit; ++h) {
            if (this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_185914_p()) continue;
            ++hits;
        }
        if (hits > 0) {
            RadiationSavedData.incrementRad(this.field_145850_b, this.field_174879_c, (float)(flux * (double)0.05f * (double)hits / (double)limit), (float)(flux * (double)0.05f * (double)hits / (double)limit) * 10.0f);
        }
        return 0.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fluxFast = nbt.func_74769_h("fluxFast");
        this.fluxSlow = nbt.func_74769_h("fluxSlow");
        this.hasRod = nbt.func_74767_n("hasRod");
        this.fuelR = nbt.func_74760_g("fuelR");
        this.fuelG = nbt.func_74760_g("fuelG");
        this.fuelB = nbt.func_74760_g("fuelB");
        this.cherenkovR = nbt.func_74760_g("cherenkovR");
        this.cherenkovG = nbt.func_74760_g("cherenkovG");
        this.cherenkovB = nbt.func_74760_g("cherenkovB");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("fluxFast", this.fluxFast);
        nbt.func_74780_a("fluxSlow", this.fluxSlow);
        nbt.func_74757_a("hasRod", this.hasRod);
        nbt.func_74776_a("fuelR", this.fuelR);
        nbt.func_74776_a("fuelG", this.fuelG);
        nbt.func_74776_a("fuelB", this.fuelB);
        nbt.func_74776_a("cherenkovR", this.cherenkovR);
        nbt.func_74776_a("cherenkovG", this.cherenkovG);
        nbt.func_74776_a("cherenkovB", this.cherenkovB);
        return nbt;
    }

    @Override
    public void getDiagData(NBTTagCompound nbt) {
        this.func_189515_b(nbt);
        Item item = this.inventory.getStackInSlot(0).func_77973_b();
        if (item instanceof ItemRBMKRod) {
            ItemRBMKRod rod = (ItemRBMKRod)item;
            nbt.func_74778_a("f_yield", ItemRBMKRod.getYield(this.inventory.getStackInSlot(0)) + " / " + rod.yield + " (" + ItemRBMKRod.getEnrichment(this.inventory.getStackInSlot(0)) * 100.0 + "%)");
            nbt.func_74778_a("f_xenon", ItemRBMKRod.getPoison(this.inventory.getStackInSlot(0)) + "%");
            nbt.func_74778_a("f_heat", ItemRBMKRod.getCoreHeat(this.inventory.getStackInSlot(0)) + " / " + ItemRBMKRod.getHullHeat(this.inventory.getStackInSlot(0)) + " / " + rod.meltingPoint);
        }
        nbt.func_82580_o("fuelR");
        nbt.func_82580_o("fuelG");
        nbt.func_82580_o("fuelB");
        nbt.func_82580_o("cherenkovR");
        nbt.func_82580_o("cherenkovG");
        nbt.func_82580_o("cherenkovB");
        nbt.func_82580_o("jumpheight");
        nbt.func_82580_o("steam");
        nbt.func_82580_o("water");
    }

    @Override
    public void onMelt(int reduce) {
        boolean corium;
        int h = RBMKDials.getColumnHeight(this.field_145850_b);
        reduce = MathHelper.func_76125_a((int)reduce, (int)1, (int)h);
        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            ++reduce;
        }
        if ((corium = this.inventory.getStackInSlot(0).func_77973_b() instanceof ItemRBMKRod) && this.inventory.getStackInSlot(0).func_77973_b() == ModItems.rbmk_fuel_drx) {
            RBMKBase.digamma = true;
        }
        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        if (corium) {
            for (int i = h; i >= 0; --i) {
                if (i <= h + 1 - reduce) {
                    this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + i, this.field_174879_c.func_177952_p()), ModBlocks.corium_block.func_176223_P());
                } else {
                    this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + i, this.field_174879_c.func_177952_p()), Blocks.field_150350_a.func_176223_P());
                }
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177981_b(i));
                this.field_145850_b.func_184138_a(this.field_174879_c.func_177981_b(i), state, state, 3);
            }
            int count = 1 + this.field_145850_b.field_73012_v.nextInt(RBMKDials.getColumnHeight(this.field_145850_b) + 1);
            for (int i = 0; i < count; ++i) {
                this.spawnDebris(EntityRBMKDebris.DebrisType.FUEL);
            }
        } else {
            this.standardMelt(reduce);
        }
        this.spawnDebris(EntityRBMKDebris.DebrisType.ELEMENT);
        if (this.func_145832_p() == RBMKBase.DIR_NORMAL_LID.ordinal() + 10) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.LID);
        }
        if (MobConfig.enableElementals) {
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).func_72314_b(100.0, 100.0, 100.0));
            for (EntityPlayer player : players) {
                player.getEntityData().func_74775_l("PlayerPersisted").func_74757_a("radMark", true);
            }
        }
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.FUEL;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        if (this.inventory.getStackInSlot(0).func_77973_b() instanceof ItemRBMKRod) {
            ItemRBMKRod rod = (ItemRBMKRod)this.inventory.getStackInSlot(0).func_77973_b();
            data.func_74778_a("rod_name", rod.func_77658_a());
            data.func_74780_a("enrichment", ItemRBMKRod.getEnrichment(this.inventory.getStackInSlot(0)));
            data.func_74780_a("xenon", ItemRBMKRod.getPoison(this.inventory.getStackInSlot(0)));
            data.func_74780_a("c_heat", ItemRBMKRod.getHullHeat(this.inventory.getStackInSlot(0)));
            data.func_74780_a("c_coreHeat", ItemRBMKRod.getCoreHeat(this.inventory.getStackInSlot(0)));
            data.func_74780_a("c_maxHeat", rod.meltingPoint);
            data.func_74780_a("meltdown", ItemRBMKRod.getMeltdownPercent(this.inventory.getStackInSlot(0)));
        }
        data.func_74780_a("flux", this.fluxOut);
        return data;
    }

    @Override
    public boolean canLoad(ItemStack toLoad) {
        return toLoad != null && this.inventory.getStackInSlot(0).func_190926_b();
    }

    @Override
    public void load(ItemStack toLoad) {
        this.inventory.setStackInSlot(0, toLoad.func_77946_l());
        this.func_70296_d();
    }

    @Override
    public boolean canUnload() {
        return !this.inventory.getStackInSlot(0).func_190926_b();
    }

    @Override
    public ItemStack provideNext() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public void unload() {
        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        this.func_70296_d();
    }

    @Override
    public Map<String, DataValue> getQueryData() {
        Map<String, DataValue> data = super.getQueryData();
        Item item = this.inventory.getStackInSlot(0).func_77973_b();
        if (item instanceof ItemRBMKRod) {
            ItemRBMKRod rod = (ItemRBMKRod)item;
            data.put("rod_name", new DataValueString(rod.func_77658_a()));
            data.put("enrichment", new DataValueFloat((float)ItemRBMKRod.getEnrichment(this.inventory.getStackInSlot(0))));
            data.put("xenon", new DataValueFloat((float)ItemRBMKRod.getPoison(this.inventory.getStackInSlot(0))));
            data.put("c_heat", new DataValueFloat((float)ItemRBMKRod.getHullHeat(this.inventory.getStackInSlot(0))));
            data.put("c_coreHeat", new DataValueFloat((float)ItemRBMKRod.getCoreHeat(this.inventory.getStackInSlot(0))));
            data.put("c_maxHeat", new DataValueFloat((float)rod.meltingPoint));
            data.put("meltdown", new DataValueFloat((float)ItemRBMKRod.getMeltdownPercent(this.inventory.getStackInSlot(0))));
        }
        data.put("flux", new DataValueFloat((float)this.fluxOut));
        return data;
    }
}

