/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.tile.IHeatSource;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.CokerRecipes;
import com.hbm.inventory.container.ContainerMachineCoker;
import com.hbm.inventory.gui.GUIMachineCoker;
import com.hbm.lib.DirPos;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineCoker
extends TileEntityMachineBase
implements ITickable,
IGUIProvider,
IFluidHandler,
ITankPacketAcceptor {
    public boolean wasOn;
    public int progress;
    public static int processTime = 20000;
    public int heat;
    public static int maxHeat = 100000;
    public static double diffusion = 0.25;
    public FluidTank[] tanks = new FluidTank[2];

    public TileEntityMachineCoker() {
        super(1);
        this.tanks[0] = new FluidTank(16000);
        this.tanks[1] = new FluidTank(8000);
    }

    @Override
    public String getName() {
        return "container.machineCoker";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int burn;
            this.tryPullHeat();
            this.wasOn = false;
            if (this.canProcess() && (burn = this.heat / 100) > 0) {
                this.wasOn = true;
                this.progress += burn;
                this.heat -= burn;
                if (this.progress >= processTime) {
                    this.func_70296_d();
                    this.progress -= processTime;
                    if (this.tanks[0].getFluid() != null) {
                        Tuple.Triplet<Integer, ItemStack, FluidStack> recipe = CokerRecipes.getOutput(this.tanks[0].getFluid().getFluid());
                        int fillReq = recipe.getX();
                        ItemStack output = recipe.getY();
                        FluidStack byproduct = recipe.getZ();
                        if (output != null) {
                            if (this.inventory.getStackInSlot(0).func_190926_b()) {
                                this.inventory.setStackInSlot(0, output.func_77946_l());
                            } else {
                                this.inventory.getStackInSlot(0).func_190917_f(output.func_190916_E());
                            }
                        }
                        if (byproduct != null) {
                            this.tanks[1].fill(byproduct, true);
                        }
                        this.tanks[0].drain(fillReq, true);
                    }
                }
            }
            for (DirPos pos : this.getConPos()) {
                if (this.tanks[1].getFluidAmount() <= 0) continue;
                FFUtils.fillFluid(this, this.tanks[1], this.field_145850_b, pos.getPos(), 4000);
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("wasOn", this.wasOn);
            data.func_74768_a("heat", this.heat);
            data.func_74768_a("progress", this.progress);
            data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
            this.networkPack(data, 25);
        } else if (this.wasOn && this.field_145850_b.func_82737_E() % 2L == 0L) {
            NBTTagCompound fx = new NBTTagCompound();
            fx.func_74778_a("type", "tower");
            fx.func_74776_a("lift", 10.0f);
            fx.func_74776_a("base", 0.75f);
            fx.func_74776_a("max", 3.0f);
            fx.func_74768_a("life", 200 + this.field_145850_b.field_73012_v.nextInt(50));
            fx.func_74768_a("color", 0x404040);
            fx.func_74780_a("posX", (double)this.field_174879_c.func_177958_n() + 0.5);
            fx.func_74780_a("posY", (double)(this.field_174879_c.func_177956_o() + 22));
            fx.func_74780_a("posZ", (double)this.field_174879_c.func_177952_p() + 0.5);
            MainRegistry.proxy.effectNT(fx);
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1, Library.POS_X), new DirPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1, Library.POS_X), new DirPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1, Library.NEG_X), new DirPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1, Library.NEG_X), new DirPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2, Library.POS_Z), new DirPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2, Library.POS_Z), new DirPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2, Library.NEG_Z), new DirPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2, Library.NEG_Z)};
    }

    public boolean canProcess() {
        if (this.tanks[0].getFluid() == null) {
            return false;
        }
        Tuple.Triplet<Integer, ItemStack, FluidStack> recipe = CokerRecipes.getOutput(this.tanks[0].getFluid().getFluid());
        if (recipe == null) {
            return false;
        }
        int fillReq = recipe.getX();
        ItemStack output = recipe.getY();
        FluidStack byproduct = recipe.getZ();
        if (this.tanks[0].getFluidAmount() < fillReq) {
            return false;
        }
        if (byproduct != null && this.tanks[1].getFluid() != null) {
            if (byproduct.getFluid() != this.tanks[1].getFluid().getFluid()) {
                return false;
            }
            if (byproduct.amount + this.tanks[1].getFluidAmount() > this.tanks[1].getCapacity()) {
                return false;
            }
        }
        if (output != null && !this.inventory.getStackInSlot(0).func_190926_b()) {
            if (output.func_77973_b() != this.inventory.getStackInSlot(0).func_77973_b()) {
                return false;
            }
            if (output.func_77952_i() != this.inventory.getStackInSlot(0).func_77952_i()) {
                return false;
            }
            return output.func_190916_E() + this.inventory.getStackInSlot(0).func_190916_E() <= output.func_77976_d();
        }
        return true;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        super.networkUnpack(nbt);
        this.wasOn = nbt.func_74767_n("wasOn");
        this.heat = nbt.func_74762_e("heat");
        this.progress = nbt.func_74762_e("progress");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
    }

    protected void tryPullHeat() {
        if (this.heat >= maxHeat) {
            return;
        }
        TileEntity con = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, -1, 0));
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            int diff = source.getHeatStored() - this.heat;
            if (diff == 0) {
                return;
            }
            if (diff > 0) {
                diff = (int)Math.ceil((double)diff * diffusion);
                source.useUpHeat(diff);
                this.heat += diff;
                if (this.heat > maxHeat) {
                    this.heat = maxHeat;
                }
                return;
            }
        }
        this.heat = Math.max(this.heat - Math.max(this.heat / 1000, 1), 0);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{1};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
        this.progress = nbt.func_74762_e("prog");
        this.heat = nbt.func_74762_e("heat");
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        nbt.func_74768_a("prog", this.progress);
        nbt.func_74768_a("heat", this.heat);
        return super.func_189515_b(nbt);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineCoker(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineCoker(player.field_71071_by, this);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 2) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (CokerRecipes.getOutput(resource.getFluid()) != null && (this.tanks[0].getFluid() == null || resource.isFluidEqual(this.tanks[0].getFluid()))) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || this.tanks[1].getFluid() == null || resource.isFluidEqual(this.tanks[1].getFluid())) {
            return null;
        }
        return this.tanks[1].drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tanks[1].drain(maxDrain, doDrain);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

