/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.block.ICrucibleAcceptor;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.lib.ForgeDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileEntityFoundryBase
extends TileEntity
implements ITickable,
ICrucibleAcceptor {
    public NTMMaterial type;
    protected NTMMaterial lastType;
    public int amount;
    protected int lastAmount;

    public void func_73660_a() {
        if ((this.lastType != this.type || this.lastAmount != this.amount) && (!this.field_145850_b.field_72995_K || this.field_145850_b.field_72995_K && this.shouldClientReRender())) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 2);
            this.lastType = this.type;
            this.lastAmount = this.amount;
            this.func_70296_d();
        }
    }

    protected boolean shouldClientReRender() {
        return true;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = Mats.matById.get(nbt.func_74762_e("type"));
        this.amount = nbt.func_74762_e("amount");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.type == null) {
            nbt.func_74768_a("type", -1);
        } else {
            nbt.func_74768_a("type", this.type.id);
        }
        nbt.func_74768_a("amount", this.amount);
        return super.func_189515_b(nbt);
    }

    public abstract int getCapacity();

    public boolean standardCheck(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        if (this.type != null && this.type != stack.material && this.amount > 0) {
            return false;
        }
        return this.amount < this.getCapacity();
    }

    public Mats.MaterialStack standardAdd(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        this.type = stack.material;
        if (stack.amount + this.amount <= this.getCapacity()) {
            this.amount += stack.amount;
            return null;
        }
        int required = this.getCapacity() - this.amount;
        this.amount = this.getCapacity();
        stack.amount -= required;
        return stack;
    }

    @Override
    public boolean canAcceptPartialFlow(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        return this.standardCheck(world, p, side, stack);
    }

    @Override
    public Mats.MaterialStack flow(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        return this.standardAdd(world, p, side, stack);
    }

    @Override
    public boolean canAcceptPartialPour(World world, BlockPos p, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        if (side != ForgeDirection.UP) {
            return false;
        }
        return this.standardCheck(world, p, side, stack);
    }

    @Override
    public Mats.MaterialStack pour(World world, BlockPos p, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        return this.standardAdd(world, p, side, stack);
    }
}

