/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.FluidTypeHandler;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.block.Block;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityBarrel
extends TileEntityMachineBase
implements ITickable,
IFluidHandler,
ITankPacketAcceptor {
    public FluidTank tank;
    public short mode = 0;
    public static final short modes = 4;
    private int age = 0;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{1, 3};
    private static final int[] slots_side = new int[]{2};

    public TileEntityBarrel() {
        super(4);
        this.tank = new FluidTank(-1);
    }

    public TileEntityBarrel(int cap) {
        super(4);
        this.tank = new FluidTank(cap);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            FluidTank compareTank = FFUtils.copyTank(this.tank);
            FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 0, 1);
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 2, 3);
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (!(this.mode != 1 && this.mode != 2 || this.age != 9 && this.age != 19)) {
                this.fillFluidInit(this.tank);
            }
            if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0) {
                this.checkFluidInteraction();
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tank), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
            if (!FFUtils.areTanksEqual(this.tank, compareTank)) {
                this.func_70296_d();
            }
        }
    }

    public void checkFluidInteraction() {
        Block b = this.func_145838_q();
        Fluid f = this.tank.getFluid().getFluid();
        if (b != ModBlocks.barrel_antimatter && FluidTypeHandler.containsTrait(f, FluidTypeHandler.FluidTrait.AMAT)) {
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
            this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 5.0f, true, true);
        }
        if (b == ModBlocks.barrel_plastic && (FluidTypeHandler.isCorrosivePlastic(f) || FluidTypeHandler.isHot(f))) {
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (b == ModBlocks.barrel_iron && FluidTypeHandler.isCorrosivePlastic(f) || b == ModBlocks.barrel_steel && FluidTypeHandler.isCorrosiveIron(f)) {
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.field_145850_b.func_175656_a(this.field_174879_c, ModBlocks.barrel_corroded.func_176223_P());
            TileEntityBarrel corroded_barrel = (TileEntityBarrel)this.field_145850_b.func_175625_s(this.field_174879_c);
            corroded_barrel.tank.fill(this.tank.getFluid(), true);
        }
        if (b == ModBlocks.barrel_corroded && this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            this.tank.drain(1, true);
        }
    }

    public void fillFluidInit(FluidTank tank) {
        this.fillFluid(this.field_174879_c.func_177974_f(), tank);
        this.fillFluid(this.field_174879_c.func_177976_e(), tank);
        this.fillFluid(this.field_174879_c.func_177984_a(), tank);
        this.fillFluid(this.field_174879_c.func_177977_b(), tank);
        this.fillFluid(this.field_174879_c.func_177968_d(), tank);
        this.fillFluid(this.field_174879_c.func_177978_c(), tank);
    }

    public void fillFluid(BlockPos pos1, FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, pos1, 4000);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.mode == 2 || this.mode == 3) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.mode == 0 || this.mode == 3) {
            return null;
        }
        return this.tank.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.mode == 0 || this.mode == 3) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    public String getName() {
        return "container.barrel";
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74777_a("mode", this.mode);
        compound.func_74768_a("cap", this.tank.getCapacity());
        this.tank.writeToNBT(compound);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.mode = compound.func_74765_d("mode");
        if (this.tank == null || this.tank.getCapacity() <= 0) {
            this.tank = new FluidTank(compound.func_74762_e("cap"));
        }
        this.tank.readFromNBT(compound);
        super.func_145839_a(compound);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 1) {
            this.tank.readFromNBT(tags[0]);
        }
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int i = e.ordinal();
        return i == 0 ? slots_bottom : (i == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (i == 0) {
            return true;
        }
        return i == 2;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        if (slot == 1) {
            return true;
        }
        return slot == 3;
    }
}

