/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import api.hbm.energy.IEnergyUser;
import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.handler.MissileStruct;
import com.hbm.interfaces.IBomb;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemCustomMissile;
import com.hbm.items.weapon.ItemMissile;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEMissileMultipartPacket;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.TileEntityLoadedBase;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityCompactLauncher
extends TileEntityLoadedBase
implements ITickable,
IEnergyUser,
IFluidHandler,
ITankPacketAcceptor,
SimpleComponent {
    public ItemStackHandler inventory = new ItemStackHandler(8){

        protected void onContentsChanged(int slot) {
            TileEntityCompactLauncher.this.func_70296_d();
            super.onContentsChanged(slot);
        }
    };
    public long power;
    public static final long maxPower = 100000L;
    public int solid;
    public static final int maxSolid = 25000;
    public FluidTank[] tanks = new FluidTank[2];
    public Fluid[] tankTypes = new Fluid[2];
    public boolean needsUpdate;
    public MissileStruct load;
    private static final int[] access = new int[]{0};
    public static final int clearingDuraction = 100;
    public int clearingTimer = 0;
    private String customName;

    public TileEntityCompactLauncher() {
        this.tanks[0] = new FluidTank(25000);
        this.tankTypes[0] = null;
        this.tanks[1] = new FluidTank(25000);
        this.tankTypes[1] = null;
        this.needsUpdate = false;
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.compactLauncher";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public int getSolidScaled(int i) {
        return this.solid * i / 25000;
    }

    public void func_73660_a() {
        block14: {
            block15: {
                this.updateTypes();
                if (this.field_145850_b.field_72995_K) break block15;
                if (this.clearingTimer > 0) {
                    --this.clearingTimer;
                }
                if (this.inputValidForTank(0, 2) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 2, 6)) {
                    this.needsUpdate = true;
                }
                if (this.inputValidForTank(1, 3) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 3, 7)) {
                    this.needsUpdate = true;
                }
                this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 5, this.power, 100000L);
                if (this.inventory.getStackInSlot(4).func_77973_b() == ModItems.rocket_fuel && this.solid + 250 <= 25000) {
                    if (this.inventory.getStackInSlot(4).func_190916_E() <= 1) {
                        this.inventory.setStackInSlot(4, ItemStack.field_190927_a);
                    }
                    this.inventory.getStackInSlot(4).func_77979_a(1);
                    if (this.inventory.getStackInSlot(4).func_190926_b()) {
                        this.inventory.setStackInSlot(4, ItemStack.field_190927_a);
                    }
                    this.solid += 250;
                }
                if (this.needsUpdate) {
                    this.needsUpdate = false;
                }
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    this.updateConnections();
                }
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c, this.solid, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c, this.clearingTimer, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks[0], this.tanks[1]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
                MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.inventory.getStackInSlot(0));
                if (multipart != null) {
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEMissileMultipartPacket(this.field_174879_c, multipart), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 200.0));
                } else {
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEMissileMultipartPacket(this.field_174879_c, new MissileStruct()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 200.0));
                }
                if (!this.canLaunch()) break block14;
                BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (this.field_145850_b.func_175687_A((BlockPos)mPos.func_181079_c(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + z)) <= 0) continue;
                        this.launch();
                        break block14;
                    }
                }
                break block14;
            }
            List entities = this.field_145850_b.func_72839_b(null, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() - 0.5, (double)this.field_174879_c.func_177958_n() + 1.5, (double)(this.field_174879_c.func_177956_o() + 10), (double)this.field_174879_c.func_177952_p() + 1.5));
            for (Entity e : entities) {
                if (!(e instanceof EntityMissileCustom)) continue;
                for (int i = 0; i < 15; ++i) {
                    MainRegistry.proxy.spawnParticle((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.25, (double)this.field_174879_c.func_177952_p() + 0.5, "launchsmoke", null);
                }
                break;
            }
        }
    }

    private void updateConnections() {
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 1), ForgeDirection.EAST);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 1), ForgeDirection.EAST);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, -1), ForgeDirection.EAST);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 1), ForgeDirection.WEST);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, -1), ForgeDirection.WEST);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, 2), ForgeDirection.NORTH);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, 2), ForgeDirection.NORTH);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, -2), ForgeDirection.SOUTH);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, -2), ForgeDirection.SOUTH);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, -1, 1), ForgeDirection.DOWN);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, -1, -1), ForgeDirection.DOWN);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, -1, 1), ForgeDirection.DOWN);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, -1, -1), ForgeDirection.DOWN);
    }

    public boolean canLaunch() {
        return (double)this.power >= 75000.0 && this.isMissileValid() && this.hasDesignator() && this.hasFuel() && this.clearingTimer == 0;
    }

    public void launch() {
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.missileTakeoff, SoundCategory.BLOCKS, 10.0f, 1.0f);
        int tX = this.inventory.getStackInSlot(1).func_77978_p().func_74762_e("xCoord");
        int tZ = this.inventory.getStackInSlot(1).func_77978_p().func_74762_e("zCoord");
        ItemMissile chip = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(this.inventory.getStackInSlot(0), "chip"));
        float c = ((Float)chip.attributes[0]).floatValue();
        float f = 1.0f;
        if (TileEntityCompactLauncher.getStruct((ItemStack)this.inventory.getStackInSlot((int)0)).fins != null) {
            ItemMissile fins = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(this.inventory.getStackInSlot(0), "stability"));
            f = ((Float)fins.attributes[0]).floatValue();
        }
        Vec3 target = Vec3.createVectorHelper(this.field_174879_c.func_177958_n() - tX, 0.0, this.field_174879_c.func_177952_p() - tZ);
        target.xCoord *= (double)(c * f);
        target.zCoord *= (double)(c * f);
        target.rotateAroundY(this.field_145850_b.field_73012_v.nextFloat() * 360.0f);
        EntityMissileCustom missile = new EntityMissileCustom(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 1.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, tX + (int)target.xCoord, tZ + (int)target.zCoord, TileEntityCompactLauncher.getStruct(this.inventory.getStackInSlot(0)));
        this.field_145850_b.func_72838_d((Entity)missile);
        this.subtractFuel();
        this.clearingTimer = 100;
        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
    }

    private boolean hasFuel() {
        return this.solidState() != 0 && this.liquidState() != 0 && this.oxidizerState() != 0;
    }

    private void subtractFuel() {
        MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.inventory.getStackInSlot(0));
        if (multipart == null || multipart.fuselage == null) {
            return;
        }
        ItemMissile fuselage = multipart.fuselage;
        float f = ((Float)fuselage.attributes[1]).floatValue();
        int fuel = (int)f;
        switch ((ItemMissile.FuelType)((Object)fuselage.attributes[0])) {
            case KEROSENE: {
                this.tanks[0].drain(fuel, true);
                this.tanks[1].drain(fuel, true);
                break;
            }
            case HYDROGEN: {
                this.tanks[0].drain(fuel, true);
                this.tanks[1].drain(fuel, true);
                break;
            }
            case XENON: {
                this.tanks[0].drain(fuel, true);
                break;
            }
            case BALEFIRE: {
                this.tanks[0].drain(fuel, true);
                this.tanks[1].drain(fuel, true);
                break;
            }
            case SOLID: {
                this.solid -= fuel;
                break;
            }
        }
        this.needsUpdate = true;
        this.power = (long)((double)this.power - 75000.0);
    }

    protected boolean inputValidForTank(int tank, int slot) {
        if (this.tanks[tank] != null) {
            return this.isValidFluidForTank(tank, FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
        }
        return false;
    }

    private boolean isValidFluidForTank(int tank, FluidStack stack) {
        if (stack == null || this.tanks[tank] == null) {
            return false;
        }
        return stack.getFluid() == this.tankTypes[tank];
    }

    public static MissileStruct getStruct(ItemStack stack) {
        return ItemCustomMissile.getStruct(stack);
    }

    public boolean isMissileValid() {
        MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.inventory.getStackInSlot(0));
        if (multipart == null || multipart.fuselage == null) {
            return false;
        }
        ItemMissile fuselage = multipart.fuselage;
        return fuselage.top == ItemMissile.PartSize.SIZE_10;
    }

    public boolean hasDesignator() {
        if (!this.inventory.getStackInSlot(1).func_190926_b()) {
            return (this.inventory.getStackInSlot(1).func_77973_b() == ModItems.designator || this.inventory.getStackInSlot(1).func_77973_b() == ModItems.designator_range || this.inventory.getStackInSlot(1).func_77973_b() == ModItems.designator_manual) && this.inventory.getStackInSlot(1).func_77942_o();
        }
        return false;
    }

    public int solidState() {
        MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.inventory.getStackInSlot(0));
        if (multipart == null || multipart.fuselage == null) {
            return -1;
        }
        ItemMissile fuselage = multipart.fuselage;
        if ((ItemMissile.FuelType)((Object)fuselage.attributes[0]) == ItemMissile.FuelType.SOLID) {
            if ((float)this.solid >= ((Float)fuselage.attributes[1]).floatValue()) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public int liquidState() {
        MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.inventory.getStackInSlot(0));
        if (multipart == null || multipart.fuselage == null) {
            return -1;
        }
        ItemMissile fuselage = multipart.fuselage;
        switch ((ItemMissile.FuelType)((Object)fuselage.attributes[0])) {
            case KEROSENE: 
            case HYDROGEN: 
            case XENON: 
            case BALEFIRE: {
                if ((float)this.tanks[0].getFluidAmount() >= ((Float)fuselage.attributes[1]).floatValue()) {
                    return 1;
                }
                return 0;
            }
        }
        return -1;
    }

    public int oxidizerState() {
        MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.inventory.getStackInSlot(0));
        if (multipart == null || multipart.fuselage == null) {
            return -1;
        }
        ItemMissile fuselage = multipart.fuselage;
        switch ((ItemMissile.FuelType)((Object)fuselage.attributes[0])) {
            case KEROSENE: 
            case HYDROGEN: 
            case BALEFIRE: {
                if ((float)this.tanks[1].getFluidAmount() >= ((Float)fuselage.attributes[1]).floatValue()) {
                    return 1;
                }
                return 0;
            }
        }
        return -1;
    }

    public void updateTypes() {
        MissileStruct multipart = TileEntityCompactLauncher.getStruct(this.inventory.getStackInSlot(0));
        if (multipart == null || multipart.fuselage == null) {
            return;
        }
        ItemMissile fuselage = multipart.fuselage;
        switch ((ItemMissile.FuelType)((Object)fuselage.attributes[0])) {
            case KEROSENE: {
                this.tankTypes[0] = ModForgeFluids.KEROSENE_REFORM;
                this.tankTypes[1] = ModForgeFluids.ACID;
                break;
            }
            case HYDROGEN: {
                this.tankTypes[0] = ModForgeFluids.HYDROGEN;
                this.tankTypes[1] = ModForgeFluids.OXYGEN;
                break;
            }
            case XENON: {
                this.tankTypes[0] = ModForgeFluids.XENON;
                break;
            }
            case BALEFIRE: {
                this.tankTypes[0] = ModForgeFluids.BALEFIRE;
                this.tankTypes[1] = ModForgeFluids.ACID;
                break;
            }
        }
        if (this.tanks[0].getFluid() != null && this.tanks[0].getFluid().getFluid() != this.tankTypes[0]) {
            this.tanks[0].drain(this.tanks[0].getCapacity(), true);
        }
        if (this.tanks[1].getFluid() != null && this.tanks[1].getFluid().getFluid() != this.tankTypes[1]) {
            this.tanks[1].drain(this.tanks[1].getCapacity(), true);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (compound.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(compound.func_150295_c("tanks", 10), this.tanks);
        }
        if (compound.func_74764_b("tankType0")) {
            this.tankTypes[0] = FluidRegistry.getFluid((String)compound.func_74779_i("tankType0"));
        }
        if (compound.func_74764_b("tankType1")) {
            this.tankTypes[1] = FluidRegistry.getFluid((String)compound.func_74779_i("tankType1"));
        }
        this.solid = compound.func_74762_e("solidfuel");
        this.power = compound.func_74763_f("power");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        if (this.tankTypes[0] != null) {
            compound.func_74778_a("tankType0", this.tankTypes[0].getName());
        }
        if (this.tankTypes[1] != null) {
            compound.func_74778_a("tankType1", this.tankTypes[1].getName());
        }
        compound.func_74768_a("solidfuel", this.solid);
        compound.func_74772_a("power", this.power);
        return super.func_189515_b(compound);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() == this.tankTypes[0]) {
            return this.tanks[0].fill(resource, doFill);
        }
        if (resource.getFluid() == this.tankTypes[1]) {
            return this.tanks[1].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 2) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean setCoords(int x, int z) {
        if (!(this.inventory.getStackInSlot(1).func_190926_b() || this.inventory.getStackInSlot(1).func_77973_b() != ModItems.designator && this.inventory.getStackInSlot(1).func_77973_b() != ModItems.designator_range && this.inventory.getStackInSlot(1).func_77973_b() != ModItems.designator_manual)) {
            NBTTagCompound nbt = this.inventory.getStackInSlot(1).func_77942_o() ? this.inventory.getStackInSlot(1).func_77978_p() : new NBTTagCompound();
            nbt.func_74768_a("xCoord", x);
            nbt.func_74768_a("zCoord", z);
            this.inventory.getStackInSlot(1).func_77982_d(nbt);
            return true;
        }
        return false;
    }

    public String getComponentName() {
        return "launchpad_compact";
    }

    @Callback(doc="setTarget(x:int, z:int); saves coords in target designator item - returns true if it worked")
    public Object[] setTarget(Context context, Arguments args) {
        int x = args.checkInteger(0);
        int z = args.checkInteger(1);
        return new Object[]{this.setCoords(x, z)};
    }

    @Callback(doc="launch(); tries to launch the rocket")
    public Object[] launch(Context context, Arguments args) {
        Block b = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (b instanceof IBomb) {
            ((IBomb)b).explode(this.field_145850_b, this.field_174879_c);
        }
        return new Object[]{null};
    }
}

