/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.render.model.ModelPylon;
import com.hbm.tileentity.network.energy.TileEntityPylon;
import com.hbm.tileentity.network.energy.TileEntityPylonBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;

public class RenderPylon
extends TileEntitySpecialRenderer<TileEntityPylon> {
    private static final ResourceLocation texture = new ResourceLocation("hbm:textures/models/network/ModelPylon.png");
    private static final float cableColorR = 0.16f;
    private static final float cableColorG = 0.16f;
    private static final float cableColorB = 0.16f;
    private ModelPylon pylon = new ModelPylon();

    public boolean isGlobalRenderer(TileEntityPylon te) {
        return true;
    }

    public void render(TileEntityPylon pyl, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f - 0.875f), (float)((float)z + 0.5f));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_147499_a(texture);
        this.pylon.renderAll(0.0625f);
        GL11.glPopMatrix();
        RenderPylon.renderPowerLines(pyl, x, y, z);
    }

    public static void renderPowerLines(TileEntityPylonBase pyl, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        for (int i = 0; i < pyl.connected.size(); ++i) {
            BlockPos otherPylon = pyl.connected.get(i);
            TileEntity tile = pyl.func_145831_w().func_175625_s(otherPylon);
            if (!(tile instanceof TileEntityPylonBase)) continue;
            TileEntityPylonBase pylon = (TileEntityPylonBase)tile;
            Vec3[] m1 = pyl.getMountPos();
            Vec3[] m2 = pylon.getMountPos();
            int lineCount = Math.max(pyl.getConnectionType() == TileEntityPylonBase.ConnectionType.QUAD ? 4 : 1, pylon.getConnectionType() == TileEntityPylonBase.ConnectionType.QUAD ? 4 : 1);
            for (int line = 0; line < lineCount; ++line) {
                int secondIndex = line % m2.length;
                if (lineCount == 4 && (pyl.func_145832_p() - 10 == 5 && pylon.func_145832_p() - 10 == 2 || pyl.func_145832_p() - 10 == 2 && pylon.func_145832_p() - 10 == 5)) {
                    secondIndex += 2;
                    secondIndex %= m2.length;
                }
                Vec3 first = m1[line % m1.length];
                Vec3 second = m2[secondIndex];
                Vec3 mid = new Vec3(otherPylon).add(second).subtract(new Vec3(pyl.func_174877_v()).add(first));
                RenderPylon.drawLine(first, first.add(new Vec3(mid.xCoord * 0.5, mid.yCoord * 0.5, mid.zCoord * 0.5)), lineCount == 1 ? 0.03125f : 0.055f, mid.length() * 0.045);
            }
        }
        GL11.glPopMatrix();
    }

    public static void drawLine(Vec3 firstPylonMountPos, Vec3 secoundPylonMountPos, float girth, double hang) {
        float count = 10.0f;
        Vec3 deltaVector = secoundPylonMountPos.subtract(firstPylonMountPos);
        for (float j = 0.0f; j < count; j += 1.0f) {
            float k = j + 1.0f;
            RenderPylon.drawLineSegment(firstPylonMountPos.xCoord + deltaVector.xCoord * (double)j / (double)count, firstPylonMountPos.yCoord + deltaVector.yCoord * (double)j / (double)count - hang * Math.sin((double)(j / count) * Math.PI * 0.5), firstPylonMountPos.zCoord + deltaVector.zCoord * (double)j / (double)count, firstPylonMountPos.xCoord + deltaVector.xCoord * (double)k / (double)count, firstPylonMountPos.yCoord + deltaVector.yCoord * (double)k / (double)count - hang * Math.sin((double)(k / count) * Math.PI * 0.5), firstPylonMountPos.zCoord + deltaVector.zCoord * (double)k / (double)count, girth);
        }
    }

    public static void drawLineSegment(double x, double y, double z, double a, double b, double c, float girth) {
        GL11.glDisable((int)3553);
        GlStateManager.func_179140_f();
        GL11.glDisable((int)2884);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        buf.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        buf.func_181662_b(x, y + (double)girth, z).func_181666_a(0.16f, 0.16f, 0.16f, 1.0f).func_181675_d();
        buf.func_181662_b(x, y - (double)girth, z).func_181666_a(0.16f, 0.16f, 0.16f, 1.0f).func_181675_d();
        buf.func_181662_b(a, b + (double)girth, c).func_181666_a(0.16f, 0.16f, 0.16f, 1.0f).func_181675_d();
        buf.func_181662_b(a, b - (double)girth, c).func_181666_a(0.16f, 0.16f, 0.16f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        buf.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        buf.func_181662_b(x + (double)girth, y, z).func_181666_a(0.16f, 0.16f, 0.16f, 1.0f).func_181675_d();
        buf.func_181662_b(x - (double)girth, y, z).func_181666_a(0.16f, 0.16f, 0.16f, 1.0f).func_181675_d();
        buf.func_181662_b(a + (double)girth, b, c).func_181666_a(0.16f, 0.16f, 0.16f, 1.0f).func_181675_d();
        buf.func_181662_b(a - (double)girth, b, c).func_181666_a(0.16f, 0.16f, 0.16f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        buf.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        buf.func_181662_b(x, y, z + (double)girth).func_181666_a(0.16f, 0.16f, 0.16f, 1.0f).func_181675_d();
        buf.func_181662_b(x, y, z - (double)girth).func_181666_a(0.16f, 0.16f, 0.16f, 1.0f).func_181675_d();
        buf.func_181662_b(a, b, c + (double)girth).func_181666_a(0.16f, 0.16f, 0.16f, 1.0f).func_181675_d();
        buf.func_181662_b(a, b, c - (double)girth).func_181666_a(0.16f, 0.16f, 0.16f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
    }
}

