/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hbm.config.GeneralConfig;
import com.hbm.interfaces.IPostRender;
import com.hbm.items.weapon.ItemSwordCutter;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.main.ModEventHandlerClient;
import com.hbm.packet.AuxButtonPacket;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.particle.ParticleCrucibleLightning;
import com.hbm.render.anim.HbmAnimations;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCrucible
extends ItemSwordCutter
implements IPostRender {
    public static boolean doSpecialClick = false;

    public ItemCrucible(float damage, double movement, Item.ToolMaterial material, String s) {
        super(damage, movement, material, s);
    }

    @Override
    public void onEquip(EntityPlayer player, EnumHand hand) {
        super.onEquip(player, hand);
        if (ItemCrucible.getCharges(player.func_184586_b(hand)) == 0) {
            return;
        }
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", "sound");
        tag.func_74778_a("mode", "crucible_loop");
        tag.func_74768_a("playerId", player.func_145782_y());
        PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxParticlePacketNT(tag, 0.0, 0.0, 0.0), (Entity)player);
        PacketDispatcher.sendTo(new AuxParticlePacketNT(tag, 0.0, 0.0, 0.0), (EntityPlayerMP)player);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            items.add((Object)ItemCrucible.charge(new ItemStack((Item)this)));
        }
    }

    @Override
    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (!(entityLiving instanceof EntityPlayerMP)) {
            super.onEntitySwing(entityLiving, stack);
            return true;
        }
        if (!doSpecialClick) {
            EnumHand hand = stack == entityLiving.func_184614_ca() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("type", "anim");
            nbt.func_74768_a("hand", hand.ordinal());
            nbt.func_74778_a("mode", "cSwing");
            nbt.func_74778_a("name", this.getRegistryName().func_110623_a());
            PacketDispatcher.wrapper.sendTo((IMessage)new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), (EntityPlayerMP)entityLiving);
        }
        if (ItemCrucible.getCharges(stack) > 0) {
            entityLiving.field_70170_p.func_184148_a(null, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, HBMSoundHandler.crucibleSwing, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public byte getTexId() {
        return 1;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (isSelected && worldIn.field_72995_K && ItemCrucible.getCharges(stack) > 0 && entityIn instanceof EntityPlayer) {
            this.updateClient(worldIn, (EntityPlayer)entityIn, itemSlot);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateClient(World w, EntityPlayer player, int slot) {
        if (player != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        HbmAnimations.Animation anim = HbmAnimations.hotbar[slot];
        if (clicked || anim != null && anim.animation != null && anim.animation.getBus("SWING") != null) {
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(0, 0, 0, 1, 1000));
        } else {
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(0, 0, 0, 0, 1000));
        }
        boolean flag = false;
        if (anim instanceof HbmAnimations.BlenderAnimation && (float)(System.currentTimeMillis() - ((HbmAnimations.BlenderAnimation)anim).wrapper.startTime) > (float)((HbmAnimations.BlenderAnimation)anim).wrapper.anim.length * 0.7f) {
            flag = true;
        }
        if (flag && w.field_73012_v.nextInt(20) == 0) {
            ModEventHandlerClient.firstPersonAuxParticles.add(new ParticleCrucibleLightning(w, 0.0, (w.field_73012_v.nextFloat() - 0.5f) * 0.2f, 0.7f - w.field_73012_v.nextFloat() * 0.25f).lifetime(10));
        }
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase victim, EntityLivingBase attacker) {
        if (!doSpecialClick) {
            ItemCrucible.discharge(stack);
            if (!attacker.field_70170_p.field_72995_K && ItemCrucible.getCharges(stack) > 0 && !victim.func_70089_S()) {
                int count = Math.min((int)Math.ceil((double)victim.func_110138_aP() / 3.0), 250);
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaburst");
                data.func_74768_a("count", count * 4);
                data.func_74780_a("motion", 0.1);
                data.func_74778_a("mode", "blockdust");
                data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150451_bX));
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, victim.field_70165_t, victim.field_70163_u + (double)victim.field_70131_O * 0.5, victim.field_70161_v), new NetworkRegistry.TargetPoint(victim.field_71093_bK, victim.field_70165_t, victim.field_70163_u + (double)victim.field_70131_O * 0.5, victim.field_70161_v, 50.0));
            }
        }
        return super.func_77644_a(stack, victim, attacker);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        String charge = TextFormatting.RED + "Charge [";
        int charges = ItemCrucible.getCharges(stack);
        for (int i = 0; i < GeneralConfig.crucibleMaxCharges; ++i) {
            charge = charges > i ? charge + "||||||" : charge + "   ";
        }
        charge = charge + "]";
        list.add(charge);
    }

    public static int getCharges(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("charges");
        }
        return 0;
    }

    public static ItemStack charge(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("charges", GeneralConfig.crucibleMaxCharges);
        return stack;
    }

    public static void discharge(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("charges", Math.max(0, ItemCrucible.getCharges(stack) - 1));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ItemCrucible.getCharges(stack) / (double)GeneralConfig.crucibleMaxCharges;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        boolean charged;
        HashMultimap map = HashMultimap.create();
        boolean bl = charged = ItemCrucible.getCharges(stack) > 0;
        if (slot == EntityEquipmentSlot.MAINHAND) {
            map.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("91AEAA56-376B-4498-935B-2F7F68070635"), "Tool modifier", charged ? this.movement : this.movement * (double)0.8f, 1));
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", charged ? (double)this.damage : 5.0, 0));
        }
        return map;
    }
}

