/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.hbm.blocks.ModBlocks;
import com.hbm.handler.ArmorModHandler;
import com.hbm.items.ISatChip;
import com.hbm.items.armor.ItemArmorMod;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.satellites.Satellite;
import com.hbm.saveddata.satellites.SatelliteSavedData;
import com.hbm.saveddata.satellites.SatelliteScanner;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemModLens
extends ItemArmorMod
implements ISatChip {
    public static int countLimit = 100;
    public static HashMap<Block, Object[]> blockList = new HashMap();

    public ItemModLens(String s) {
        super(7, true, false, false, false, s);
    }

    @Override
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        list.add(TextFormatting.AQUA + "Satellite Frequency: " + this.getFreq(itemstack));
        list.add("");
        super.func_77624_a(itemstack, world, list, flag);
    }

    @Override
    public void addDesc(List<String> list, ItemStack stack, ItemStack armor) {
        list.add(TextFormatting.AQUA + "  " + stack.func_82833_r() + " (Freq: " + this.getFreq(stack) + ")");
    }

    public static void initBlockList() {
        blockList.put(ModBlocks.ore_oil, new Object[]{300, "Oil", 0xA0A0A0});
        blockList.put(ModBlocks.ore_bedrock_oil, new Object[]{10, "Bedrock Oil", 0xA0A0A0});
        blockList.put(ModBlocks.ore_coltan, new Object[]{5, "Coltan", 16760148});
        blockList.put(ModBlocks.ore_asbestos, new Object[]{10, "Asbestos", 0xFFFBF7});
        blockList.put(ModBlocks.stone_gneiss, new Object[]{5000, "Schist", 0x8080FF});
        blockList.put(ModBlocks.ore_reiium, new Object[]{10, "Reiium", 0xBE0000});
        blockList.put(ModBlocks.ore_weidanium, new Object[]{10, "Weidanium", 0xFF3F00});
        blockList.put(ModBlocks.ore_australium, new Object[]{10, "Australium", 0xFFFF00});
        blockList.put(ModBlocks.ore_verticium, new Object[]{10, "Verticium", 65280});
        blockList.put(ModBlocks.ore_unobtainium, new Object[]{10, "Unobtainium", 23039});
        blockList.put(ModBlocks.ore_daffergon, new Object[]{10, "Daffergon", 10813695});
        blockList.put(Blocks.field_150378_br, new Object[]{1, "End Portal", 4239488});
        blockList.put(ModBlocks.basalt_gem, new Object[]{1, "Volcano Gem", 0xFF5000});
        blockList.put(ModBlocks.volcano_core, new Object[]{1, "Volcano Core", 0xFF4000});
        blockList.put(ModBlocks.pink_log, new Object[]{1, "Pink Log", 0xFF00FF});
        blockList.put(ModBlocks.crate_ammo, new Object[]{1, null, 0x800000});
        blockList.put(ModBlocks.crate_can, new Object[]{1, null, 0x800000});
        blockList.put(ModBlocks.ore_schrabidium, new Object[]{1, "Schrabidium", 53503});
        blockList.put(ModBlocks.ore_gneiss_schrabidium, new Object[]{1, "Schrabidium", 53503});
        blockList.put(ModBlocks.ore_nether_schrabidium, new Object[]{1, "Schrabidium", 53503});
        blockList.put(ModBlocks.ore_nether_plutonium, new Object[]{1, "Plutonium", 11064});
        blockList.put(ModBlocks.ore_bedrock_block, new Object[]{10, "Bedrock Ore", 16734464});
        blockList.put(ModBlocks.taint, new Object[]{4, "TAINT", 65396});
    }

    @Override
    public void modUpdate(EntityLivingBase entity, ItemStack armor) {
        World world = entity.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        ItemStack lens = ArmorModHandler.pryMods(armor)[7];
        if (lens == null) {
            return;
        }
        int freq = this.getFreq(lens);
        Satellite sat = SatelliteSavedData.getData(world).getSatFromFreq(freq);
        if (!(sat instanceof SatelliteScanner)) {
            return;
        }
        int x = (int)Math.floor(player.field_70165_t);
        int y = (int)Math.floor(player.field_70163_u);
        int z = (int)Math.floor(player.field_70161_v);
        int range = 3;
        int cX = x >> 4;
        int cZ = z >> 4;
        int height = Math.max(Math.min(y + 10, 255), 64);
        int seg = (int)(world.func_82737_E() % (long)height);
        int hits = 0;
        for (int chunkX = cX - range; chunkX <= cX + range; ++chunkX) {
            for (int chunkZ = cZ - range; chunkZ <= cZ + range; ++chunkZ) {
                Chunk c = world.func_72964_e(chunkX, chunkZ);
                for (int ix = 0; ix < 16; ++ix) {
                    for (int iz = 0; iz < 16; ++iz) {
                        Block b = c.func_186032_a(ix, seg, iz).func_177230_c();
                        int aX = (chunkX << 4) + ix;
                        int aZ = (chunkZ << 4) + iz;
                        Object[] highlightData = blockList.get(b);
                        if (highlightData != null && this.addIf((Integer)highlightData[0], aX, seg, aZ, (String)highlightData[1], (Integer)highlightData[2], player)) {
                            ++hits;
                        }
                        if (hits <= countLimit) continue;
                        return;
                    }
                }
            }
        }
    }

    private boolean addIf(int chance, int x, int y, int z, String label, int color, EntityPlayerMP player) {
        if (chance == 1 || player.func_70681_au().nextInt(chance) == 0) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "marker");
            data.func_74768_a("color", color);
            data.func_74768_a("expires", 15000);
            data.func_74780_a("dist", 300.0);
            if (label != null) {
                data.func_74778_a("label", label);
            }
            PacketDispatcher.wrapper.sendTo((IMessage)new AuxParticlePacketNT(data, x, y, z), player);
            return true;
        }
        return false;
    }
}

