/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.items.ModItems;
import java.util.HashMap;
import net.minecraft.item.ItemStack;

public class CrucibleRecipes {
    public static HashMap<Integer, CrucibleRecipe> recipes = new HashMap();

    public static void registerDefaults() {
        int n = MaterialShapes.NUGGET.q(1);
        int i = MaterialShapes.INGOT.q(1);
        recipes.put(0, new CrucibleRecipe(0, "crucible.hematite", 6, new ItemStack(ModBlocks.ore_hematite)).inputs(new Mats.MaterialStack(Mats.MAT_HEMATITE, i * 2), new Mats.MaterialStack(Mats.MAT_FLUX, n * 2)).outputs(new Mats.MaterialStack(Mats.MAT_IRON, i), new Mats.MaterialStack(Mats.MAT_SLAG, n * 3)));
        recipes.put(1, new CrucibleRecipe(1, "crucible.malachite", 6, new ItemStack(ModBlocks.ore_malachite)).inputs(new Mats.MaterialStack(Mats.MAT_MALACHITE, i * 2), new Mats.MaterialStack(Mats.MAT_FLUX, n * 2)).outputs(new Mats.MaterialStack(Mats.MAT_COPPER, i), new Mats.MaterialStack(Mats.MAT_SLAG, n * 3)));
        recipes.put(2, new CrucibleRecipe(2, "crucible.steel", 2, new ItemStack(ModItems.ingot_steel)).inputs(new Mats.MaterialStack(Mats.MAT_IRON, n), new Mats.MaterialStack(Mats.MAT_CARBON, n)).outputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 2)));
        recipes.put(3, new CrucibleRecipe(3, "crucible.redcopper", 2, new ItemStack(ModItems.ingot_red_copper)).inputs(new Mats.MaterialStack(Mats.MAT_COPPER, n), new Mats.MaterialStack(Mats.MAT_REDSTONE, n)).outputs(new Mats.MaterialStack(Mats.MAT_MINGRADE, n * 2)));
        recipes.put(4, new CrucibleRecipe(4, "crucible.aa", 2, new ItemStack(ModItems.ingot_advanced_alloy)).inputs(new Mats.MaterialStack(Mats.MAT_STEEL, n), new Mats.MaterialStack(Mats.MAT_MINGRADE, n)).outputs(new Mats.MaterialStack(Mats.MAT_ALLOY, n * 2)));
        recipes.put(5, new CrucibleRecipe(5, "crucible.hss", 9, new ItemStack(ModItems.ingot_dura_steel)).inputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 5), new Mats.MaterialStack(Mats.MAT_TUNGSTEN, n * 3), new Mats.MaterialStack(Mats.MAT_COBALT, n)).outputs(new Mats.MaterialStack(Mats.MAT_DURA, n * 9)));
        recipes.put(6, new CrucibleRecipe(6, "crucible.ferro", 3, new ItemStack(ModItems.ingot_ferrouranium)).inputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 2), new Mats.MaterialStack(Mats.MAT_U238, n)).outputs(new Mats.MaterialStack(Mats.MAT_FERRO, n * 3)));
        recipes.put(7, new CrucibleRecipe(7, "crucible.tcalloy", 9, new ItemStack(ModItems.ingot_tcalloy)).inputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 8), new Mats.MaterialStack(Mats.MAT_TECHNIETIUM, n)).outputs(new Mats.MaterialStack(Mats.MAT_TCALLOY, i)));
        recipes.put(8, new CrucibleRecipe(8, "crucible.cdalloy", 9, new ItemStack(ModItems.ingot_cdalloy)).inputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 8), new Mats.MaterialStack(Mats.MAT_CADMIUM, n)).outputs(new Mats.MaterialStack(Mats.MAT_CDALLOY, i)));
        recipes.put(9, new CrucibleRecipe(9, "crucible.star", 3, new ItemStack(ModItems.ingot_starmetal)).inputs(new Mats.MaterialStack(Mats.MAT_SATURN, n), new Mats.MaterialStack(Mats.MAT_METEOR, n)).outputs(new Mats.MaterialStack(Mats.MAT_STAR, n * 2)));
        recipes.put(10, new CrucibleRecipe(10, "crucible.tungcar", 2, new ItemStack(ModItems.neutron_reflector)).inputs(new Mats.MaterialStack(Mats.MAT_TUNGSTEN, i), new Mats.MaterialStack(Mats.MAT_CARBON, i >> 1)).outputs(new Mats.MaterialStack(Mats.MAT_TUNGCAR, i * 2)));
        recipes.put(11, new CrucibleRecipe(11, "crucible.magtung", 3, new ItemStack(ModItems.ingot_magnetized_tungsten)).inputs(new Mats.MaterialStack(Mats.MAT_TUNGSTEN, i), new Mats.MaterialStack(Mats.MAT_SCHRABIDIUM, n)).outputs(new Mats.MaterialStack(Mats.MAT_MAGTUNG, i)));
        recipes.put(12, new CrucibleRecipe(12, "crucible.cmb", 3, new ItemStack(ModItems.ingot_combine_steel)).inputs(new Mats.MaterialStack(Mats.MAT_MUD, i), new Mats.MaterialStack(Mats.MAT_MAGTUNG, n * 6), new Mats.MaterialStack(Mats.MAT_ALLOY, n * 3)).outputs(new Mats.MaterialStack(Mats.MAT_CMB, i)));
        recipes.put(13, new CrucibleRecipe(13, "crucible.bscco", 3, new ItemStack(ModItems.ingot_bscco)).inputs(new Mats.MaterialStack(Mats.MAT_BISMUTH, n * 2), new Mats.MaterialStack(Mats.MAT_STRONTIUM, n * 2), new Mats.MaterialStack(Mats.MAT_CALCIUM, n * 2), new Mats.MaterialStack(Mats.MAT_COPPER, n * 3)).outputs(new Mats.MaterialStack(Mats.MAT_BSCCO, i)));
    }

    public static String getName(ItemStack stack) {
        CrucibleRecipe recipe = recipes.get(stack.func_77952_i());
        if (recipe != null) {
            return recipe.getName();
        }
        return "";
    }

    public static ItemStack getIcon(ItemStack stack) {
        CrucibleRecipe recipe = recipes.get(stack.func_77952_i());
        if (recipe != null) {
            return recipe.icon.func_77946_l();
        }
        return null;
    }

    public static class CrucibleRecipe {
        public Mats.MaterialStack[] input;
        public Mats.MaterialStack[] output;
        private int id;
        private String name;
        public int frequency = 1;
        public ItemStack icon;

        public CrucibleRecipe(int id, String name, int frequency, ItemStack icon) {
            this.id = id;
            this.name = name;
            this.frequency = frequency;
            this.icon = icon;
        }

        public CrucibleRecipe inputs(Mats.MaterialStack ... input) {
            this.input = input;
            return this;
        }

        public CrucibleRecipe outputs(Mats.MaterialStack ... output) {
            this.output = output;
            return this;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getInputAmount() {
            int content = 0;
            for (Mats.MaterialStack stack : this.input) {
                content += stack.amount;
            }
            return content;
        }
    }
}

