/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.config.MachineConfig;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.Spaghetti;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemChemistryTemplate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@Spaghetti(value="everything")
public class ChemplantRecipes {
    public static HashMap<Integer, RecipesCommon.AStack[]> recipeItemInputs = new HashMap();
    public static HashMap<Integer, FluidStack[]> recipeFluidInputs = new HashMap();
    public static HashMap<Integer, RecipesCommon.AStack[]> recipeItemOutputs = new HashMap();
    public static HashMap<Integer, FluidStack[]> recipeFluidOutputs = new HashMap();
    public static HashMap<Integer, Integer> recipeDurations = new HashMap();
    public static LinkedHashMap<Integer, String> recipeNames = new LinkedHashMap();

    public static void registerRecipes() {
        if (MachineConfig.chemplantKeepOilProcessing) {
            ChemplantRecipes.makeRecipe(0, "FP_HEAVYOIL", null, new FluidStack[]{new FluidStack(ModForgeFluids.HEAVYOIL, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.BITUMEN, 300), new FluidStack(ModForgeFluids.SMEAR, 700)}, 50);
            ChemplantRecipes.makeRecipe(10, "FP_SMEAR", null, new FluidStack[]{new FluidStack(ModForgeFluids.SMEAR, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.HEATINGOIL, 600), new FluidStack(ModForgeFluids.LUBRICANT, 400)}, 50);
            ChemplantRecipes.makeRecipe(20, "FP_NAPHTHA", null, new FluidStack[]{new FluidStack(ModForgeFluids.NAPHTHA, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.HEATINGOIL, 400), new FluidStack(ModForgeFluids.DIESEL, 600)}, 50);
            ChemplantRecipes.makeRecipe(30, "FP_LIGHTOIL", null, new FluidStack[]{new FluidStack(ModForgeFluids.LIGHTOIL, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.DIESEL, 400), new FluidStack(ModForgeFluids.KEROSENE, 600)}, 50);
            ChemplantRecipes.makeRecipe(60, "FC_BITUMEN", null, new FluidStack[]{new FluidStack(ModForgeFluids.BITUMEN, 1200), new FluidStack(ModForgeFluids.STEAM, 2400)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.OIL, 1000), new FluidStack(ModForgeFluids.PETROLEUM, 200)}, 100);
            ChemplantRecipes.makeRecipe(70, "FC_I_NAPHTHA", null, new FluidStack[]{new FluidStack(ModForgeFluids.SMEAR, 1400), new FluidStack(FluidRegistry.WATER, 800)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.NAPHTHA, 800)}, 150);
            ChemplantRecipes.makeRecipe(80, "FC_GAS_PETROLEUM", null, new FluidStack[]{new FluidStack(ModForgeFluids.GAS, 1800), new FluidStack(FluidRegistry.WATER, 1200)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.PETROLEUM, 800)}, 100);
            ChemplantRecipes.makeRecipe(90, "FC_DIESEL_KEROSENE", null, new FluidStack[]{new FluidStack(ModForgeFluids.DIESEL, 1200), new FluidStack(ModForgeFluids.STEAM, 2000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.KEROSENE, 400)}, 150);
            ChemplantRecipes.makeRecipe(100, "FC_KEROSENE_PETROLEUM", null, new FluidStack[]{new FluidStack(ModForgeFluids.KEROSENE, 1400), new FluidStack(ModForgeFluids.STEAM, 2000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.PETROLEUM, 800)}, 150);
            ChemplantRecipes.makeRecipe(110, "CC_OIL", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 8), new RecipesCommon.ComparableStack(ModItems.oil_tar, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.OIL, 600), new FluidStack(ModForgeFluids.STEAM, 1400)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.OIL, 2000)}, 150);
            ChemplantRecipes.makeRecipe(120, "CC_I", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 6), new RecipesCommon.ComparableStack(ModItems.oil_tar, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.SMEAR, 800), new FluidStack(FluidRegistry.WATER, 1800)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.SMEAR, 1600)}, 200);
            ChemplantRecipes.makeRecipe(130, "CC_HEATING", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 6), new RecipesCommon.ComparableStack(ModItems.oil_tar, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.HEATINGOIL, 800), new FluidStack(ModForgeFluids.STEAM, 2000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.HEATINGOIL, 1800)}, 250);
            ChemplantRecipes.makeRecipe(140, "CC_HEAVY", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 8), new RecipesCommon.ComparableStack(ModItems.oil_tar, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.HEAVYOIL, 600), new FluidStack(FluidRegistry.WATER, 1400)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.HEAVYOIL, 1800)}, 200);
            ChemplantRecipes.makeRecipe(150, "CC_NAPHTHA", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 8), new RecipesCommon.ComparableStack(ModItems.oil_tar, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.NAPHTHA, 1200), new FluidStack(ModForgeFluids.STEAM, 2400)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.NAPHTHA, 2000)}, 300);
            ChemplantRecipes.makeRecipe(160, "SF_OIL", null, new FluidStack[]{new FluidStack(ModForgeFluids.OIL, 350)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(170, "SF_HEAVYOIL", null, new FluidStack[]{new FluidStack(ModForgeFluids.HEAVYOIL, 250)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.oil_tar, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(180, "SF_SMEAR", null, new FluidStack[]{new FluidStack(ModForgeFluids.SMEAR, 200)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.oil_tar, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(190, "SF_HEATINGOIL", null, new FluidStack[]{new FluidStack(ModForgeFluids.HEATINGOIL, 100)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(200, "SF_RECLAIMED", null, new FluidStack[]{new FluidStack(ModForgeFluids.RECLAIMED, 200)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(210, "SF_PETROIL", null, new FluidStack[]{new FluidStack(ModForgeFluids.PETROIL, 250)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(220, "SF_LUBRICANT", null, new FluidStack[]{new FluidStack(ModForgeFluids.LUBRICANT, 250)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(230, "SF_NAPHTHA", null, new FluidStack[]{new FluidStack(ModForgeFluids.NAPHTHA, 300)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(240, "SF_DIESEL", null, new FluidStack[]{new FluidStack(ModForgeFluids.DIESEL, 400)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(250, "SF_LIGHTOIL", null, new FluidStack[]{new FluidStack(ModForgeFluids.LIGHTOIL, 450)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(260, "SF_KEROSENE", null, new FluidStack[]{new FluidStack(ModForgeFluids.KEROSENE, 550)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(270, "SF_GAS", null, new FluidStack[]{new FluidStack(ModForgeFluids.GAS, 750)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(280, "SF_PETROLEUM", null, new FluidStack[]{new FluidStack(ModForgeFluids.PETROLEUM, 600)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(290, "SF_BIOGAS", null, new FluidStack[]{new FluidStack(ModForgeFluids.BIOGAS, 400)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
            ChemplantRecipes.makeRecipe(300, "SF_BIOFUEL", null, new FluidStack[]{new FluidStack(ModForgeFluids.BIOFUEL, 300)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        }
        ChemplantRecipes.makeRecipe(40, "FR_REOIL", null, new FluidStack[]{new FluidStack(ModForgeFluids.SMEAR, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.RECLAIMED, 800)}, 30);
        ChemplantRecipes.makeRecipe(50, "FR_PETROIL", null, new FluidStack[]{new FluidStack(ModForgeFluids.RECLAIMED, 800), new FluidStack(ModForgeFluids.LUBRICANT, 200)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.PETROIL, 1000)}, 30);
        ChemplantRecipes.makeRecipe(310, "BP_BIOGAS", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.biomass, 16)}, null, null, new FluidStack[]{new FluidStack(ModForgeFluids.BIOGAS, 4000)}, 200);
        ChemplantRecipes.makeRecipe(320, "BP_BIOFUEL", null, new FluidStack[]{new FluidStack(ModForgeFluids.BIOGAS, 1500), new FluidStack(ModForgeFluids.ETHANOL, 250)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.BIOFUEL, 1000)}, 100);
        ChemplantRecipes.makeRecipe(330, "OIL_SAND", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.ore_oil_sand, 16), new RecipesCommon.OreDictStack("oiltar", 1)}, null, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack((Block)Blocks.field_150354_m, 16)}, new FluidStack[]{new FluidStack(ModForgeFluids.BITUMEN, 1000)}, 200);
        ChemplantRecipes.makeRecipe(340, "ASPHALT", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("gravel", 2), new RecipesCommon.OreDictStack("sand", 6)}, new FluidStack[]{new FluidStack(ModForgeFluids.BITUMEN, 8000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.asphalt, 16)}, null, 100);
        ChemplantRecipes.makeRecipe(350, "GNEISS_GAS", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.ore_gneiss_gas, 2)}, new FluidStack[]{new FluidStack(ModForgeFluids.SUPERHOTSTEAM, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.stone_gneiss, 2)}, new FluidStack[]{new FluidStack(ModForgeFluids.GAS, 1000), new FluidStack(ModForgeFluids.SPENTSTEAM, 1000)}, 100);
        ChemplantRecipes.makeRecipe(360, "COOLANT", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 1)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1800)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.COOLANT, 2000)}, 50);
        ChemplantRecipes.makeRecipe(370, "CRYOGEL", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_ice, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.COOLANT, 1800)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.CRYOGEL, 2000)}, 50);
        if (GeneralConfig.enableBabyMode) {
            ChemplantRecipes.makeRecipe(380, "DESH", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_desh_mix, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.LIGHTOIL, 200)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_desh, 1)}, null, 300);
        } else {
            ChemplantRecipes.makeRecipe(380, "DESH", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_desh_mix, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.MERCURY, 200), new FluidStack(ModForgeFluids.LIGHTOIL, 200)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_desh, 1)}, null, 300);
        }
        ChemplantRecipes.makeRecipe(390, "NITAN", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_nitan_mix, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.KEROSENE, 600), new FluidStack(ModForgeFluids.MERCURY, 200)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.NITAN, 1000)}, 50);
        ChemplantRecipes.makeRecipe(400, "PEROXIDE", null, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.ACID, 800)}, 50);
        ChemplantRecipes.makeRecipe(410, "SULFURIC_ACID", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.S.dust())}, new FluidStack[]{new FluidStack(ModForgeFluids.ACID, 800)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.SULFURIC_ACID, 500)}, 50);
        ChemplantRecipes.makeRecipe(420, "NITRIC_ACID", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())}, new FluidStack[]{new FluidStack(ModForgeFluids.SULFURIC_ACID, 500)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.NITRIC_ACID, 500)}, 50);
        ChemplantRecipes.makeRecipe(430, "SOLVENT", null, new FluidStack[]{new FluidStack(ModForgeFluids.NAPHTHA, 800), new FluidStack(ModForgeFluids.AROMATICS, 300)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.SOLVENT, 1000)}, 50);
        ChemplantRecipes.makeRecipe(440, "RADIOSOLVENT", null, new FluidStack[]{new FluidStack(ModForgeFluids.SOLVENT, 500), new FluidStack(ModForgeFluids.MUD_FLUID, 500)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.RADIOSOLVENT, 1000)}, 50);
        ChemplantRecipes.makeRecipe(470, "POLYMER", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.gem(), 2), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.PETROLEUM, 600)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_polymer, 1)}, null, 100);
        ChemplantRecipes.makeRecipe(480, "BAKELITE", null, new FluidStack[]{new FluidStack(ModForgeFluids.AROMATICS, 500), new FluidStack(ModForgeFluids.PETROLEUM, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_bakelite, 1)}, null, 100);
        ChemplantRecipes.makeRecipe(490, "RUBBER", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.UNSATURATEDS, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_rubber, 1)}, null, 100);
        ChemplantRecipes.makeRecipe(494, "PC", null, new FluidStack[]{new FluidStack(ModForgeFluids.XYLENE, 500), new FluidStack(ModForgeFluids.PHOSGENE, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_pc, 1)}, null, 100);
        ChemplantRecipes.makeRecipe(495, "PVC", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.CD.dust())}, new FluidStack[]{new FluidStack(ModForgeFluids.UNSATURATEDS, 250), new FluidStack(ModForgeFluids.CHLORINE, 250)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_pvc, 1)}, null, 100);
        ChemplantRecipes.makeRecipe(500, "DYNAMITE", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Items.field_151102_aT), new RecipesCommon.OreDictStack(OreDictManager.KNO.dust()), new RecipesCommon.OreDictStack("sand")}, new FluidStack[]{new FluidStack(ModForgeFluids.SULFURIC_ACID, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ball_dynamite, 2)}, null, 50);
        ChemplantRecipes.makeRecipe(510, "TNT", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.AROMATICS, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ball_tnt, 4)}, null, 150);
        ChemplantRecipes.makeRecipe(515, "TATB", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ball_tnt, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.SOURGAS, 200), new FluidStack(ModForgeFluids.NITRIC_ACID, 10)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ball_tatb, 1)}, null, 50);
        ChemplantRecipes.makeRecipe(520, "C4", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.UNSATURATEDS, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_c4, 4)}, null, 150);
        ChemplantRecipes.makeRecipe(530, "HEAVY_ELECTROLYSIS", null, new FluidStack[]{new FluidStack(ModForgeFluids.HEAVYWATER, 2000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.DEUTERIUM, 200), new FluidStack(ModForgeFluids.OXYGEN, 100)}, 150);
        ChemplantRecipes.makeRecipe(540, "DEUTERIUM", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 2)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 4000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.DEUTERIUM, 500)}, 200);
        ChemplantRecipes.makeRecipe(550, "STEAM", null, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.STEAM, 1000)}, 20);
        ChemplantRecipes.makeRecipe(555, "EPEARL", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust())}, new FluidStack[]{new FluidStack(ModForgeFluids.EXPERIENCE, 500)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.ENDERJUICE, 250)}, 100);
        ChemplantRecipes.makeRecipe(560, "ALGE", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.biomass, 4), new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.COAL.dustTiny(), 2)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 8000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.biomass, 36)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1000)}, 1200);
        ChemplantRecipes.makeRecipe(570, "YELLOWCAKE", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.U.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 2)}, new FluidStack[]{new FluidStack(ModForgeFluids.ACID, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_yellowcake, 1)}, null, 250);
        ChemplantRecipes.makeRecipe(580, "UF6", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_yellowcake, 1), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 3)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.sulfur, 2)}, new FluidStack[]{new FluidStack(ModForgeFluids.UF6, 1000)}, 100);
        ChemplantRecipes.makeRecipe(590, "PUF6", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PU.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 3)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.PUF6, 1000)}, 150);
        ChemplantRecipes.makeRecipe(600, "SAS3", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.SA326.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 2)}, new FluidStack[]{new FluidStack(ModForgeFluids.ACID, 2000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.SAS3, 1000)}, 200);
        ChemplantRecipes.makeRecipe(610, "DYN_SCHRAB", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_higgs, 1), new RecipesCommon.OreDictStack(OreDictManager.U.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 8)}, new FluidStack[]{new FluidStack(ModForgeFluids.COOLANT, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_empty, 1), new RecipesCommon.ComparableStack(ModItems.ingot_schrabidium, 8)}, new FluidStack[]{new FluidStack(ModForgeFluids.MUD_FLUID, 50)}, 600);
        ChemplantRecipes.makeRecipe(620, "DYN_STR", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_strange, 1), new RecipesCommon.ComparableStack(ModItems.nugget_radspice, 8), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 8)}, new FluidStack[]{new FluidStack(ModForgeFluids.CRYOGEL, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_empty, 1), new RecipesCommon.ComparableStack(ModItems.egg_balefire, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.MUD_FLUID, 200)}, 1200);
        ChemplantRecipes.makeRecipe(630, "DYN_EUPH", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_dark, 1), new RecipesCommon.OreDictStack(OreDictManager.SA327.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 16)}, new FluidStack[]{new FluidStack(ModForgeFluids.CRYOGEL, 2000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_empty, 1), new RecipesCommon.ComparableStack(ModItems.ingot_euphemium, 8)}, new FluidStack[]{new FluidStack(ModForgeFluids.MUD_FLUID, 100)}, 2400);
        ChemplantRecipes.makeRecipe(640, "DYN_DNT", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_sparkticle, 1), new RecipesCommon.OreDictStack(OreDictManager.SBD.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 32)}, new FluidStack[]{new FluidStack(ModForgeFluids.CRYOGEL, 4000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_empty, 1), new RecipesCommon.ComparableStack(ModItems.ingot_dineutronium, 8)}, new FluidStack[]{new FluidStack(ModForgeFluids.MUD_FLUID, 400)}, 6000);
        ChemplantRecipes.makeRecipe(650, "DYN_EL", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_digamma, 1), new RecipesCommon.OreDictStack(OreDictManager.DNT.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 64)}, new FluidStack[]{new FluidStack(ModForgeFluids.CRYOGEL, 8000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_empty, 1), new RecipesCommon.ComparableStack(ModItems.ingot_electronium, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.MUD_FLUID, 800)}, 12000);
        ChemplantRecipes.makeRecipe(660, "CORDITE", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 2), new RecipesCommon.OreDictStack("plankWood", 1), new RecipesCommon.ComparableStack(Items.field_151102_aT, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.HEATINGOIL, 200)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.cordite, 4)}, null, 40);
        ChemplantRecipes.makeRecipe(670, "KEVLAR", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 2), new RecipesCommon.OreDictStack("ingotBrick", 1), new RecipesCommon.OreDictStack(OreDictManager.COAL.gem(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.PETROLEUM, 100)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_kevlar, 4)}, null, 40);
        ChemplantRecipes.makeRecipe(680, "CONCRETE", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("gravel", 8), new RecipesCommon.OreDictStack("sand", 8)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 2000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.concrete_smooth, 16)}, null, 100);
        ChemplantRecipes.makeRecipe(690, "CONCRETE_ASBESTOS", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("gravel", 2), new RecipesCommon.OreDictStack("sand", 2), new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot(), 4)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 2000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.concrete_asbestos, 16)}, null, 100);
        ChemplantRecipes.makeRecipe(700, "DUCRETE", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("sand", 8), new RecipesCommon.OreDictStack(OreDictManager.U238.billet(), 2), new RecipesCommon.ComparableStack(Items.field_151119_aD, 4)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 2000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.ducrete, 8)}, null, 200);
        ChemplantRecipes.makeRecipe(710, "SOLID_FUEL", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2), new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.REDSTONE.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.PETROLEUM, 200)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.rocket_fuel, 4)}, null, 200);
        ChemplantRecipes.makeRecipe(720, "ELECTROLYSIS", null, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 2000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.HYDROGEN, 200), new FluidStack(ModForgeFluids.OXYGEN, 100)}, 150);
        ChemplantRecipes.makeRecipe(730, "XENON", null, null, null, new FluidStack[]{new FluidStack(ModForgeFluids.XENON, 50)}, 300);
        ChemplantRecipes.makeRecipe(740, "XENON_OXY", null, new FluidStack[]{new FluidStack(ModForgeFluids.OXYGEN, 250)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.XENON, 50)}, 20);
        ChemplantRecipes.makeRecipe(750, "SATURN", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DURA.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.P_RED.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.ACID, 100), new FluidStack(ModForgeFluids.MERCURY, 50)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_saturnite, 2)}, null, 60);
        ChemplantRecipes.makeRecipe(760, "BALEFIRE", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.egg_balefire_shard, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.KEROSENE, 6000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_balefire, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.BALEFIRE, 8000)}, 100);
        ChemplantRecipes.makeRecipe(770, "SCHRABIDIC", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.pellet_charged, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.SAS3, 8000), new FluidStack(ModForgeFluids.ACID, 6000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.SCHRABIDIC, 16000)}, 100);
        ChemplantRecipes.makeRecipe(780, "SCHRABIDATE", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.SCHRABIDIC, 250)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_schrabidate, 1)}, null, 600);
        ChemplantRecipes.makeRecipe(790, "COLTAN_CLEANING", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COLTAN.dust(), 2), new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.ACID, 250), new FluidStack(ModForgeFluids.HYDROGEN, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_coltan, 1), new RecipesCommon.ComparableStack(ModItems.powder_niobium, 1), new RecipesCommon.ComparableStack(ModItems.dust, 1)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 500)}, 60);
        ChemplantRecipes.makeRecipe(800, "COLTAN_PAIN", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_coltan, 1), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.GAS, 1000), new FluidStack(ModForgeFluids.OXYGEN, 500)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.PAIN, 1000)}, 120);
        ChemplantRecipes.makeRecipe(810, "COLTAN_CRYSTAL", null, new FluidStack[]{new FluidStack(ModForgeFluids.PAIN, 1000), new FluidStack(ModForgeFluids.ACID, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.gem_tantalium, 1), new RecipesCommon.ComparableStack(ModItems.dust, 3)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 250)}, 80);
        ChemplantRecipes.makeRecipe(820, "ARSENIC", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.scrap_oil, 16)}, new FluidStack[]{new FluidStack(ModForgeFluids.RADIOSOLVENT, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.nugget_arsenic, 1)}, null, 1200);
        ChemplantRecipes.makeRecipe(830, "VIT_LIQUID", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.sand_lead, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.WASTEFLUID, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.nuclear_waste_vitrified, 1)}, null, 100);
        ChemplantRecipes.makeRecipe(840, "VIT_GAS", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.sand_lead, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.WASTEGAS, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.nuclear_waste_vitrified, 1)}, null, 100);
        ChemplantRecipes.makeRecipe(845, "LUBRICANT", null, new FluidStack[]{new FluidStack(ModForgeFluids.HEATINGOIL, 500), new FluidStack(ModForgeFluids.UNSATURATEDS, 500)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.LUBRICANT, 1000)}, 20);
        ChemplantRecipes.makeRecipe(850, "TEL", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("oiltar", 1), new RecipesCommon.OreDictStack(OreDictManager.PB.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.PETROLEUM, 100), new FluidStack(ModForgeFluids.STEAM, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.antiknock, 1)}, null, 40);
        ChemplantRecipes.makeRecipe(855, "PETROIL_LEADED", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.antiknock, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.PETROIL, 10000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.PETROIL_LEADED, 12000)}, 40);
        ChemplantRecipes.makeRecipe(860, "GASOLINE", null, new FluidStack[]{new FluidStack(ModForgeFluids.NAPHTHA, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.GASOLINE, 800)}, 40);
        ChemplantRecipes.makeRecipe(862, "GASOLINE_LEADED", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.antiknock, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.GASOLINE, 10000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.GASOLINE_LEADED, 12000)}, 40);
        ChemplantRecipes.makeRecipe(866, "COALGAS_LEADED", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.antiknock, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.COALGAS, 10000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.COALGAS_LEADED, 12000)}, 40);
        ChemplantRecipes.makeRecipe(870, "FRACKSOL", new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.S.dust())}, new FluidStack[]{new FluidStack(ModForgeFluids.PETROLEUM, 100), new FluidStack(FluidRegistry.WATER, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.FRACKSOL, 1000)}, 20);
        ChemplantRecipes.makeRecipe(880, "OSMIRIDIUM_DEATH", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_paleogenite), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 8), new RecipesCommon.ComparableStack(ModItems.nugget_bismuth, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.SULFURIC_ACID, 1000), new FluidStack(ModForgeFluids.SAS3, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.LIQUID_OSMIRIDIUM, 1000)}, 240);
        ChemplantRecipes.makeRecipe(890, "ETHANOL", new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Items.field_151102_aT, 10)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 2500)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.ETHANOL, 1000)}, 100);
    }

    public static void makeRecipe(int index, String name, RecipesCommon.AStack[] itemInputs, FluidStack[] fluidInputs, RecipesCommon.AStack[] outputItems, FluidStack[] outputFluids, int duration) {
        if (itemInputs != null) {
            recipeItemInputs.put(index, itemInputs);
        }
        if (fluidInputs != null) {
            recipeFluidInputs.put(index, fluidInputs);
        }
        if (outputItems != null) {
            recipeItemOutputs.put(index, outputItems);
        }
        if (outputFluids != null) {
            recipeFluidOutputs.put(index, outputFluids);
        }
        if (duration > 1) {
            recipeDurations.put(index, duration);
        }
        if (name != null) {
            recipeNames.put(index, name);
        }
    }

    public static void removeRecipe(int index) {
        recipeItemInputs.remove(index);
        recipeFluidInputs.remove(index);
        recipeItemOutputs.remove(index);
        recipeFluidOutputs.remove(index);
        recipeDurations.remove(index);
        recipeNames.remove(index);
    }

    public static List<RecipesCommon.AStack> getChemInputFromTempate(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        RecipesCommon.AStack[] inputs = recipeItemInputs.get(stack.func_77952_i());
        if (inputs != null) {
            return Arrays.asList(inputs);
        }
        return null;
    }

    public static FluidStack[] getFluidInputFromTempate(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        return recipeFluidInputs.get(stack.func_77952_i());
    }

    public static ItemStack[] getChemOutputFromTempate(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        RecipesCommon.AStack[] outputs = recipeItemOutputs.get(stack.func_77952_i());
        if (outputs != null) {
            ItemStack[] stackOutputs = new ItemStack[outputs.length];
            for (int i = 0; i < stackOutputs.length; ++i) {
                stackOutputs[i] = outputs[i].getStack();
            }
            return stackOutputs;
        }
        return null;
    }

    public static FluidStack[] getFluidOutputFromTempate(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        return recipeFluidOutputs.get(stack.func_77952_i());
    }

    public static int getProcessTime(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return 100;
        }
        Integer time = recipeDurations.get(stack.func_77952_i());
        if (time != null) {
            return time;
        }
        return 100;
    }

    public static String getName(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        String name = recipeNames.get(stack.func_77952_i());
        if (name != null) {
            return name;
        }
        return "BAD_RECIPE";
    }

    public static String getName(int i) {
        String name = recipeNames.get(i);
        if (name != null) {
            return name;
        }
        return "";
    }

    public static boolean hasRecipe(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return false;
        }
        return recipeNames.containsKey(stack.func_77952_i());
    }
}

