/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hfr.render.loader;

import com.hbm.render.amlfrom1710.TextureCoordinate;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.render.amlfrom1710.Vertex;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class S_Face {
    public int[] verticesID;
    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public Vertex faceNormal;
    public TextureCoordinate[] textureCoordinates;
    public float normalX;
    public float normalY;
    public float normalZ;

    public void addFaceForRender(BufferBuilder tessellator) {
        this.addFaceForRender(tessellator, 0.0f);
    }

    public void addFaceForRender(BufferBuilder tessellator, float textureOffset) {
        int i;
        if (this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        this.normalX = this.faceNormal.x;
        this.normalY = this.faceNormal.y;
        this.normalZ = this.faceNormal.z;
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            for (i = 0; i < this.textureCoordinates.length; ++i) {
                averageU += this.textureCoordinates[i].u;
                averageV += this.textureCoordinates[i].v;
            }
            averageU /= (float)this.textureCoordinates.length;
            averageV /= (float)this.textureCoordinates.length;
        }
        for (i = 0; i < this.vertices.length; ++i) {
            if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
                float offsetU = textureOffset;
                float offsetV = textureOffset;
                if (this.textureCoordinates[i].u > averageU) {
                    offsetU = -offsetU;
                }
                if (this.textureCoordinates[i].v > averageV) {
                    offsetV = -offsetV;
                }
                if (this.vertexNormals != null && i < this.vertexNormals.length) {
                    this.normalX = this.vertexNormals[i].x;
                    this.normalY = this.vertexNormals[i].y;
                    this.normalZ = this.vertexNormals[i].z;
                }
                tessellator.func_181662_b((double)this.vertices[i].x, (double)this.vertices[i].y, (double)this.vertices[i].z).func_187315_a((double)(this.textureCoordinates[i].u + offsetU), (double)(this.textureCoordinates[i].v + offsetV)).func_181663_c(this.normalX, this.normalY, this.normalZ).func_181675_d();
                continue;
            }
            tessellator.func_181662_b((double)this.vertices[i].x, (double)this.vertices[i].y, (double)this.vertices[i].z).func_187315_a(0.0, 0.0).func_181663_c(this.normalX, this.normalY, this.normalZ).func_181675_d();
        }
    }

    public Vertex calculateFaceNormal() {
        Vec3 v1 = Vec3.createVectorHelper(this.vertices[1].x - this.vertices[0].x, this.vertices[1].y - this.vertices[0].y, this.vertices[1].z - this.vertices[0].z);
        Vec3 v2 = Vec3.createVectorHelper(this.vertices[2].x - this.vertices[0].x, this.vertices[2].y - this.vertices[0].y, this.vertices[2].z - this.vertices[0].z);
        Vec3 normalVector = null;
        normalVector = v1.crossProduct(v2).normalize();
        return new Vertex((float)normalVector.xCoord, (float)normalVector.yCoord, (float)normalVector.zCoord);
    }
}

