/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import api.hbm.item.IGasMask;
import com.hbm.handler.ArmorModHandler;
import com.hbm.handler.HazmatRegistry;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.potion.HbmPotion;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.Compat;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.potion.Potion;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ArmorUtil {
    public static final String[] metals = new String[]{"chainmail", "iron", "silver", "gold", "platinum", "tin", "lead", "liquidator", "schrabidium", "euphemium", "steel", "cmb", "titanium", "alloy", "copper", "bronze", "electrum", "t45", "bj", "starmetal", "hazmat", "rubber", "hev", "ajr", "rpa", "spacesuit"};
    public static final String FILTERK_KEY = "hfrFilter";

    public static void register() {
        ArmorRegistry.registerHazard(ModItems.gas_mask_filter, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT);
        ArmorRegistry.registerHazard(ModItems.gas_mask_filter_mono, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.GAS_MONOXIDE);
        ArmorRegistry.registerHazard(ModItems.gas_mask_filter_combo, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.NERVE_AGENT);
        ArmorRegistry.registerHazard(ModItems.gas_mask_filter_radon, ArmorRegistry.HazardClass.RAD_GAS, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.NERVE_AGENT);
        ArmorRegistry.registerHazard(ModItems.gas_mask_filter_rag, ArmorRegistry.HazardClass.PARTICLE_COARSE);
        ArmorRegistry.registerHazard(ModItems.gas_mask_filter_piss, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.GAS_CHLORINE);
        ArmorRegistry.registerHazard(ModItems.gas_mask, ArmorRegistry.HazardClass.SAND, ArmorRegistry.HazardClass.LIGHT);
        ArmorRegistry.registerHazard(ModItems.gas_mask_m65, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.mask_damp, ArmorRegistry.HazardClass.PARTICLE_COARSE);
        ArmorRegistry.registerHazard(ModItems.mask_piss, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.GAS_CHLORINE);
        ArmorRegistry.registerHazard(ModItems.goggles, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.ashglasses, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.attachment_mask, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.spider_milk, ArmorRegistry.HazardClass.LIGHT);
        ArmorRegistry.registerHazard(ModItems.asbestos_helmet, ArmorRegistry.HazardClass.SAND, ArmorRegistry.HazardClass.LIGHT);
        ArmorRegistry.registerHazard(ModItems.hazmat_helmet, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.hazmat_helmet_red, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.hazmat_helmet_grey, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.liquidator_helmet, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.hazmat_paa_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.paa_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.t45_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.ajr_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.ajro_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.rpa_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.hev_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.fau_helmet, ArmorRegistry.HazardClass.RAD_GAS, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.dns_helmet, ArmorRegistry.HazardClass.RAD_GAS, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND, ArmorRegistry.HazardClass.GAS_CORROSIVE);
        ArmorRegistry.registerHazard(ModItems.schrabidium_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.euphemium_helmet, ArmorRegistry.HazardClass.RAD_GAS, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorUtil.registerIfExists("gregtech", "gt.armor.hazmat.universal.head", ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorUtil.registerIfExists("gregtech", "gt.armor.hazmat.biochemgas.head", ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorUtil.registerIfExists("gregtech", "gt.armor.hazmat.radiation.head", ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorUtil.registerIfExists("techguns", "t1_scout_helmet", ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.SAND);
    }

    private static void registerIfExists(String domain, String name, ArmorRegistry.HazardClass ... classes) {
        Item item = Compat.tryLoadItem(domain, name);
        if (item != null) {
            ArmorRegistry.registerHazard(item, classes);
        }
    }

    public static boolean checkForFaraday(EntityPlayer player) {
        NonNullList armor = player.field_71071_by.field_70460_b;
        if (((ItemStack)armor.get(0)).func_190926_b() || ((ItemStack)armor.get(1)).func_190926_b() || ((ItemStack)armor.get(2)).func_190926_b() || ((ItemStack)armor.get(3)).func_190926_b()) {
            return false;
        }
        return ArmorUtil.isFaradayArmor((ItemStack)armor.get(0)) && ArmorUtil.isFaradayArmor((ItemStack)armor.get(1)) && ArmorUtil.isFaradayArmor((ItemStack)armor.get(2)) && ArmorUtil.isFaradayArmor((ItemStack)armor.get(3));
    }

    public static boolean isFaradayArmor(ItemStack item) {
        String name = item.func_77977_a();
        if (HazmatRegistry.getCladding(item) > 0.0f) {
            return true;
        }
        for (String metal : metals) {
            if (!name.toLowerCase().contains(metal)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkArmorNull(EntityLivingBase player, EntityEquipmentSlot slot) {
        return player.func_184582_a(slot) == null || player.func_184582_a(slot).func_190926_b();
    }

    public static void damageSuit(EntityPlayer player, int slot, int amount) {
        if (player.field_71071_by.field_70460_b.get(slot) == ItemStack.field_190927_a) {
            return;
        }
        int j = ((ItemStack)player.field_71071_by.field_70460_b.get(slot)).func_77952_i();
        ((ItemStack)player.field_71071_by.field_70460_b.get(slot)).func_77964_b(j += amount);
        if (((ItemStack)player.field_71071_by.field_70460_b.get(slot)).func_77952_i() >= ((ItemStack)player.field_71071_by.field_70460_b.get(slot)).func_77958_k()) {
            player.field_71071_by.field_70460_b.set(slot, (Object)ItemStack.field_190927_a);
        }
    }

    public static void resetFlightTime(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            ReflectionHelper.setPrivateValue(NetHandlerPlayServer.class, (Object)mp.field_71135_a, (Object)0, (String)"floatingTickCount", (String)"field_147365_f");
        }
    }

    public static boolean checkForFiend2(EntityPlayer player) {
        return ArmorUtil.checkArmorPiece(player, ModItems.jackt2, 2) && Library.checkForHeld(player, ModItems.shimmer_axe);
    }

    public static boolean checkForFiend(EntityPlayer player) {
        return ArmorUtil.checkArmorPiece(player, ModItems.jackt, 2) && Library.checkForHeld(player, ModItems.shimmer_sledge);
    }

    public static boolean checkForHaz2(EntityLivingBase player) {
        return ArmorUtil.checkArmor(player, ModItems.hazmat_paa_helmet, ModItems.hazmat_paa_plate, ModItems.hazmat_paa_legs, ModItems.hazmat_paa_boots) || ArmorUtil.checkArmor(player, ModItems.paa_helmet, ModItems.paa_plate, ModItems.paa_legs, ModItems.paa_boots) || ArmorUtil.checkArmor(player, ModItems.liquidator_helmet, ModItems.liquidator_plate, ModItems.liquidator_legs, ModItems.liquidator_boots) || ArmorUtil.checkArmor(player, ModItems.euphemium_helmet, ModItems.euphemium_plate, ModItems.euphemium_legs, ModItems.euphemium_boots) || ArmorUtil.checkArmor(player, ModItems.hev_helmet, ModItems.hev_plate, ModItems.hev_legs, ModItems.hev_boots) || ArmorUtil.checkArmor(player, ModItems.ajr_helmet, ModItems.ajr_plate, ModItems.ajr_legs, ModItems.ajr_boots) || ArmorUtil.checkArmor(player, ModItems.ajro_helmet, ModItems.ajro_plate, ModItems.ajro_legs, ModItems.ajro_boots) || ArmorUtil.checkArmor(player, ModItems.rpa_helmet, ModItems.rpa_plate, ModItems.rpa_legs, ModItems.rpa_boots) || ArmorUtil.checkArmor(player, ModItems.fau_helmet, ModItems.fau_plate, ModItems.fau_legs, ModItems.fau_boots) || ArmorUtil.checkArmor(player, ModItems.dns_helmet, ModItems.dns_plate, ModItems.dns_legs, ModItems.dns_boots);
    }

    public static boolean checkForHazmatOnly(EntityLivingBase player) {
        return ArmorUtil.checkArmor(player, ModItems.hazmat_helmet, ModItems.hazmat_plate, ModItems.hazmat_legs, ModItems.hazmat_boots) || ArmorUtil.checkArmor(player, ModItems.hazmat_helmet_red, ModItems.hazmat_plate_red, ModItems.hazmat_legs_red, ModItems.hazmat_boots_red) || ArmorUtil.checkArmor(player, ModItems.hazmat_helmet_grey, ModItems.hazmat_plate_grey, ModItems.hazmat_legs_grey, ModItems.hazmat_boots_grey) || ArmorUtil.checkArmor(player, ModItems.hazmat_paa_helmet, ModItems.hazmat_paa_plate, ModItems.hazmat_paa_legs, ModItems.hazmat_paa_boots) || ArmorUtil.checkArmor(player, ModItems.paa_helmet, ModItems.paa_plate, ModItems.paa_legs, ModItems.paa_boots) || ArmorUtil.checkArmor(player, ModItems.liquidator_helmet, ModItems.liquidator_plate, ModItems.liquidator_legs, ModItems.liquidator_boots);
    }

    public static boolean checkForHazmat(EntityLivingBase player) {
        if (ArmorUtil.checkArmor(player, ModItems.hazmat_helmet, ModItems.hazmat_plate, ModItems.hazmat_legs, ModItems.hazmat_boots) || ArmorUtil.checkArmor(player, ModItems.hazmat_helmet_red, ModItems.hazmat_plate_red, ModItems.hazmat_legs_red, ModItems.hazmat_boots_red) || ArmorUtil.checkArmor(player, ModItems.hazmat_helmet_grey, ModItems.hazmat_plate_grey, ModItems.hazmat_legs_grey, ModItems.hazmat_boots_grey) || ArmorUtil.checkArmor(player, ModItems.t45_helmet, ModItems.t45_plate, ModItems.t45_legs, ModItems.t45_boots) || ArmorUtil.checkArmor(player, ModItems.schrabidium_helmet, ModItems.schrabidium_plate, ModItems.schrabidium_legs, ModItems.schrabidium_boots) || ArmorUtil.checkForHaz2(player)) {
            return true;
        }
        return player.func_70644_a((Potion)HbmPotion.mutation);
    }

    public static boolean checkForAsbestos(EntityLivingBase player) {
        return ArmorUtil.checkArmor(player, ModItems.asbestos_helmet, ModItems.asbestos_plate, ModItems.asbestos_legs, ModItems.asbestos_boots);
    }

    public static boolean checkArmor(EntityLivingBase player, Item helm, Item chest, Item leg, Item shoe) {
        return player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == shoe && player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == leg && player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == chest && player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == helm;
    }

    public static boolean checkArmorPiece(EntityPlayer player, Item armor, int slot) {
        return !((ItemStack)player.field_71071_by.field_70460_b.get(slot)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(slot)).func_77973_b() == armor;
    }

    public static void damageGasMaskFilter(EntityLivingBase entity, float damage) {
        ArmorUtil.damageGasMaskFilter(entity, Library.getStatisticalInt(entity.field_70170_p.field_73012_v, damage));
    }

    public static void damageGasMaskFilter(EntityLivingBase entity, int damage) {
        ItemStack[] mods;
        if (damage <= 0) {
            return;
        }
        ItemStack mask = entity.func_184582_a(EntityEquipmentSlot.HEAD);
        if (mask.func_190926_b()) {
            return;
        }
        if (!(mask.func_77973_b() instanceof IGasMask) && ArmorModHandler.hasMods(mask) && (mods = ArmorModHandler.pryMods(mask))[0] != null && mods[0].func_77973_b() instanceof IGasMask) {
            mask = mods[0];
        }
        if (mask != null) {
            ArmorUtil.damageGasMaskFilter(entity, mask, damage);
        }
    }

    public static void damageGasMaskFilter(EntityLivingBase entity, ItemStack mask, int damage) {
        ItemStack[] mods;
        ItemStack filter = ArmorUtil.getGasMaskFilter(mask);
        if (filter == null && ArmorModHandler.hasMods(mask) && (mods = ArmorModHandler.pryMods(mask))[0] != null && mods[0].func_77973_b() instanceof IGasMask) {
            filter = ArmorUtil.getGasMaskFilter(mods[0]);
        }
        if (filter == null || filter.func_77958_k() == 0) {
            return;
        }
        filter.func_77964_b(filter.func_77952_i() + damage);
        if (filter.func_77952_i() > filter.func_77958_k()) {
            ArmorUtil.removeFilter(mask);
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, HBMSoundHandler.gasmaskScrew, SoundCategory.PLAYERS, 0.8f, 0.1f);
        } else {
            ArmorUtil.installGasMaskFilter(mask, filter);
        }
    }

    public static void installGasMaskFilter(ItemStack mask, ItemStack filter) {
        if (mask == null || filter == null) {
            return;
        }
        if (!mask.func_77942_o()) {
            mask.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound attach = new NBTTagCompound();
        filter.func_77955_b(attach);
        mask.func_77978_p().func_74782_a(FILTERK_KEY, (NBTBase)attach);
    }

    public static void removeFilter(ItemStack mask) {
        if (mask == null) {
            return;
        }
        if (!mask.func_77942_o()) {
            return;
        }
        mask.func_77978_p().func_82580_o(FILTERK_KEY);
        if (mask.func_77978_p().func_82582_d()) {
            mask.func_77982_d(null);
        }
    }

    public static ItemStack getGasMaskFilter(ItemStack mask) {
        if (mask == null) {
            return null;
        }
        if (!mask.func_77942_o()) {
            return null;
        }
        NBTTagCompound attach = mask.func_77978_p().func_74775_l(FILTERK_KEY);
        ItemStack filter = new ItemStack(attach);
        if (filter.func_190926_b()) {
            return null;
        }
        return filter;
    }

    public static boolean checkForDigamma(EntityPlayer player) {
        if (ArmorUtil.checkArmor((EntityLivingBase)player, ModItems.fau_helmet, ModItems.fau_plate, ModItems.fau_legs, ModItems.fau_boots)) {
            return true;
        }
        if (ArmorUtil.checkArmor((EntityLivingBase)player, ModItems.dns_helmet, ModItems.dns_plate, ModItems.dns_legs, ModItems.dns_boots)) {
            return true;
        }
        return player.func_70644_a((Potion)HbmPotion.stability);
    }

    public static boolean checkForMonoMask(EntityPlayer player) {
        if (ArmorUtil.checkArmorPiece(player, ModItems.gas_mask, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.gas_mask_m65, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.gas_mask_mono, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.liquidator_helmet, 3)) {
            return true;
        }
        if (player.func_70644_a((Potion)HbmPotion.mutation)) {
            return true;
        }
        ItemStack helmet = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (!helmet.func_190926_b() && ArmorModHandler.hasMods(helmet)) {
            ItemStack[] mods = ArmorModHandler.pryMods(helmet);
            return mods[0] != null && mods[0].func_77973_b() == ModItems.attachment_mask_mono;
        }
        return false;
    }

    public static boolean checkForGoggles(EntityPlayer player) {
        if (ArmorUtil.checkArmorPiece(player, ModItems.goggles, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.ashglasses, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.t45_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.ajr_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.rpa_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.bj_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.hev_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.hazmat_paa_helmet, 3)) {
            return true;
        }
        return ArmorUtil.checkArmorPiece(player, ModItems.paa_helmet, 3);
    }

    public static ItemStack getGasMaskFilterRecursively(ItemStack mask) {
        ItemStack[] mods;
        ItemStack filter = ArmorUtil.getGasMaskFilter(mask);
        if ((filter == null || filter.func_190926_b()) && ArmorModHandler.hasMods(mask) && (mods = ArmorModHandler.pryMods(mask))[0] != null && mods[0].func_77973_b() instanceof IGasMask) {
            filter = ((IGasMask)mods[0].func_77973_b()).getFilter(mods[0]);
        }
        return filter;
    }

    public static void addGasMaskTooltip(ItemStack mask, World world, List<String> list, ITooltipFlag flagIn) {
        if (mask == null || !(mask.func_77973_b() instanceof IGasMask)) {
            return;
        }
        ItemStack filter = ((IGasMask)mask.func_77973_b()).getFilter(mask);
        if (filter == null) {
            list.add("\u00a7c" + I18nUtil.resolveKey("desc.nofilter", new Object[0]));
            return;
        }
        list.add("\u00a76" + I18nUtil.resolveKey("desc.infilter", new Object[0]));
        int meta = filter.func_77952_i();
        int max = filter.func_77958_k();
        String append = "";
        if (max > 0) {
            append = " (" + Library.getPercentage((double)(max - meta) / (double)max) + "%) " + (max - meta) + "/" + max;
        }
        ArrayList lore = new ArrayList();
        list.add("  " + filter.func_82833_r() + append);
        filter.func_77973_b().func_77624_a(filter, world, lore, flagIn);
        ForgeEventFactory.onItemTooltip((ItemStack)filter, null, lore, (ITooltipFlag)flagIn);
        lore.forEach(x -> list.add("\u00a7e  " + x));
    }
}

