/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.forgefluid;

import com.hbm.forgefluid.SpecialContainerFillLists;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class HbmFluidHandlerCell
implements ICapabilityProvider,
IFluidHandlerItem {
    public static final String FLUID_NBT_KEY = "HbmFluidKey";
    @Nonnull
    private ItemStack container;
    private int cap;

    public HbmFluidHandlerCell(ItemStack stack, int i) {
        this.container = stack;
        this.cap = i;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(this.getFluid(), this.cap)};
    }

    private FluidStack getFluid() {
        if (!this.container.func_77942_o()) {
            return null;
        }
        NBTTagCompound tag = this.container.func_77978_p();
        if (!tag.func_74764_b(FLUID_NBT_KEY)) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l(FLUID_NBT_KEY));
    }

    private void setFluid(FluidStack fluid) {
        if (!this.container.func_77942_o()) {
            this.container.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = this.container.func_77978_p();
        if (fluid == null) {
            this.container.func_77964_b(0);
            tag.func_82580_o(FLUID_NBT_KEY);
            return;
        }
        this.container.func_77964_b(this.cap - fluid.amount);
        tag.func_74782_a(FLUID_NBT_KEY, (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || this.container.func_190916_E() > 1) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained == null) {
            if (!this.canFillEmpty(resource)) {
                return 0;
            }
            int filled = Math.min(this.cap, resource.amount);
            if (doFill) {
                this.setFluid(new FluidStack(resource.getFluid(), filled));
            }
            return filled;
        }
        if (contained.getFluid() != resource.getFluid()) {
            return 0;
        }
        int filled = Math.min(this.cap - contained.amount, resource.amount);
        if (doFill) {
            this.setFluid(new FluidStack(contained.getFluid(), filled + contained.amount));
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.func_190916_E() > 1 || resource == null || this.getFluid() != null && this.getFluid().getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() > 1) {
            return null;
        }
        FluidStack contained = this.getFluid();
        if (contained == null) {
            return null;
        }
        int drained = Math.min(contained.amount, maxDrain);
        if (drained <= 0) {
            return null;
        }
        if (doDrain) {
            this.setFluid(drained >= contained.amount ? null : new FluidStack(contained.getFluid(), contained.amount - drained));
        }
        return new FluidStack(contained.getFluid(), drained);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.container.func_190916_E() > 1) {
            return false;
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.container.func_190916_E() > 1) {
            return null;
        }
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public boolean canFillEmpty(FluidStack stack) {
        if (stack != null) {
            return SpecialContainerFillLists.EnumCell.contains(stack.getFluid());
        }
        return false;
    }
}

