/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.CompatibilityConfig;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ExplosionTom {
    public int posX;
    public int posY;
    public int posZ;
    public int lastposX = 0;
    public int lastposZ = 0;
    public int radius;
    public int radius2;
    public World world;
    private int n = 1;
    private int nlimit;
    private int shell;
    private int leg;
    private int element;

    public void saveToNbt(NBTTagCompound nbt, String name) {
        nbt.func_74768_a(name + "posX", this.posX);
        nbt.func_74768_a(name + "posY", this.posY);
        nbt.func_74768_a(name + "posZ", this.posZ);
        nbt.func_74768_a(name + "lastposX", this.lastposX);
        nbt.func_74768_a(name + "lastposZ", this.lastposZ);
        nbt.func_74768_a(name + "radius", this.radius);
        nbt.func_74768_a(name + "radius2", this.radius2);
        nbt.func_74768_a(name + "n", this.n);
        nbt.func_74768_a(name + "nlimit", this.nlimit);
        nbt.func_74768_a(name + "shell", this.shell);
        nbt.func_74768_a(name + "leg", this.leg);
        nbt.func_74768_a(name + "element", this.element);
    }

    public void readFromNbt(NBTTagCompound nbt, String name) {
        this.posX = nbt.func_74762_e(name + "posX");
        this.posY = nbt.func_74762_e(name + "posY");
        this.posZ = nbt.func_74762_e(name + "posZ");
        this.lastposX = nbt.func_74762_e(name + "lastposX");
        this.lastposZ = nbt.func_74762_e(name + "lastposZ");
        this.radius = nbt.func_74762_e(name + "radius");
        this.radius2 = nbt.func_74762_e(name + "radius2");
        this.n = nbt.func_74762_e(name + "n");
        this.nlimit = nbt.func_74762_e(name + "nlimit");
        this.shell = nbt.func_74762_e(name + "shell");
        this.leg = nbt.func_74762_e(name + "leg");
        this.element = nbt.func_74762_e(name + "element");
    }

    public ExplosionTom(int x, int y, int z, World world, int rad) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.world = world;
        this.radius = rad;
        this.radius2 = this.radius * this.radius;
        this.nlimit = this.radius2 * 4;
    }

    public boolean update() {
        if (!CompatibilityConfig.isWarDim(this.world)) {
            return true;
        }
        this.breakColumn(this.lastposX, this.lastposZ);
        this.shell = (int)Math.floor((Math.sqrt(this.n) + 1.0) / 2.0);
        int shell2 = this.shell * 2;
        this.leg = (int)Math.floor((this.n - (shell2 - 1) * (shell2 - 1)) / shell2);
        this.element = this.n - (shell2 - 1) * (shell2 - 1) - shell2 * this.leg - this.shell + 1;
        int n = this.leg == 0 ? this.shell : (this.leg == 1 ? -this.element : (this.lastposX = this.leg == 2 ? -this.shell : this.element));
        this.lastposZ = this.leg == 0 ? this.element : (this.leg == 1 ? this.shell : (this.leg == 2 ? -this.element : -this.shell));
        ++this.n;
        return this.n > this.nlimit;
    }

    private void breakColumn(int x, int z) {
        int dist = this.radius2 - (x * x + z * z);
        if (dist > 0) {
            int pX = this.posX + x;
            int pZ = this.posZ + z;
            double X = Math.pow(this.posX - pX, 2.0);
            double Z = Math.pow(this.posZ - pZ, 2.0);
            double distance = Math.sqrt(X + Z);
            int y = 256;
            int terrain = 61;
            double cA = (double)terrain - Math.pow(Math.E, -Math.pow(Math.sqrt(x * x + z * z), 2.0) / 40000.0) * 13.0 + (double)this.world.field_73012_v.nextInt(2);
            double cB = cA + Math.pow(Math.E, -Math.pow(Math.sqrt(x * x + z * z) - 200.0, 2.0) / 400.0) * 13.0;
            int craterFloor = (int)(cB + Math.pow(Math.E, -Math.pow(Math.sqrt(x * x + z * z) - 500.0, 2.0) / 2000.0) * 37.0);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int i = 256; i > 0; --i) {
                if (i != craterFloor && this.world.func_175623_d((BlockPos)pos.func_181079_c(pX, i, pZ))) continue;
                y = i;
                break;
            }
            int height = terrain - 14;
            int offset2 = 20;
            int threshold = (int)((float)Math.sqrt(x * x + z * z) * (float)(height + offset2) / (float)this.radius) + this.world.field_73012_v.nextInt(2) - offset2;
            while (y > threshold && y != 0) {
                if (y <= craterFloor) {
                    pos.func_181079_c(pX, y, pZ);
                    if (craterFloor - y < 12) {
                        if (this.world.field_73012_v.nextInt(499) < 1) {
                            this.world.func_175656_a((BlockPos)pos, ModBlocks.ore_tektite_osmiridium.func_176223_P());
                        } else {
                            this.world.func_175656_a((BlockPos)pos, ModBlocks.tektite.func_176223_P());
                        }
                    } else {
                        this.world.func_175656_a((BlockPos)pos, ModBlocks.basalt_smooth.func_176223_P());
                    }
                } else if (distance < 500.0) {
                    Material m;
                    int k;
                    int j;
                    int i;
                    if (y > terrain + 1) {
                        for (i = -2; i < 3; ++i) {
                            for (j = -2; j < 3; ++j) {
                                for (k = -2; k < 3; ++k) {
                                    pos.func_181079_c(pX + i, y + j, pZ + k);
                                    m = this.world.func_180495_p((BlockPos)pos).func_185904_a();
                                    if (m != Material.field_151586_h && m != Material.field_151588_w && m != Material.field_151597_y && !m.func_76217_h()) continue;
                                    this.world.func_175698_g((BlockPos)pos);
                                    this.world.func_175698_g((BlockPos)pos.func_181079_c(pX, y, pZ));
                                }
                            }
                        }
                        this.world.func_175698_g((BlockPos)pos.func_181079_c(pX, y, pZ));
                    } else {
                        for (i = -2; i < 3; ++i) {
                            for (j = -2; j < 3; ++j) {
                                for (k = -2; k < 3; ++k) {
                                    pos.func_181079_c(pX + i, y + j, pZ + k);
                                    m = this.world.func_180495_p((BlockPos)pos).func_185904_a();
                                    if (m != Material.field_151586_h && m != Material.field_151588_w && !this.world.func_175623_d((BlockPos)pos.func_181079_c(pX + i, y, pZ + k))) continue;
                                    this.world.func_175656_a((BlockPos)pos.func_181079_c(pX + i, y, pZ + k), Blocks.field_150353_l.func_176223_P());
                                    this.world.func_175656_a((BlockPos)pos.func_181079_c(pX, y, pZ), Blocks.field_150353_l.func_176223_P());
                                }
                            }
                        }
                        this.world.func_175656_a((BlockPos)pos.func_181079_c(pX, y, pZ), Blocks.field_150353_l.func_176223_P());
                    }
                }
                --y;
            }
        }
    }
}

