/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.interfaces.IBomb;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.bomb.TileEntityLandmine;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Landmine
extends BlockContainer
implements IBomb {
    public static boolean safeMode = false;
    private static Random rand = new Random();
    public static final float f = 0.0625f;
    public static final AxisAlignedBB AP_BOX = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.125, 0.625);
    public static final AxisAlignedBB HE_BOX = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.125, 0.75);
    public static final AxisAlignedBB SHRAP_BOX = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.125, 0.75);
    public static final AxisAlignedBB FAT_BOX = new AxisAlignedBB(0.3125, 0.0, 0.25, 0.6875, 0.375, 0.75);

    public Landmine(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityLandmine();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this == ModBlocks.mine_ap) {
            return AP_BOX;
        }
        if (this == ModBlocks.mine_he) {
            return HE_BOX;
        }
        if (this == ModBlocks.mine_shrap) {
            return SHRAP_BOX;
        }
        if (this == ModBlocks.mine_fat) {
            return FAT_BOX;
        }
        return field_185505_j;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockFence;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag;
        if (world.func_175687_A(pos) > 0) {
            this.explode(world, pos);
        }
        boolean bl = flag = !world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && !(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockFence);
        if (flag) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!safeMode) {
            this.explode(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_184614_ca().func_77973_b() == ModItems.defuser || player.func_184592_cb().func_77973_b() == ModItems.defuser || player.func_184614_ca().func_77973_b() == ModItems.defuser_desh || player.func_184592_cb().func_77973_b() == ModItems.defuser_desh) {
            safeMode = true;
            world.func_175698_g(pos);
            ItemStack itemstack = new ItemStack((Block)this, 1);
            float f = world.field_73012_v.nextFloat() * 0.6f + 0.2f;
            float f1 = world.field_73012_v.nextFloat() * 0.2f;
            float f2 = world.field_73012_v.nextFloat() * 0.6f + 0.2f;
            EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1 + 1.0f), (double)((float)pos.func_177952_p() + f2), itemstack);
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityitem);
            }
            safeMode = false;
            return true;
        }
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this == ModBlocks.mine_fat) {
            tooltip.add("\u00a72[Nuclear Mine]\u00a7r");
            tooltip.add(" \u00a7eRadius: " + BombConfig.fatmanRadius + "m\u00a7r");
            tooltip.add("\u00a72[Fallout]\u00a7r");
            tooltip.add(" \u00a7aRadius: " + BombConfig.fatmanRadius * (1 + BombConfig.falloutRange / 100) + "m\u00a7r");
        }
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            safeMode = true;
            world.func_175655_b(pos, false);
            safeMode = false;
            if (this == ModBlocks.mine_ap) {
                world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 2.5f, false, false);
            }
            if (this == ModBlocks.mine_he) {
                ExplosionLarge.explode(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 10.0f, true, false, false);
            }
            if (this == ModBlocks.mine_shrap) {
                ExplosionLarge.explode(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.0f, true, false, false);
                ExplosionLarge.spawnShrapnelShower(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 1.0, 0.0, 45, 0.2);
                ExplosionLarge.spawnShrapnels(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 5);
            }
            if (this == ModBlocks.mine_fat) {
                world.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(world, BombConfig.fatmanRadius, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                if (rand.nextInt(100) == 0 || MainRegistry.polaroidID == 11) {
                    EntityNukeTorex.statFacBale(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, BombConfig.fatmanRadius);
                } else {
                    EntityNukeTorex.statFac(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, BombConfig.fatmanRadius);
                }
            }
        }
    }
}

