/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityShrapnel;
import com.hbm.explosion.ExplosionNT;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockVolcano
extends Block {
    public static final PropertyInteger META = BlockDummyable.META;
    public static final int META_STATIC_ACTIVE = 0;
    public static final int META_STATIC_EXTINGUISHING = 1;
    public static final int META_GROWING_ACTIVE = 2;
    public static final int META_GROWING_EXTINGUISHING = 3;

    public BlockVolcano(String s) {
        super(Material.field_151573_f);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add(this);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == CreativeTabs.field_78027_g || tab == this.func_149708_J()) {
            for (int i = 0; i < 4; ++i) {
                items.add((Object)new ItemStack((Block)this, 1, i));
            }
        }
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        int meta = stack.func_77952_i();
        tooltip.add(BlockVolcano.isGrowing(meta) ? TextFormatting.RED + "DOES GROW" : TextFormatting.DARK_GRAY + "DOES NOT GROW");
        tooltip.add(BlockVolcano.isExtinguishing(meta) ? TextFormatting.RED + "DOES EXTINGUISH" : TextFormatting.DARK_GRAY + "DOES NOT EXTINGUISH");
    }

    public int func_149738_a(World world) {
        return 5;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && world.func_175697_a(pos, 20)) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            int meta = (Integer)world.func_180495_p(pos).func_177229_b((IProperty)META);
            this.blastMagmaChannel(world, x, y, z, rand);
            this.raiseMagma(world, x, y, z, rand);
            this.spawnBlobs(world, x, y, z, rand);
            this.spawnSmoke(world, x, y, z, rand);
            this.updateVolcano(world, x, y, z, rand, meta);
        }
    }

    private void blastMagmaChannel(World world, int x, int y, int z, Random rand) {
        List<ExplosionNT.ExAttrib> attribs = Arrays.asList(ExplosionNT.ExAttrib.NODROP, ExplosionNT.ExAttrib.LAVA_V, ExplosionNT.ExAttrib.NOSOUND, ExplosionNT.ExAttrib.ALLMOD, ExplosionNT.ExAttrib.NOHURT);
        ExplosionNT explosion = new ExplosionNT(world, null, (double)x + 0.5, (double)(y + rand.nextInt(15)) + 1.5, (double)z + 0.5, 7.0f);
        explosion.addAllAttrib(attribs);
        explosion.explode();
        ExplosionNT explosion2 = new ExplosionNT(world, null, (double)x + 0.5 + rand.nextGaussian() * 3.0, rand.nextInt(y + 1), (double)z + 0.5 + rand.nextGaussian() * 3.0, 10.0f);
        explosion2.addAllAttrib(attribs);
        explosion2.explode();
    }

    private void raiseMagma(World world, int x, int y, int z, Random rand) {
        int rZ;
        int rY;
        int rX = x - 10 + rand.nextInt(21);
        BlockPos pos = new BlockPos(rX, rY = y + rand.nextInt(11), rZ = z - 10 + rand.nextInt(21));
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a && world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.volcanic_lava_block) {
            world.func_175656_a(pos, ModBlocks.volcanic_lava_block.func_176223_P());
        }
    }

    private void spawnBlobs(World world, int x, int y, int z, Random rand) {
        for (int i = 0; i < 3; ++i) {
            EntityShrapnel frag = new EntityShrapnel(world);
            frag.func_70012_b((double)x + 0.5, (double)y + 1.5, (double)z + 0.5, 0.0f, 0.0f);
            frag.field_70181_x = 2.0 + rand.nextDouble();
            frag.field_70159_w = rand.nextGaussian() * 0.2;
            frag.field_70179_y = rand.nextGaussian() * 0.2;
            frag.setVolcano(true);
            world.func_72838_d((Entity)frag);
        }
    }

    private void spawnSmoke(World world, int x, int y, int z, Random rand) {
        NBTTagCompound dPart = new NBTTagCompound();
        dPart.func_74778_a("type", "vanillaExt");
        dPart.func_74778_a("mode", "volcano");
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(dPart, (double)x + 0.5, y + 10, (double)z + 0.5), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)x + 0.5, (double)(y + 10), (double)z + 0.5, 250.0));
    }

    private void updateVolcano(World world, int x, int y, int z, Random rand, int meta) {
        BlockPos pos = new BlockPos(x, y, z);
        if (rand.nextDouble() < this.getProgressChance(world, x, y, z, rand, meta)) {
            if (this.shouldGrow(world, x, y, z, rand, meta)) {
                ++y;
                world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            if (i + j + k == 0) {
                                world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta)), 3);
                                continue;
                            }
                            world.func_175656_a(pos.func_177982_a(i, j, k), ModBlocks.volcanic_lava_block.func_176223_P());
                        }
                    }
                }
            } else if (BlockVolcano.isExtinguishing(meta)) {
                world.func_175656_a(pos, ModBlocks.volcanic_lava_block.func_176223_P());
            }
        }
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public static boolean isGrowing(int meta) {
        return meta == 2 || meta == 3;
    }

    public static boolean isExtinguishing(int meta) {
        return meta == 1 || meta == 3;
    }

    private boolean shouldGrow(World world, int x, int y, int z, Random rand, int meta) {
        if (!BlockVolcano.isGrowing(meta)) {
            return false;
        }
        return y < 200;
    }

    private double getProgressChance(World world, int x, int y, int z, Random rand, int meta) {
        if (meta == 1) {
            return 3.0E-5;
        }
        if (BlockVolcano.isGrowing(meta) && (meta != 2 || y < 199)) {
            return 0.007;
        }
        return 0.0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{META});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta));
    }
}

