/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.common.world.NoiseGeneratorBOP;
import java.util.Random;
import net.minecraft.world.gen.NoiseGenerator;

public class NoiseGeneratorOctavesBOP
extends NoiseGenerator {
    private NoiseGeneratorBOP[] generatorCollection;
    private int numOctaves;

    public NoiseGeneratorOctavesBOP(Random rand, int numOctaves) {
        this.numOctaves = numOctaves;
        this.generatorCollection = new NoiseGeneratorBOP[numOctaves];
        for (int j = 0; j < numOctaves; ++j) {
            this.generatorCollection[j] = new NoiseGeneratorBOP(rand);
        }
    }

    public double[][] generateNoiseOctaves(int chunkX, int chunkZ, double firstWavelength) {
        return this.generateNoiseOctaves(chunkX, chunkZ, 5, 5, firstWavelength);
    }

    public double[][] generateNoiseOctaves(int chunkX, int chunkZ, int numX, int numZ, double firstWavelength) {
        return this.generateNoiseOctaves(chunkX, chunkZ, numX, numZ, firstWavelength, 1.0);
    }

    public double[][] generateNoiseOctaves(int chunkX, int chunkZ, int numX, int numZ, double firstWavelength, double amplitude) {
        double[][] out = new double[this.numOctaves][numX * numZ];
        double wavelength = firstWavelength;
        for (int i = 0; i < this.numOctaves; ++i) {
            out[i] = this.generatorCollection[i].populateNoiseArrayXZ(chunkX, chunkZ, numX, numZ, wavelength, amplitude);
            wavelength *= 2.0;
        }
        return out;
    }
}

