/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.config;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.client.gui.widget.GuiActionButton;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.ConfigOption;

public class EditStringConfigOptionScreen<T>
extends ScreenBase {
    private GuiTextField editBox;
    private GuiButton confirmButton;
    private final Config config;
    private final Config enforcedConfig;
    private final ConfigOption<T> configOption;
    private final boolean allowEmpty;
    private final boolean emptyMeansNull;
    private final Runnable postConfirmAction;
    private boolean valid;
    private String currentValue;
    private ITextComponent enforcedValueLabel;
    protected boolean shouldRenderEscapeScreen;

    public EditStringConfigOptionScreen(GuiScreen parent, GuiScreen escape, Config config, Config enforcedConfig, ConfigOption<T> configOption, boolean allowEmpty, boolean emptyMeansNull, Runnable postConfirmAction) {
        super(parent, escape, configOption.getDisplayName());
        this.config = config;
        this.enforcedConfig = enforcedConfig;
        this.configOption = configOption;
        this.allowEmpty = allowEmpty;
        this.emptyMeansNull = emptyMeansNull;
        this.postConfirmAction = postConfirmAction;
        T value = config.get(configOption);
        this.currentValue = value == null ? "" : configOption.getValueType().getIoCodec().encode(value, null, configOption);
        this.shouldRenderEscapeScreen = false;
        this.canSkipWorldRender = false;
        if (parent instanceof EditConfigScreen) {
            EditConfigScreen configScreen = (EditConfigScreen)parent;
            this.shouldRenderEscapeScreen = configScreen.shouldRenderEscapeScreen;
            this.canSkipWorldRender = configScreen.canSkipWorldRender();
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Object enforcedValue = this.enforcedConfig == null ? null : (Object)this.enforcedConfig.get(this.configOption);
        this.enforcedValueLabel = enforcedValue == null ? null : new TextComponentTranslation("gui.xaero_config_value_enforced_string_edit", new Object[]{this.configOption.getValueType().getIoCodec().encode(enforcedValue, null, this.configOption)}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
        this.editBox = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 7 + 29 - 2, 200, 20);
        this.editBox.func_146203_f(this.configOption.getValueType().getIoCodec().getMaxStringLength());
        this.editBox.func_146180_a(this.currentValue);
        this.editBox.func_175207_a(new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int id, boolean value) {
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175319_a(int id, String value) {
                EditStringConfigOptionScreen.this.onChange(value);
            }
        });
        this.textFields.add(this.editBox);
        this.setFocusedTextField(this.editBox);
        this.confirmButton = new GuiActionButton(this.field_146294_l / 2 - 105, this.field_146295_m / 7 + 29 + 48, 100, 20, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                EditStringConfigOptionScreen.this.confirm();
            }
        };
        this.field_146292_n.add(this.confirmButton);
        this.field_146292_n.add(new GuiActionButton(this.field_146294_l / 2 + 5, this.field_146295_m / 7 + 29 + 48, 100, 20, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                EditStringConfigOptionScreen.this.goBack();
            }
        });
        this.valid = true;
        this.updateConfirmButton();
    }

    private void onChange(String s) {
        this.currentValue = s;
        this.valid = true;
        if (this.editBox.func_146179_b().isEmpty()) {
            this.valid = this.allowEmpty;
            this.updateConfirmButton();
            return;
        }
        try {
            T value = this.configOption.getValueType().getIoCodec().decode(s, null, this.configOption);
            this.valid = this.configOption.isValidValue(value);
        }
        catch (Throwable t) {
            this.valid = false;
        }
        this.updateConfirmButton();
    }

    private boolean canConfirm() {
        return this.valid;
    }

    private void updateConfirmButton() {
        this.confirmButton.field_146124_l = this.canConfirm();
    }

    public void confirm() {
        Object value;
        if (!this.canConfirm()) {
            return;
        }
        Object t = value = this.editBox.func_146179_b().isEmpty() && this.emptyMeansNull ? null : (Object)this.configOption.getValueType().getIoCodec().decode(this.editBox.func_146179_b(), null, this.configOption);
        if (value != null && !this.configOption.isValidValue(value)) {
            return;
        }
        this.config.set(this.configOption, value);
        this.postConfirmAction.run();
        this.goBack();
    }

    @Override
    protected void func_73869_a(char character, int keyCode) throws IOException {
        if ((keyCode == 28 || keyCode == 156) && this.canConfirm()) {
            this.func_146284_a(this.confirmButton);
        }
        super.func_73869_a(character, keyCode);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partial) {
        if (this.shouldRenderEscapeScreen) {
            this.renderEscapeScreen(mouseX, mouseY, partial);
        }
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partial);
        if (this.enforcedValueLabel != null) {
            this.func_73732_a(this.field_146289_q, this.enforcedValueLabel.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 7 + 29 - 22, 0xFFFFFF);
        }
        this.func_73732_a(this.field_146289_q, this.title.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 7 + 29 - 42, 0xFFFFFF);
    }

    @Override
    public void onClose() {
        this.onExit(this.parent);
    }
}

