/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.config;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.lib.XaeroLib;
import xaero.lib.client.config.option.ui.ConfigOptionScreenEntry;
import xaero.lib.client.gui.GuiSettings;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.TextSettingEntry;
import xaero.lib.client.gui.config.ConfigProfileCreationScreen;
import xaero.lib.client.gui.config.ConfigProfileDropdownContext;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.client.gui.widget.MyTinyButton;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownWidgetCallback;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.primary.option.BuiltInPrimaryCommonConfigOptions;
import xaero.lib.common.config.profile.ConfigProfile;
import xaero.lib.common.config.profile.IConfigProfileInfo;

public abstract class EditConfigScreen
extends GuiSettings {
    private static final ITextComponent NO_PERMISSION_0 = new TextComponentTranslation("gui.xaero_no_config_edit_permission_0", new Object[0]);
    private static final ITextComponent NO_PERMISSION_1 = new TextComponentTranslation("gui.xaero_no_config_edit_permission_1", new Object[0]);
    protected final IEditConfigScreenContext context;
    protected final ConfigChannel channel;
    private boolean shouldHandleChangesOnExit;
    private DropDownWidget dropdown;
    private boolean syncStatusOnUpdate;
    private ConfigProfile profileOnUpdate;
    private ConfigProfileDropdownContext dropdownContext;
    private boolean hasPermissionToEdit;
    private ISettingEntry[] entriesBackup;
    private boolean shouldAskToConfirmOnExit;
    protected boolean shouldRenderEscapeScreen;
    private GuiButton setDefaultButton;

    public EditConfigScreen(ITextComponent title, GuiScreen backScreen, GuiScreen escScreen, IEditConfigScreenContext context, ConfigChannel channel) {
        super((ITextComponent)new TextComponentTranslation(context.getScreenTitleFormat(), new Object[]{title}), backScreen, escScreen, !context.isAutoConfirm());
        this.context = context;
        this.channel = channel;
        this.shouldRenderEscapeScreen = true;
        this.canSkipWorldRender = true;
        if (!(backScreen instanceof EditConfigScreen)) {
            context.reset(channel);
            return;
        }
        EditConfigScreen backEditConfigScreen = (EditConfigScreen)backScreen;
        if (backEditConfigScreen.channel != channel || backEditConfigScreen.context != context) {
            context.reset(channel);
        }
    }

    private void updateEditedProfile() {
        this.hasPermissionToEdit = this.context.hasPermission(this.channel);
        if (!this.hasPermissionToEdit) {
            return;
        }
        this.syncStatusOnUpdate = this.context.getSyncStatus(this.channel);
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        if (editedProfile == null && this.syncStatusOnUpdate) {
            this.context.setCurrentProfile(this.context.getDefaultProfileId(this.channel), this.channel);
            this.syncStatusOnUpdate = this.context.getSyncStatus(this.channel);
            editedProfile = this.context.getCurrentProfile(this.channel);
        }
        if (this.profileOnUpdate == editedProfile) {
            return;
        }
        this.profileOnUpdate = editedProfile;
        this.onEditedProfileSwitch();
        this.shouldAskToConfirmOnExit = false;
        this.shouldHandleChangesOnExit = false;
    }

    protected void onEditedProfileSwitch() {
    }

    public boolean getSyncStatus() {
        return this.context.getSyncStatus(this.channel);
    }

    @Override
    public void func_73866_w_() {
        this.updateEditedProfile();
        if (!this.syncStatusOnUpdate || !this.hasPermissionToEdit) {
            if (this.entries != null) {
                this.entriesBackup = this.entries;
            }
            this.entries = null;
        } else if (this.entriesBackup != null) {
            this.entries = this.entriesBackup;
            this.entriesBackup = null;
        }
        super.func_73866_w_();
        this.dropdownContext = !this.hasPermissionToEdit ? null : new ConfigProfileDropdownContext(this.context, this.channel, this.profileOnUpdate, this.context.getSelectedProfileId(this.channel), true);
        String[] dropdownOptions = this.dropdownContext == null ? null : this.dropdownContext.getOptions();
        this.dropdown = null;
        if (dropdownOptions == null) {
            return;
        }
        int dropdownX = this.field_146294_l / 2 - 100;
        if (this.canSearch) {
            if (this.searchField != null) {
                this.searchField.field_146209_f = this.field_146294_l / 2 + 5;
            }
            dropdownX = this.field_146294_l / 2 - 205;
        }
        this.dropdown = DropDownWidget.Builder.begin().setCallback(new IDropDownWidgetCallback(){

            @Override
            public boolean onSelected(DropDownWidget menu, int selected) {
                return EditConfigScreen.this.onDropdownSelection(menu, selected);
            }
        }).setContainer(this).setX(dropdownX).setY(this.field_146295_m / 7 + 9).setW(200).setSelected(this.dropdownContext.getInitialSelection()).setOptions(dropdownOptions).build();
        this.addWidget(this.dropdown);
        int verticalOffset = this.getVerticalOffset();
        MyTinyButton deleteButton = new MyTinyButton(this.field_146294_l / 2 + 130, this.field_146295_m / 7 + 5 + verticalOffset - 48, I18n.func_135052_a((String)"gui.xaero_delete_profile", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                EditConfigScreen.this.onDeleteProfileButton();
            }
        };
        this.func_189646_b(deleteButton);
        this.setDefaultButton = null;
        if (!this.context.isAutoDefaultProfile()) {
            this.setDefaultButton = new MyTinyButton(this.field_146294_l / 2 - 205, this.field_146295_m / 7 + 5 + verticalOffset - 48, I18n.func_135052_a((String)"gui.xaero_set_default_profile", (Object[])new Object[0])){

                @Override
                protected void onPress() {
                    EditConfigScreen.this.onSetDefaultButton();
                }
            };
            this.func_189646_b(this.setDefaultButton);
            this.setDefaultButton.field_146124_l = this.canSetDefault(this.profileOnUpdate);
        }
        String defaultProfileId = BuiltInPrimaryCommonConfigOptions.DEFAULT_ENFORCED_PROFILE.getDefaultValue();
        deleteButton.field_146124_l = this.profileOnUpdate != null && !this.profileOnUpdate.getId().equals(defaultProfileId);
    }

    private boolean onDropdownSelection(DropDownWidget menu, final int selected) {
        if (!this.context.getSyncStatus(this.channel)) {
            return false;
        }
        this.handleChanges();
        if (this.shouldAskToConfirmOnExit) {
            this.askForConfirmation(new Runnable(){

                @Override
                public void run() {
                    EditConfigScreen.this.field_146297_k.func_147108_a((GuiScreen)EditConfigScreen.this);
                    EditConfigScreen.this.onDropdownSelection(selected);
                }
            });
            return false;
        }
        return this.onDropdownSelection(selected);
    }

    private boolean onDropdownSelection(int selected) {
        if (selected >= this.dropdownContext.getProfiles().length) {
            this.field_146297_k.func_147108_a((GuiScreen)new ConfigProfileCreationScreen(this, this.context, this.channel, new Runnable(){

                @Override
                public void run() {
                    EditConfigScreen.this.onCreatedProfile();
                }
            }));
            return true;
        }
        IConfigProfileInfo newCurrent = this.dropdownContext.getProfiles()[selected];
        String newCurrentId = newCurrent.getId();
        this.context.setCurrentProfile(newCurrentId, this.channel);
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        return true;
    }

    private void onCreatedProfile() {
    }

    private boolean canSetDefault(ConfigProfile editedProfile) {
        return editedProfile != null && !editedProfile.getId().equals(this.context.getDefaultProfileId(this.channel));
    }

    private void onSetDefaultButton() {
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        if (editedProfile == null) {
            return;
        }
        if (!this.canSetDefault(editedProfile)) {
            return;
        }
        this.context.setDefaultProfileId(editedProfile.getId(), this.channel);
        this.setDefaultButton.field_146124_l = false;
    }

    private void onDeleteProfileButton() {
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        if (editedProfile == null) {
            return;
        }
        final ConfigProfile profileToDelete = editedProfile;
        this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

            public void func_73878_a(boolean result, int id) {
                EditConfigScreen.this.deleteProfileCallback(profileToDelete, result, id);
            }
        }, I18n.func_135052_a((String)"gui.xaero_delete_profile_0", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_delete_profile_1", (Object[])new Object[]{profileToDelete.getName(), profileToDelete.getId()}), -1));
    }

    private void deleteProfileCallback(ConfigProfile profileToDelete, boolean result, int id) {
        if (result) {
            this.onDeleteProfile(profileToDelete);
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    private void onDeleteProfile(ConfigProfile profile) {
        if (profile == null) {
            return;
        }
        String defaultProfileId = BuiltInPrimaryCommonConfigOptions.DEFAULT_ENFORCED_PROFILE.getDefaultValue();
        if (profile.getId().equals(defaultProfileId)) {
            return;
        }
        this.context.deleteProfile(profile, this.channel);
        this.context.reset(this.channel);
        this.context.setCurrentProfile(defaultProfileId, this.channel);
        this.updateEditedProfile();
    }

    public void handleChangesOnExit() {
        this.shouldHandleChangesOnExit = true;
    }

    @Override
    public void onExit(GuiScreen screen) {
        this.handleChanges();
        if (this.shouldAskToConfirmOnExit) {
            this.askForConfirmation(screen);
            return;
        }
        super.onExit(screen);
    }

    private void askForConfirmation(final GuiScreen destinationScreen) {
        this.askForConfirmation(new Runnable(){

            @Override
            public void run() {
                EditConfigScreen.this.field_146297_k.func_147108_a(destinationScreen);
            }
        });
    }

    private void askForConfirmation(final Runnable queuedAction) {
        this.shouldAskToConfirmOnExit = false;
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        int changeCount = editedProfile.getChangeCount();
        if (changeCount == 0) {
            this.context.reset(this.channel);
            queuedAction.run();
            return;
        }
        this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

            public void func_73878_a(boolean result, int id) {
                EditConfigScreen.this.askForConfirmationCallback(queuedAction, result, id);
            }
        }, I18n.func_135052_a((String)"gui.xaero_confirm_save_0", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_confirm_save_1", (Object[])new Object[]{changeCount}), -1));
    }

    private void askForConfirmationCallback(Runnable queuedAction, boolean result, int id) {
        if (result) {
            this.confirmProfile();
        }
        this.context.reset(this.channel);
        queuedAction.run();
    }

    @Override
    protected void confirm() {
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        if (editedProfile == null) {
            super.confirm();
            return;
        }
        this.handleChanges();
        this.confirmProfile();
        super.confirm();
    }

    private void confirmProfile() {
        this.shouldAskToConfirmOnExit = false;
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        this.context.confirmProfile(editedProfile, this.channel);
    }

    private void onWidgetChange() {
        if (!this.context.isAutoConfirm()) {
            this.shouldAskToConfirmOnExit = true;
            return;
        }
        this.confirmProfile();
    }

    protected void handleChanges() {
        if (!this.shouldHandleChangesOnExit) {
            return;
        }
        this.shouldHandleChangesOnExit = false;
        this.onWidgetChange();
        if (!this.context.isClientSide()) {
            return;
        }
        this.channel.getPrimaryClientConfigManagerIO().save();
    }

    public <T> ConfigOptionScreenEntry<T> optionEntry(ConfigOption<T> option) {
        return new ConfigOptionScreenEntry<T>(option, new Supplier<Config>(){

            @Override
            public Config get() {
                return EditConfigScreen.this.context.getCurrentProfile(EditConfigScreen.this.channel);
            }
        }, new Supplier<Config>(){

            @Override
            public Config get() {
                return EditConfigScreen.this.context.getEnforcedConfig(EditConfigScreen.this.channel);
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (Minecraft.func_71410_x().field_71462_r instanceof EditConfigScreen) {
                    ((EditConfigScreen)Minecraft.func_71410_x().field_71462_r).onWidgetChange();
                } else {
                    EditConfigScreen.this.onWidgetChange();
                }
            }
        }, this.channel, this.context.isClientSide());
    }

    public <T> ConfigOptionScreenEntry<T> primaryOptionEntry(ConfigOption<T> option) {
        return new ConfigOptionScreenEntry<T>(option, new Supplier<Config>(){

            @Override
            public Config get() {
                return EditConfigScreen.this.channel.getPrimaryClientConfigManager().getConfig();
            }
        }, new Supplier<Config>(){

            @Override
            public Config get() {
                return null;
            }
        }, new Runnable(){

            @Override
            public void run() {
                EditConfigScreen.this.channel.getPrimaryClientConfigManagerIO().save();
            }
        }, this.channel, this.context.isClientSide(), !this.context.isClientSide());
    }

    public <T> ConfigOptionScreenEntry<T> libPrimaryOptionEntry(ConfigOption<T> option) {
        return new ConfigOptionScreenEntry<T>(option, new Supplier<Config>(){

            @Override
            public Config get() {
                return XaeroLib.INSTANCE.getLibConfigChannel().getPrimaryClientConfigManager().getConfig();
            }
        }, new Supplier<Config>(){

            @Override
            public Config get() {
                return null;
            }
        }, new Runnable(){

            @Override
            public void run() {
                XaeroLib.INSTANCE.getLibConfigChannel().getPrimaryClientConfigManagerIO().save();
            }
        }, XaeroLib.INSTANCE.getLibConfigChannel(), this.context.isClientSide(), !this.context.isClientSide());
    }

    public IEditConfigScreenContext getContext() {
        return this.context;
    }

    public ConfigProfile getProfileOnUpdate() {
        return this.profileOnUpdate;
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        if (this.hasPermissionToEdit && !this.syncStatusOnUpdate && this.context.getSyncStatus(this.channel)) {
            this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
        if (this.shouldRenderEscapeScreen) {
            this.renderEscapeScreen(par1, par2, par3);
        }
        super.func_73863_a(par1, par2, par3);
        if (!this.hasPermissionToEdit) {
            this.func_73732_a(this.field_146289_q, NO_PERMISSION_0.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 7 + 34, -1);
            this.func_73732_a(this.field_146289_q, NO_PERMISSION_1.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 7 + 54, -1);
            return;
        }
        if (!this.syncStatusOnUpdate) {
            ITextComponent syncMessage = this.context.getSyncMessage();
            this.func_73732_a(this.field_146289_q, syncMessage.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 7 + 34, -1);
        }
    }

    public ISettingEntry createProfileIDEntry() {
        return new TextSettingEntry(new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return new TextComponentTranslation("gui.xaero_config_profile_id", new Object[]{EditConfigScreen.this.context.getSelectedProfileId(EditConfigScreen.this.channel)});
            }
        });
    }

    protected void resetProfileToDefaults() {
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        if (editedProfile == null) {
            return;
        }
        editedProfile.setDefaults(true);
        this.onWidgetChange();
    }

    protected void resetPrimaryToDefaults() {
        this.channel.getPrimaryClientConfigManager().getConfig().setDefaults(false);
    }

    @Override
    protected int getVerticalOffset() {
        return 24;
    }
}

