/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.config;

import java.io.IOException;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.ConfigProfileDropdownContext;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownWidgetCallback;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.option.BuiltInProfiledConfigOptions;
import xaero.lib.common.config.util.ConfigUtils;

public final class ConfigProfileCreationScreen
extends ScreenBase {
    private static final ITextComponent PROFILE_TO_COPY_COMPONENT = new TextComponentTranslation("gui.xaero_config_profile_to_copy", new Object[0]);
    private DropDownWidget profileToCopyDropdown;
    private GuiTextField editBox;
    private GuiButton confirmButton;
    private String currentValue;
    private final IEditConfigScreenContext context;
    private final ConfigChannel channel;
    private final Runnable onConfirm;
    private ConfigProfileDropdownContext dropdownContext;
    private String selectedProfileToCopy;

    protected ConfigProfileCreationScreen(GuiScreen parent, IEditConfigScreenContext context, ConfigChannel channel, Runnable onConfirm) {
        super(parent, parent, (ITextComponent)new TextComponentTranslation("gui.xaero_config_profile_creation_screen", new Object[0]));
        this.context = context;
        this.channel = channel;
        this.onConfirm = onConfirm;
        this.currentValue = "";
        this.selectedProfileToCopy = context.getSelectedProfileId(channel);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.dropdownContext = new ConfigProfileDropdownContext(this.context, this.channel, null, this.selectedProfileToCopy, false);
        this.profileToCopyDropdown = DropDownWidget.Builder.begin().setX(this.field_146294_l / 2 - 100).setY(this.field_146295_m / 7 + 15).setW(200).setCallback(new IDropDownWidgetCallback(){

            @Override
            public boolean onSelected(DropDownWidget menu, int selected) {
                return ConfigProfileCreationScreen.this.onDropdownSelection(menu, selected);
            }
        }).setOptions(this.dropdownContext.getOptions()).setSelected(this.dropdownContext.getInitialSelection()).setContainer(this).build();
        this.addWidget(this.profileToCopyDropdown);
        this.editBox = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 7 + 55, 200, 20);
        this.textFields.add(this.editBox);
        this.editBox.func_146203_f(50);
        this.setFocusedTextField(this.editBox);
        this.editBox.func_146180_a(this.currentValue);
        this.editBox.func_175207_a(new GuiPageButtonList.GuiResponder(){

            public void func_175319_a(int id, String value) {
                ConfigProfileCreationScreen.this.onChange(value);
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175321_a(int id, boolean value) {
            }
        });
        this.confirmButton = new MySmallButton(200, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, (ITextComponent)new TextComponentTranslation("gui.xaero_confirm", new Object[0])){

            @Override
            protected void onPress() {
                ConfigProfileCreationScreen.this.confirm();
            }
        };
        this.field_146292_n.add(this.confirmButton);
        this.field_146292_n.add(new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, (ITextComponent)new TextComponentTranslation("gui.xaero_cancel", new Object[0])){

            @Override
            protected void onPress() {
                ConfigProfileCreationScreen.this.goBack();
            }
        });
        this.updateConfirmButton();
    }

    private boolean onDropdownSelection(DropDownWidget menu, int selected) {
        if (!this.context.getSyncStatus(this.channel)) {
            return false;
        }
        this.selectedProfileToCopy = this.dropdownContext.getProfiles()[selected].getId();
        return true;
    }

    private void onChange(String s) {
        this.currentValue = s;
        this.updateConfirmButton();
    }

    private boolean canConfirm() {
        return !this.editBox.func_146179_b().isEmpty() && BuiltInProfiledConfigOptions.PROFILE_NAME.isValidValue(this.editBox.func_146179_b());
    }

    private void updateConfirmButton() {
        this.confirmButton.field_146124_l = this.canConfirm();
    }

    public void confirm() {
        if (!this.canConfirm()) {
            return;
        }
        String autoId = ConfigUtils.getAutoProfileIdForName(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return ConfigProfileCreationScreen.this.profileExists(s);
            }
        }, this.editBox.func_146179_b());
        this.createProfile(autoId, this.editBox.func_146179_b(), this.selectedProfileToCopy);
        this.context.setCurrentProfile(autoId, this.channel);
        this.onConfirm.run();
        this.goBack();
    }

    private boolean profileExists(String id) {
        return this.context.profileExists(id, this.channel);
    }

    private void createProfile(String id, String name, String profileToCopy) {
        this.context.createProfile(id, name, this.channel, profileToCopy);
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if ((keyCode == 28 || keyCode == 156) && this.canConfirm()) {
            this.func_146284_a(this.confirmButton);
        }
    }

    @Override
    public void func_146276_q_() {
        super.func_146276_q_();
        this.func_73732_a(this.field_146289_q, PROFILE_TO_COPY_COMPONENT.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 7, -1);
        this.func_73732_a(this.field_146289_q, this.title.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 7 + 40, -1);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partial) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partial);
    }
}

