/*
 * Decompiled with CFR 0.152.
 */
package com.edek.dg.worlddefender.utils;

import com.edek.dg.worlddefender.WorldDefender;
import com.edek.dg.worlddefender.items.RegionWand;
import com.edek.dg.worlddefender.main.AxisRegions;
import com.edek.dg.worlddefender.main.RegionSaver;
import com.edek.dg.worlddefender.main.Regions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class RegionsUtil {
    public static void addPlayer(String regions, EntityPlayerMP player, String name) {
        if (RegionSaver.getRegions().containsKey(regions)) {
            Regions region = RegionSaver.getRegions().get(regions);
            if (!region.getPlayerList().contains(name)) {
                region.getPlayerList().add(name);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.addplayer", new Object[0]));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.errorplayer", new Object[0]));
            }
            RegionSaver.save();
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.unknown", new Object[]{regions}));
        }
    }

    public static void createRegion(String regionName, EntityPlayerMP player, ItemStack item) {
        if (item.func_77973_b() instanceof RegionWand) {
            if (item.func_77942_o() && item.func_77978_p().func_74767_n("valide")) {
                AxisRegions axisRegions = new AxisRegions(item.func_77978_p().func_74762_e("x1"), item.func_77978_p().func_74762_e("y1"), item.func_77978_p().func_74762_e("z1"), item.func_77978_p().func_74762_e("x2"), item.func_77978_p().func_74762_e("y2"), item.func_77978_p().func_74762_e("z2")).expandXyz(1);
                Regions region = new Regions(regionName, axisRegions, player.field_70170_p.field_73011_w.getDimension(), false);
                RegionSaver.addRegion(region);
                RegionSaver.save();
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.define", new Object[]{regionName}));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.itemhand.choose", new Object[0]));
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.itemhand.take", new Object[0]));
        }
    }

    public static void createGlobalRegion(String regionName, int dimensionID) {
        if (!RegionSaver.getRegions().containsKey(regionName)) {
            AxisRegions axisRegions = new AxisRegions(-1, -1, -1, -1, -1, -1);
            Regions region = new Regions(regionName, axisRegions, dimensionID, true);
            RegionSaver.addRegion(region);
            RegionSaver.save();
            WorldDefender.log.info("Created new global region: {}", (Object)regionName);
        }
    }

    public static void deleteRegion(String region, EntityPlayerMP player) {
        if (RegionSaver.getRegions().get(region).getIsGlobal()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.global.delete", new Object[]{region}));
        } else if (RegionSaver.getRegions().remove(region) != null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.remove", new Object[]{region}));
            RegionSaver.save();
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.unknown", new Object[]{region}));
        }
    }

    public static List<Regions> getHandlingRegionsFor(BlockPos pos, int dim) {
        int maxPriority = 0;
        ArrayList<Regions> handlers = new ArrayList<Regions>();
        for (Regions region : RegionSaver.getRegions().values()) {
            if (region.getDimension() != dim) continue;
            if (region.getIsGlobal()) {
                if (region.getPriority() == maxPriority) {
                    handlers.add(region);
                    continue;
                }
                if (region.getPriority() <= maxPriority) continue;
                handlers.clear();
                maxPriority = region.getPriority();
                handlers.add(region);
                continue;
            }
            if (!region.getArea().isVecInside(new Vec3d((Vec3i)pos))) continue;
            if (region.getPriority() == maxPriority) {
                handlers.add(region);
                continue;
            }
            if (region.getPriority() <= maxPriority) continue;
            handlers.clear();
            maxPriority = region.getPriority();
            handlers.add(region);
        }
        return handlers;
    }

    public static List<Regions> getHandlingRegionsFor(BlockPos pos, int dim, double minTrans, double maxTrans) {
        int maxPriority = 0;
        ArrayList<Regions> handlers = new ArrayList<Regions>();
        for (Regions region : RegionSaver.getRegions().values()) {
            if (region.getDimension() != dim || !region.getArea().isVecInside(new Vec3d((Vec3i)pos), minTrans, maxTrans)) continue;
            if (region.getPriority() == maxPriority) {
                handlers.add(region);
                continue;
            }
            if (region.getPriority() <= maxPriority) continue;
            handlers.clear();
            maxPriority = region.getPriority();
            handlers.add(region);
        }
        return handlers;
    }

    public static void getPriority(String regionName, EntityPlayerMP player) {
        if (RegionSaver.getRegions().containsKey(regionName)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.infopriority", new Object[]{regionName, RegionSaver.getRegions().get(regionName).getPriority()}));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.unknown", new Object[]{regionName}));
        }
    }

    public static void giveRegionList(EntityPlayerMP player) {
        StringBuilder b = new StringBuilder();
        Object[] arr = RegionSaver.getRegions().keySet().toArray();
        for (int i = 0; i < arr.length; ++i) {
            if (i % 2 == 0) {
                b.append(TextFormatting.DARK_RED + arr[i].toString() + " ");
                continue;
            }
            b.append(TextFormatting.WHITE + arr[i].toString() + " ");
        }
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Regions: " + TextFormatting.RESET + b.toString()));
    }

    public static boolean isInRegion(String regionName, EntityPlayerMP player) {
        if (RegionSaver.getRegions().containsKey(regionName)) {
            return RegionSaver.getRegions().get(regionName).isInPlayerList((EntityPlayer)player);
        }
        return false;
    }

    public static void redefineRegion(String regionName, EntityPlayerMP player, ItemStack item) {
        if (item.func_77973_b() instanceof RegionWand) {
            if (item.func_77942_o() && item.func_77978_p().func_74767_n("valide")) {
                AxisRegions axisRegions = new AxisRegions(item.func_77978_p().func_74762_e("x1"), item.func_77978_p().func_74762_e("y1"), item.func_77978_p().func_74762_e("z1"), item.func_77978_p().func_74762_e("x2"), item.func_77978_p().func_74762_e("y2"), item.func_77978_p().func_74762_e("z2")).expandXyz(1);
                Regions region = new Regions(regionName, axisRegions, player.field_70170_p.field_73011_w.getDimension(), false);
                if (RegionSaver.getRegions().containsKey(regionName)) {
                    Regions oldRegion = RegionSaver.getRegions().get(regionName);
                    for (String st : oldRegion.getFlags()) {
                        region.addFlag(st);
                    }
                    RegionSaver.getRegions().remove(regionName);
                    RegionSaver.addRegion(region);
                    RegionSaver.save();
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.redefine", new Object[]{regionName}));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.unknown", new Object[]{regionName}));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.itemhand.choose", new Object[0]));
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.itemhand.take", new Object[0]));
        }
    }

    public static void removePlayer(String regions, EntityPlayerMP player, String name) {
        if (RegionSaver.getRegions().containsKey(regions)) {
            Regions region = RegionSaver.getRegions().get(regions);
            if (region.getPlayerList().contains(name)) {
                region.getPlayerList().remove(name);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.removeplayer", new Object[]{name, regions}));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.missingplayer", new Object[0]));
            }
            RegionSaver.save();
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.unknown", new Object[]{regions}));
        }
    }

    public static void sendHelpMessage(EntityPlayerMP player) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation(" ", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GOLD + "=====[ " + TextFormatting.WHITE + TextFormatting.BOLD + "World Defender Help" + TextFormatting.GOLD + " ]=====", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("help.1", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("help.2", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("help.3", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation(" ", new Object[0]));
    }

    public static void sendRegionHelpMessage(EntityPlayerMP player) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation(" ", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GOLD + "=====[ " + TextFormatting.WHITE + TextFormatting.BOLD + "WD Region Help" + TextFormatting.GOLD + " ]=====", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("help.region.1", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("help.region.2", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("help.region.3", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("help.region.4", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("help.region.5", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("help.region.6", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("help.region.7", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("help.region.8", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("help.region.9", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation(" ", new Object[0]));
    }

    public static void setPriorityRegion(String regionName, int priority, EntityPlayerMP player) {
        if (RegionSaver.getRegions().containsKey(regionName)) {
            Regions region = RegionSaver.getRegions().get(regionName);
            if (priority >= 1) {
                region.setPriority(priority);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.setpriority", new Object[]{priority, regionName}));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.priority", new Object[0]));
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.unknown", new Object[]{regionName}));
        }
    }

    public static void teleportToRegion(String regions, EntityPlayerMP player) {
        if (RegionSaver.getRegions().containsKey(regions)) {
            Regions region = RegionSaver.getRegions().get(regions);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.teleport", new Object[]{regions}));
            player.func_70634_a((double)region.getArea().minX, 255.0, (double)region.getArea().minZ);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.region.unknown", new Object[]{regions}));
        }
    }
}

