/*
 * Decompiled with CFR 0.152.
 */
package com.edek.dg.worlddefender.main;

import com.edek.dg.worlddefender.main.AxisRegions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.util.INBTSerializable;

public class Regions
implements INBTSerializable<NBTTagCompound> {
    AxisRegions area;
    String regionName;
    int dim;
    int regionPriority = 0;
    boolean isGlobal;
    Set<String> flags = new HashSet<String>();
    private List<String> playerList = new ArrayList<String>();

    public Regions() {
    }

    public Regions(String name, AxisRegions area, int dimension, boolean isGlobal) {
        this.regionName = name;
        this.area = area;
        this.dim = dimension;
        this.isGlobal = isGlobal;
    }

    public void addFlag(String flag) {
        this.flags.add(flag);
    }

    public void addPlayer(String name) {
        this.playerList.add(name);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.regionName = nbt.func_74779_i("name");
        this.area = new AxisRegions(nbt.func_74762_e("minX"), nbt.func_74762_e("minY"), nbt.func_74762_e("minZ"), nbt.func_74762_e("maxX"), nbt.func_74762_e("maxY"), nbt.func_74762_e("maxZ"));
        this.regionPriority = nbt.func_74762_e("priority");
        this.dim = nbt.func_74762_e("dimension");
        this.isGlobal = nbt.func_74767_n("isGlobal");
        NBTTagList flagsList = nbt.func_150295_c("flags", 8);
        for (int i = 0; i < flagsList.func_74745_c(); ++i) {
            this.flags.add(flagsList.func_150307_f(i));
        }
        NBTTagList playerLists = nbt.func_150295_c("playerList", 8);
        for (int i = 0; i < playerLists.func_74745_c(); ++i) {
            this.playerList.add(playerLists.func_150307_f(i));
        }
    }

    public AxisRegions getArea() {
        return this.area;
    }

    public int getDimension() {
        return this.dim;
    }

    public Set<String> getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.regionName;
    }

    public List<String> getPlayerList() {
        return this.playerList;
    }

    public int getPriority() {
        return this.regionPriority;
    }

    public boolean getIsGlobal() {
        return this.isGlobal;
    }

    public boolean isInPlayerList(EntityPlayer name) {
        if (name.func_70003_b(4, "wdf")) {
            return true;
        }
        return this.playerList.contains(name.func_70005_c_().toString());
    }

    public boolean removeFlag(String flag) {
        return this.flags.remove(flag);
    }

    public void removePlayer(String name) {
        this.playerList.remove(name);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", this.regionName);
        nbt.func_74768_a("minX", this.area.minX);
        nbt.func_74768_a("minY", this.area.minY);
        nbt.func_74768_a("minZ", this.area.minZ);
        nbt.func_74768_a("maxX", this.area.maxX);
        nbt.func_74768_a("maxY", this.area.maxY);
        nbt.func_74768_a("maxZ", this.area.maxZ);
        nbt.func_74768_a("priority", this.regionPriority);
        nbt.func_74768_a("dimension", this.dim);
        nbt.func_74757_a("isGlobal", this.isGlobal);
        NBTTagList flagList = new NBTTagList();
        for (String flag : this.flags) {
            flagList.func_74742_a((NBTBase)new NBTTagString(flag));
        }
        nbt.func_74782_a("flags", (NBTBase)flagList);
        NBTTagList playerLists = new NBTTagList();
        for (String player : this.playerList) {
            playerLists.func_74742_a((NBTBase)new NBTTagString(player));
        }
        nbt.func_74782_a("playerList", (NBTBase)playerLists);
        return nbt;
    }

    public void setArea(AxisRegions area) {
        this.area = area;
    }

    public void setName(String name) {
        this.regionName = name;
    }

    public void setPlayerList(List<String> playerList) {
        this.playerList = playerList;
    }

    public void setPriority(int priority) {
        this.regionPriority = priority;
    }
}

