/*
 * Decompiled with CFR 0.152.
 */
package com.edek.dg.worlddefender.main;

import com.edek.dg.worlddefender.WorldDefender;
import com.edek.dg.worlddefender.main.Regions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

public class RegionSaver
extends WorldSavedData {
    private static RegionSaver INSTANCE;
    static final Map<String, Regions> regions;

    public static void addRegion(Regions region) {
        if (!regions.containsKey(region.getName())) {
            regions.put(region.getName(), region);
        }
    }

    public static Map<String, Regions> getRegions() {
        return regions;
    }

    public static void onServerStarting(FMLServerStartingEvent event) {
        if (!event.getServer().func_130014_f_().field_72995_K) {
            WorldDefender.log.info("Loading regions data...");
            MapStorage storage = event.getServer().func_130014_f_().func_175693_T();
            RegionSaver data = (RegionSaver)storage.func_75742_a(RegionSaver.class, "worlddefender");
            if (data == null) {
                data = new RegionSaver("worlddefender");
                storage.func_75745_a("worlddefender", (WorldSavedData)data);
            }
            INSTANCE = data;
        }
    }

    public static void save() {
        if (INSTANCE != null) {
            INSTANCE.func_76185_a();
        }
    }

    public RegionSaver(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        regions.clear();
        NBTTagList regionsList = nbt.func_150295_c("wdf-regions", 10);
        for (int i = 0; i < regionsList.func_74745_c(); ++i) {
            Regions area = new Regions();
            area.deserializeNBT(regionsList.func_150305_b(i));
            regions.put(area.getName(), area);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList regionsList = new NBTTagList();
        for (Regions area : regions.values()) {
            regionsList.func_74742_a((NBTBase)area.serializeNBT());
        }
        compound.func_74782_a("wdf-regions", (NBTBase)regionsList);
        return compound;
    }

    static {
        regions = new HashMap<String, Regions>();
    }
}

