/*
 * Decompiled with CFR 0.152.
 */
package com.edek.dg.worlddefender.main;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AxisRegions {
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public AxisRegions(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    public AxisRegions(BlockPos pos1, BlockPos pos2) {
        this(pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
    }

    public AxisRegions(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisRegions(Vec3d min, Vec3d max) {
        this((int)min.field_72450_a, (int)min.field_72448_b, (int)min.field_72449_c, (int)max.field_72450_a, (int)max.field_72448_b, (int)max.field_72449_c);
    }

    public AxisRegions addCoord(int x, int y, int z) {
        int d0 = this.minX;
        int d1 = this.minY;
        int d2 = this.minZ;
        int d3 = this.maxX;
        int d4 = this.maxY;
        int d5 = this.maxZ;
        if ((double)x < 0.0) {
            d0 += x;
        } else if ((double)x > 0.0) {
            d3 += x;
        }
        if ((double)y < 0.0) {
            d1 += y;
        } else if ((double)y > 0.0) {
            d4 += y;
        }
        if ((double)z < 0.0) {
            d2 += z;
        } else if ((double)z > 0.0) {
            d5 += z;
        }
        return new AxisRegions(d0, d1, d2, d3, d4, d5);
    }

    @Nullable
    public RayTraceResult calculateIntercept(Vec3d vecA, Vec3d vecB) {
        Vec3d vec3d = this.collideWithXPlane(this.minX, vecA, vecB);
        EnumFacing enumfacing = EnumFacing.WEST;
        Vec3d vec3d1 = this.collideWithXPlane(this.maxX, vecA, vecB);
        if (vec3d1 != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.EAST;
        }
        if ((vec3d1 = this.collideWithYPlane(this.minY, vecA, vecB)) != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.DOWN;
        }
        if ((vec3d1 = this.collideWithYPlane(this.maxY, vecA, vecB)) != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.UP;
        }
        if ((vec3d1 = this.collideWithZPlane(this.minZ, vecA, vecB)) != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.NORTH;
        }
        if ((vec3d1 = this.collideWithZPlane(this.maxZ, vecA, vecB)) != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.SOUTH;
        }
        return vec3d == null ? null : new RayTraceResult(vec3d, enumfacing);
    }

    public int calculateXOffset(AxisRegions other, int offsetX) {
        if (other.maxY > this.minY && other.minY < this.maxY && other.maxZ > this.minZ && other.minZ < this.maxZ) {
            int d0;
            if ((double)offsetX > 0.0 && other.maxX <= this.minX) {
                int d1 = this.minX - other.maxX;
                if (d1 < offsetX) {
                    offsetX = d1;
                }
            } else if ((double)offsetX < 0.0 && other.minX >= this.maxX && (d0 = this.maxX - other.minX) > offsetX) {
                offsetX = d0;
            }
            return offsetX;
        }
        return offsetX;
    }

    public int calculateYOffset(AxisRegions other, int offsetY) {
        if (other.maxX > this.minX && other.minX < this.maxX && other.maxZ > this.minZ && other.minZ < this.maxZ) {
            int d0;
            if ((double)offsetY > 0.0 && other.maxY <= this.minY) {
                int d1 = this.minY - other.maxY;
                if (d1 < offsetY) {
                    offsetY = d1;
                }
            } else if ((double)offsetY < 0.0 && other.minY >= this.maxY && (d0 = this.maxY - other.minY) > offsetY) {
                offsetY = d0;
            }
            return offsetY;
        }
        return offsetY;
    }

    public int calculateZOffset(AxisRegions other, int offsetZ) {
        if (other.maxX > this.minX && other.minX < this.maxX && other.maxY > this.minY && other.minY < this.maxY) {
            int d0;
            if ((double)offsetZ > 0.0 && other.maxZ <= this.minZ) {
                int d1 = this.minZ - other.maxZ;
                if (d1 < offsetZ) {
                    offsetZ = d1;
                }
            } else if ((double)offsetZ < 0.0 && other.minZ >= this.maxZ && (d0 = this.maxZ - other.minZ) > offsetZ) {
                offsetZ = d0;
            }
            return offsetZ;
        }
        return offsetZ;
    }

    @Nullable
    @VisibleForTesting
    Vec3d collideWithXPlane(int p_186671_1_, Vec3d p_186671_3_, Vec3d p_186671_4_) {
        Vec3d vec3d = p_186671_3_.func_72429_b(p_186671_4_, (double)p_186671_1_);
        return vec3d != null && this.intersectsWithYZ(vec3d) ? vec3d : null;
    }

    @Nullable
    @VisibleForTesting
    Vec3d collideWithYPlane(int p_186663_1_, Vec3d p_186663_3_, Vec3d p_186663_4_) {
        Vec3d vec3d = p_186663_3_.func_72435_c(p_186663_4_, (double)p_186663_1_);
        return vec3d != null && this.intersectsWithXZ(vec3d) ? vec3d : null;
    }

    @Nullable
    @VisibleForTesting
    Vec3d collideWithZPlane(int p_186665_1_, Vec3d p_186665_3_, Vec3d p_186665_4_) {
        Vec3d vec3d = p_186665_3_.func_72434_d(p_186665_4_, (double)p_186665_1_);
        return vec3d != null && this.intersectsWithXY(vec3d) ? vec3d : null;
    }

    public AxisRegions contract(int value) {
        return this.expandXyz(-value);
    }

    public AxisRegions contract(int p_191195_1_, int p_191195_3_, int p_191195_5_) {
        int d0 = this.minX;
        int d1 = this.minY;
        int d2 = this.minZ;
        int d3 = this.maxX;
        int d4 = this.maxY;
        int d5 = this.maxZ;
        if ((double)p_191195_1_ < 0.0) {
            d0 -= p_191195_1_;
        } else if ((double)p_191195_1_ > 0.0) {
            d3 -= p_191195_1_;
        }
        if ((double)p_191195_3_ < 0.0) {
            d1 -= p_191195_3_;
        } else if ((double)p_191195_3_ > 0.0) {
            d4 -= p_191195_3_;
        }
        if ((double)p_191195_5_ < 0.0) {
            d2 -= p_191195_5_;
        } else if ((double)p_191195_5_ > 0.0) {
            d5 -= p_191195_5_;
        }
        return new AxisRegions(d0, d1, d2, d3, d4, d5);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof AxisRegions)) {
            return false;
        }
        AxisRegions axisregions = (AxisRegions)p_equals_1_;
        return Integer.compare(axisregions.minX, this.minX) != 0 ? false : (Integer.compare(axisregions.minY, this.minY) != 0 ? false : (Integer.compare(axisregions.minZ, this.minZ) != 0 ? false : (Integer.compare(axisregions.maxX, this.maxX) != 0 ? false : (Integer.compare(axisregions.maxY, this.maxY) != 0 ? false : Integer.compare(axisregions.maxZ, this.maxZ) == 0))));
    }

    public AxisRegions expand(int x, int y, int z) {
        int d0 = this.minX - x;
        int d1 = this.minY - y;
        int d2 = this.minZ - z;
        int d3 = this.maxX + x;
        int d4 = this.maxY + y;
        int d5 = this.maxZ + z;
        return new AxisRegions(d0, d1, d2, d3, d4, d5);
    }

    public AxisRegions expandXyz(int value) {
        return this.expand(value, value, value);
    }

    public int getAverageEdgeLength() {
        int d0 = this.maxX - this.minX;
        int d1 = this.maxY - this.minY;
        int d2 = this.maxZ - this.minZ;
        return (int)((double)(d0 + d1 + d2) / 3.0);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCenter() {
        return new Vec3d((double)this.minX + (double)(this.maxX - this.minX) * 0.5, (double)this.minY + (double)(this.maxY - this.minY) * 0.5, (double)this.minZ + (double)(this.maxZ - this.minZ) * 0.5);
    }

    public int hashCode() {
        long i = Integer.toUnsignedLong(this.minX);
        int j = (int)(i ^ i >>> 32);
        i = Integer.toUnsignedLong(this.minY);
        j = 31 * j + (int)(i ^ i >>> 32);
        i = Integer.toUnsignedLong(this.minZ);
        j = 31 * j + (int)(i ^ i >>> 32);
        i = Integer.toUnsignedLong(this.maxX);
        j = 31 * j + (int)(i ^ i >>> 32);
        i = Integer.toUnsignedLong(this.maxY);
        j = 31 * j + (int)(i ^ i >>> 32);
        i = Integer.toUnsignedLong(this.maxZ);
        j = 31 * j + (int)(i ^ i >>> 32);
        return j;
    }

    public AxisRegions intersect(AxisRegions p_191500_1_) {
        int d0 = Math.max(this.minX, p_191500_1_.minX);
        int d1 = Math.max(this.minY, p_191500_1_.minY);
        int d2 = Math.max(this.minZ, p_191500_1_.minZ);
        int d3 = Math.min(this.maxX, p_191500_1_.maxX);
        int d4 = Math.min(this.maxY, p_191500_1_.maxY);
        int d5 = Math.min(this.maxZ, p_191500_1_.maxZ);
        return new AxisRegions(d0, d1, d2, d3, d4, d5);
    }

    public boolean intersects(int x1, int y1, int z1, int x2, int y2, int z2) {
        return this.minX < x2 && this.maxX > x1 && this.minY < y2 && this.maxY > y1 && this.minZ < z2 && this.maxZ > z1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean intersects(Vec3d min, Vec3d max) {
        return this.intersects((int)Math.min(min.field_72450_a, max.field_72450_a), (int)Math.min(min.field_72448_b, max.field_72448_b), (int)Math.min(min.field_72449_c, max.field_72449_c), (int)Math.max(min.field_72450_a, max.field_72450_a), (int)Math.max(min.field_72448_b, max.field_72448_b), (int)Math.max(min.field_72449_c, max.field_72449_c));
    }

    public boolean intersectsWith(AxisRegions other) {
        return this.intersects(other.minX, other.minY, other.minZ, other.maxX, other.maxY, other.maxZ);
    }

    @VisibleForTesting
    public boolean intersectsWithXY(Vec3d vec) {
        return vec.field_72450_a >= (double)this.minX && vec.field_72450_a <= (double)this.maxX && vec.field_72448_b >= (double)this.minY && vec.field_72448_b <= (double)this.maxY;
    }

    @VisibleForTesting
    public boolean intersectsWithXZ(Vec3d vec) {
        return vec.field_72450_a >= (double)this.minX && vec.field_72450_a <= (double)this.maxX && vec.field_72449_c >= (double)this.minZ && vec.field_72449_c <= (double)this.maxZ;
    }

    @VisibleForTesting
    public boolean intersectsWithYZ(Vec3d vec) {
        return vec.field_72448_b >= (double)this.minY && vec.field_72448_b <= (double)this.maxY && vec.field_72449_c >= (double)this.minZ && vec.field_72449_c <= (double)this.maxZ;
    }

    @VisibleForTesting
    boolean isClosest(Vec3d p_186661_1_, @Nullable Vec3d p_186661_2_, Vec3d p_186661_3_) {
        return p_186661_2_ == null || p_186661_1_.func_72436_e(p_186661_3_) < p_186661_1_.func_72436_e(p_186661_2_);
    }

    public boolean isVecInside(Vec3d vec) {
        return vec.field_72450_a > (double)this.minX && vec.field_72450_a < (double)this.maxX ? (vec.field_72448_b > (double)this.minY && vec.field_72448_b < (double)this.maxY ? vec.field_72449_c > (double)this.minZ && vec.field_72449_c < (double)this.maxZ : false) : false;
    }

    public boolean isVecInside(Vec3d vec, double minTransform, double maxTransform) {
        return vec.field_72450_a > (double)this.minX + minTransform && vec.field_72450_a < (double)this.maxX + maxTransform ? (vec.field_72448_b > (double)this.minY + minTransform && vec.field_72448_b < (double)this.maxY + maxTransform ? vec.field_72449_c > (double)this.minZ + minTransform && vec.field_72449_c < (double)this.maxZ + maxTransform : false) : false;
    }

    public AxisRegions move(Vec3d p_191194_1_) {
        return this.offset((int)p_191194_1_.field_72450_a, (int)p_191194_1_.field_72448_b, (int)p_191194_1_.field_72449_c);
    }

    public AxisRegions offset(BlockPos pos) {
        return new AxisRegions(this.minX + pos.func_177958_n(), this.minY + pos.func_177956_o(), this.minZ + pos.func_177952_p(), this.maxX + pos.func_177958_n(), this.maxY + pos.func_177956_o(), this.maxZ + pos.func_177952_p());
    }

    public AxisRegions offset(int x, int y, int z) {
        return new AxisRegions(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public AxisRegions setMaxY(int y2) {
        return new AxisRegions(this.minX, this.minY, this.minZ, this.maxX, y2, this.maxZ);
    }

    public String toString() {
        return "box[" + this.minX + ", " + this.minY + ", " + this.minZ + " -> " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    public AxisRegions union(AxisRegions other) {
        int d0 = Math.min(this.minX, other.minX);
        int d1 = Math.min(this.minY, other.minY);
        int d2 = Math.min(this.minZ, other.minZ);
        int d3 = Math.max(this.maxX, other.maxX);
        int d4 = Math.max(this.maxY, other.maxY);
        int d5 = Math.max(this.maxZ, other.maxZ);
        return new AxisRegions(d0, d1, d2, d3, d4, d5);
    }
}

