/*
 * Decompiled with CFR 0.152.
 */
package com.edek.dg.worlddefender.events;

import com.edek.dg.worlddefender.main.Regions;
import com.edek.dg.worlddefender.utils.RegionsUtil;
import java.util.Iterator;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="worlddefender")
public class ProtectionEvent {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onExplosion(ExplosionEvent.Detonate event) {
        BlockPos pos;
        Iterator it = event.getAffectedBlocks().iterator();
        block0: while (it.hasNext()) {
            pos = (BlockPos)it.next();
            for (Regions region : RegionsUtil.getHandlingRegionsFor(pos, event.getWorld().field_73011_w.getDimension())) {
                if (!region.getFlags().contains("explosions")) continue;
                it.remove();
                continue block0;
            }
        }
        it = event.getAffectedBlocks().iterator();
        if (event.getExplosion().func_94613_c() instanceof EntityCreeper) {
            block2: while (it.hasNext()) {
                pos = (BlockPos)it.next();
                for (Regions region : RegionsUtil.getHandlingRegionsFor(pos, event.getWorld().field_73011_w.getDimension())) {
                    if (!region.getFlags().contains("creeper-explosions")) continue;
                    it.remove();
                    continue block2;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        for (Regions region : RegionsUtil.getHandlingRegionsFor(event.getPos(), event.getWorld().field_73011_w.getDimension())) {
            if (!region.getFlags().contains("break") || region.isInPlayerList(event.getPlayer())) continue;
            event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("world.protect", new Object[0]));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerPlaceBlock(BlockEvent.PlaceEvent event) {
        for (Regions region : RegionsUtil.getHandlingRegionsFor(event.getPos(), event.getWorld().field_73011_w.getDimension())) {
            if (!region.getFlags().contains("place") || region.isInPlayerList(event.getPlayer())) continue;
            event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("world.protect", new Object[0]));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTileentityBreak(AttackEntityEvent event) {
        if (!event.getTarget().field_70170_p.field_72995_K) {
            for (Regions region : RegionsUtil.getHandlingRegionsFor(event.getTarget().func_180425_c(), event.getTarget().field_71093_bK)) {
                if (!region.getFlags().contains("break") || region.isInPlayerList(event.getEntityPlayer()) || !(event.getTarget() instanceof EntityHanging) && !(event.getTarget() instanceof EntityArmorStand)) continue;
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("world.protect", new Object[0]));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void farmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        for (Regions region : RegionsUtil.getHandlingRegionsFor(event.getPos(), event.getWorld().field_73011_w.getDimension())) {
            if (!region.getFlags().contains("farmland-trample")) continue;
            event.setCanceled(true);
        }
    }
}

