/*
 * Decompiled with CFR 0.152.
 */
package com.edek.dg.worlddefender.events;

import com.edek.dg.worlddefender.main.RegionSaver;
import com.edek.dg.worlddefender.main.Regions;
import com.edek.dg.worlddefender.utils.RegionsUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="worlddefender")
public class PlayersEvent {
    static Map<EntityPlayer, BlockPos> oldPosInside = new HashMap<EntityPlayer, BlockPos>();
    static Map<EntityPlayer, BlockPos> oldPosOutside = new HashMap<EntityPlayer, BlockPos>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttackEntity(AttackEntityEvent event) {
        if (event.getTarget() instanceof EntityPlayerMP) {
            for (Regions region : RegionsUtil.getHandlingRegionsFor(event.getTarget().func_180425_c(), event.getTarget().field_70170_p.field_73011_w.getDimension())) {
                if (!region.getFlags().contains("pvp")) continue;
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("world.protect", new Object[0]));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onChatSend(ServerChatEvent event) {
        if (event.getPlayer() instanceof EntityPlayerMP) {
            for (Regions region : RegionsUtil.getHandlingRegionsFor(event.getPlayer().func_180425_c(), event.getPlayer().field_70170_p.field_73011_w.getDimension())) {
                if (!region.getFlags().contains("chatting") || region.isInPlayerList((EntityPlayer)event.getPlayer())) continue;
                event.setCanceled(true);
                event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("world.speak", new Object[0]));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            for (Regions region : RegionsUtil.getHandlingRegionsFor(event.getEntityLiving().func_180425_c(), event.getEntityLiving().field_70170_p.field_73011_w.getDimension())) {
                if (!region.getFlags().contains("fall-damage")) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            for (Regions region : RegionsUtil.getHandlingRegionsFor(event.getEntityLiving().func_180425_c(), event.getEntityLiving().field_70170_p.field_73011_w.getDimension())) {
                if (!region.getFlags().contains("invincible")) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerDropItem(ItemTossEvent event) {
        for (Regions region : RegionsUtil.getHandlingRegionsFor(event.getPlayer().func_180425_c(), event.getPlayer().field_70170_p.field_73011_w.getDimension())) {
            if (!region.getFlags().contains("item-drop") || region.isInPlayerList(event.getPlayer())) continue;
            event.setCanceled(true);
            event.getPlayer().field_71071_by.func_70441_a(event.getEntityItem().func_92059_d());
            event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("world.protect", new Object[0]));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerEnterRegion(TickEvent.PlayerTickEvent event) {
        int dim = event.player.field_70170_p.field_73011_w.getDimension();
        BlockPos playerPos = event.player.func_180425_c();
        if (event.phase == TickEvent.Phase.END) {
            for (Regions region : RegionSaver.getRegions().values()) {
                if (region.getArea().isVecInside(new Vec3d((Vec3i)event.player.func_180425_c())) || region.getDimension() != dim || !region.getFlags().contains("block-enter") || region.isInPlayerList(event.player)) continue;
                oldPosOutside.put(event.player, event.player.func_180425_c());
            }
            for (Regions region : RegionsUtil.getHandlingRegionsFor(playerPos, dim)) {
                if (!region.getFlags().contains("block-enter") || region.isInPlayerList(event.player)) continue;
                double x = oldPosOutside.get(event.player).func_177958_n();
                double y = oldPosOutside.get(event.player).func_177956_o();
                double z = oldPosOutside.get(event.player).func_177952_p();
                BlockPos[] pos = new BlockPos[]{new BlockPos(x, y, z), new BlockPos(x + 1.0, y, z), new BlockPos(x - 1.0, y, z), new BlockPos(x, y, z + 1.0), new BlockPos(x, y, z - 1.0), new BlockPos(x - 1.0, y, z + 1.0), new BlockPos(x + 1.0, y, z - 1.0), new BlockPos(x + 1.0, y, z + 1.0), new BlockPos(x - 1.0, y, z - 1.0)};
                for (int i = 0; i < pos.length; ++i) {
                    if (region.getArea().isVecInside(new Vec3d((Vec3i)pos[i]))) continue;
                    event.player.func_70634_a((double)pos[i].func_177958_n() + 0.5, (double)pos[i].func_177956_o(), (double)pos[i].func_177952_p() + 0.5);
                    event.player.func_145747_a((ITextComponent)new TextComponentTranslation("world.enter", new Object[0]));
                    return;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerLeaveRegion(TickEvent.PlayerTickEvent event) {
        int dim = event.player.field_70170_p.field_73011_w.getDimension();
        BlockPos playerPos = event.player.func_180425_c();
        if (event.phase == TickEvent.Phase.END) {
            for (Regions region : RegionsUtil.getHandlingRegionsFor(playerPos, dim)) {
                if (!region.getFlags().contains("block-exit") || region.isInPlayerList(event.player)) continue;
                oldPosInside.put(event.player, event.player.func_180425_c());
                if (region.getArea().isVecInside(new Vec3d((Vec3i)event.player.func_180425_c()), 1.0, -1.0)) continue;
                double x = oldPosInside.get(event.player).func_177958_n();
                double y = oldPosInside.get(event.player).func_177956_o();
                double z = oldPosInside.get(event.player).func_177952_p();
                BlockPos[] pos = new BlockPos[]{new BlockPos(x, y, z), new BlockPos(x + 2.0, y, z), new BlockPos(x - 2.0, y, z), new BlockPos(x, y, z + 2.0), new BlockPos(x, y, z - 2.0), new BlockPos(x - 2.0, y, z + 2.0), new BlockPos(x + 2.0, y, z - 2.0), new BlockPos(x + 2.0, y, z + 2.0), new BlockPos(x - 2.0, y, z - 2.0)};
                for (int i = 0; i < pos.length; ++i) {
                    if (!region.getArea().isVecInside(new Vec3d((Vec3i)pos[i]), 1.0, -1.0)) continue;
                    event.player.func_70634_a((double)pos[i].func_177958_n() + 0.5, (double)pos[i].func_177956_o(), (double)pos[i].func_177952_p() + 0.5);
                    event.player.func_145747_a((ITextComponent)new TextComponentTranslation("world.leave", new Object[0]));
                    return;
                }
            }
        }
    }
}

