/*
 * Decompiled with CFR 0.152.
 */
package com.edek.dg.worlddefender;

import com.edek.dg.worlddefender.commands.MainCommand;
import com.edek.dg.worlddefender.events.PlayersEvent;
import com.edek.dg.worlddefender.main.RegionSaver;
import com.edek.dg.worlddefender.proxy.ServerProxy;
import com.edek.dg.worlddefender.registers.ItemRegister;
import com.edek.dg.worlddefender.utils.RegionsUtil;
import net.minecraft.command.ICommand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="worlddefender", version="1.2.0")
public class WorldDefender {
    public static final String MODID = "worlddefender";
    public static final String NAME = "World Defender";
    public static final String VERSION = "1.2.0";
    public static final Logger log = LogManager.getLogger((String)"worlddefender".toUpperCase());
    @SidedProxy(clientSide="com.edek.dg.worlddefender.proxy.ClientProxy", serverSide="com.edek.dg.worlddefender.proxy.ServerProxy")
    public static ServerProxy proxy;
    @Mod.Instance(value="worlddefender")
    public static WorldDefender INSTANCE;

    @Mod.EventHandler
    void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    void preInit(FMLPreInitializationEvent event) {
        log.info(TextFormatting.GRAY + "Loading " + TextFormatting.DARK_GRAY + NAME + TextFormatting.YELLOW + " v" + VERSION + TextFormatting.GRAY + " by " + TextFormatting.RED + "EdeK_" + TextFormatting.RESET);
        log.info(TextFormatting.DARK_BLUE + "Discord Server: " + TextFormatting.BLUE + "https://discord.gg/tWuVFHC" + TextFormatting.RESET);
        ItemRegister.register();
        proxy.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)new PlayersEvent());
    }

    @Mod.EventHandler
    void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        log.info(TextFormatting.DARK_GRAY + NAME + TextFormatting.GRAY + " loaded " + TextFormatting.DARK_GREEN + "successfully" + TextFormatting.GRAY + "!");
    }

    @Mod.EventHandler
    void serverInit(FMLServerStartingEvent event) {
        proxy.serverStarting(event);
        RegionSaver.onServerStarting(event);
        event.registerServerCommand((ICommand)new MainCommand());
        for (DimensionType dim : DimensionManager.getRegisteredDimensions().keySet()) {
            log.debug("Test: {}", (Object)dim);
            RegionsUtil.createGlobalRegion("global_" + dim.func_186065_b(), dim.func_186068_a());
        }
    }
}

