/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.api.events.ClientVoicechatConnectionEvent;
import de.maxhenkel.voicechat.api.events.MicrophoneMuteEvent;
import de.maxhenkel.voicechat.api.events.VoicechatDisableEvent;
import de.maxhenkel.voicechat.gui.CreateGroupScreen;
import de.maxhenkel.voicechat.gui.EnterPasswordScreen;
import de.maxhenkel.voicechat.gui.group.GroupList;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupList;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.onboarding.OnboardingManager;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeList;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.ClientServerNetManager;
import de.maxhenkel.voicechat.net.UpdateStatePacket;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.plugins.impl.events.ClientVoicechatConnectionEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.MicrophoneMuteEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.VoicechatDisableEventImpl;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ClientPlayerStateManager {
    private boolean disconnected = true;
    @Nullable
    private UUID group = null;
    private Map<UUID, PlayerState> states = new HashMap<UUID, PlayerState>();

    public ClientPlayerStateManager() {
        ClientServerNetManager.setClientListener(CommonCompatibilityManager.INSTANCE.getNetManager().playerStateChannel, (client, handler, packet) -> {
            ClientVoicechat c;
            this.states.put(packet.getPlayerState().getUuid(), packet.getPlayerState());
            Voicechat.LOGGER.debug("Got state for {}: {}", packet.getPlayerState().getName(), packet.getPlayerState());
            VoicechatClient.USERNAME_CACHE.updateUsernameAndSave(packet.getPlayerState().getUuid(), packet.getPlayerState().getName());
            if (packet.getPlayerState().isDisconnected() && (c = ClientManager.getClient()) != null) {
                c.closeAudioChannel(packet.getPlayerState().getUuid());
            }
            AdjustVolumeList.update();
            JoinGroupList.update();
            GroupList.update();
        });
        ClientServerNetManager.setClientListener(CommonCompatibilityManager.INSTANCE.getNetManager().playerStatesChannel, (client, handler, packet) -> {
            this.states = packet.getPlayerStates().stream().collect(Collectors.toMap(PlayerState::getUuid, p -> p));
            Voicechat.LOGGER.debug("Received {} state(s)", this.states.size());
            for (PlayerState state : this.states.values()) {
                VoicechatClient.USERNAME_CACHE.updateUsername(state.getUuid(), state.getName());
            }
            VoicechatClient.USERNAME_CACHE.save();
            AdjustVolumeList.update();
            JoinGroupList.update();
            GroupList.update();
        });
        ClientServerNetManager.setClientListener(CommonCompatibilityManager.INSTANCE.getNetManager().removePlayerStateChannel, (client, handler, packet) -> {
            this.states.remove(packet.getId());
            Voicechat.LOGGER.debug("Removed state {}", packet.getId());
            AdjustVolumeList.update();
            JoinGroupList.update();
            GroupList.update();
        });
        ClientServerNetManager.setClientListener(CommonCompatibilityManager.INSTANCE.getNetManager().joinedGroupChannel, (client, handler, packet) -> {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            this.group = packet.getGroup();
            if (packet.isWrongPassword()) {
                if (screen instanceof JoinGroupScreen || screen instanceof CreateGroupScreen || screen instanceof EnterPasswordScreen) {
                    Minecraft.func_71410_x().func_147108_a(null);
                }
                client.field_71439_g.func_146105_b(new TextComponentTranslation("message.voicechat.wrong_password", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)), true);
            } else if (this.group != null && screen instanceof JoinGroupScreen || screen instanceof CreateGroupScreen || screen instanceof EnterPasswordScreen) {
                ClientGroup clientGroup = this.getGroup();
                if (clientGroup != null) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GroupScreen(clientGroup));
                } else {
                    Voicechat.LOGGER.warn("Received join group packet without group being present", new Object[0]);
                }
            }
            GroupList.update();
        });
        ClientCompatibilityManager.INSTANCE.onVoiceChatConnected(this::onVoiceChatConnected);
        ClientCompatibilityManager.INSTANCE.onVoiceChatDisconnected(this::onVoiceChatDisconnected);
        ClientCompatibilityManager.INSTANCE.onDisconnect(this::onDisconnect);
    }

    private void resetOwnState() {
        this.disconnected = true;
        this.group = null;
    }

    public void onVoiceChatDisconnected() {
        this.disconnected = true;
        this.syncOwnState();
        PluginManager.instance().dispatchEvent(ClientVoicechatConnectionEvent.class, new ClientVoicechatConnectionEventImpl(false));
    }

    public void onVoiceChatConnected(ClientVoicechatConnection client) {
        this.disconnected = false;
        this.syncOwnState();
        PluginManager.instance().dispatchEvent(ClientVoicechatConnectionEvent.class, new ClientVoicechatConnectionEventImpl(true));
    }

    private void onDisconnect() {
        this.clearStates();
        this.resetOwnState();
    }

    public boolean isPlayerDisabled(EntityPlayer player) {
        return this.isPlayerDisabled(player.func_110124_au());
    }

    public boolean isPlayerDisabled(UUID entityId) {
        PlayerState playerState = this.states.get(entityId);
        if (playerState == null) {
            return false;
        }
        return playerState.isDisabled();
    }

    public boolean isPlayerDisconnected(EntityPlayer player) {
        return this.isPlayerDisconnected(player.func_110124_au());
    }

    public boolean isPlayerDisconnected(UUID entityId) {
        PlayerState playerState = this.states.get(entityId);
        if (playerState == null) {
            return VoicechatClient.CLIENT_CONFIG.showFakePlayersDisconnected.get();
        }
        return playerState.isDisconnected();
    }

    public void syncOwnState() {
        ClientServerNetManager.sendToServer(new UpdateStatePacket(this.isDisabled()));
        Voicechat.LOGGER.debug("Sent own state to server: disabled={}", this.isDisabled());
    }

    public boolean isDisabled() {
        if (!this.canEnable()) {
            return true;
        }
        return VoicechatClient.CLIENT_CONFIG.disabled.get();
    }

    public boolean canEnable() {
        if (OnboardingManager.isOnboarding()) {
            return false;
        }
        ClientVoicechat client = ClientManager.getClient();
        return client != null;
    }

    public void setDisabled(boolean disabled) {
        VoicechatClient.CLIENT_CONFIG.disabled.set(disabled).save();
        this.syncOwnState();
        PluginManager.instance().dispatchEvent(VoicechatDisableEvent.class, new VoicechatDisableEventImpl(disabled));
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public boolean isMuted() {
        return VoicechatClient.CLIENT_CONFIG.muted.get();
    }

    public void setMuted(boolean muted) {
        VoicechatClient.CLIENT_CONFIG.muted.set(muted).save();
        PluginManager.instance().dispatchEvent(MicrophoneMuteEvent.class, new MicrophoneMuteEventImpl(muted));
    }

    public void onFinishOnboarding() {
        this.syncOwnState();
    }

    public boolean isInGroup(EntityPlayer player) {
        PlayerState state = this.states.get(player.func_110124_au());
        if (state == null) {
            return false;
        }
        return state.hasGroup();
    }

    @Nullable
    public UUID getGroup(EntityPlayer player) {
        PlayerState state = this.states.get(player.func_110124_au());
        if (state == null) {
            return null;
        }
        return state.getGroup();
    }

    @Nullable
    public ClientGroup getGroup() {
        if (this.group == null) {
            return null;
        }
        return ClientManager.getGroupManager().getGroup(this.group);
    }

    @Nullable
    public UUID getGroupID() {
        return this.group;
    }

    public List<PlayerState> getPlayerStates(boolean includeSelf) {
        if (includeSelf) {
            return new ArrayList<PlayerState>(this.states.values());
        }
        return this.states.values().stream().filter(playerState -> !playerState.getUuid().equals(this.getOwnID())).collect(Collectors.toList());
    }

    public UUID getOwnID() {
        ClientVoicechatConnection connection;
        ClientVoicechat client = ClientManager.getClient();
        if (client != null && (connection = client.getConnection()) != null) {
            return connection.getData().getPlayerUUID();
        }
        return Minecraft.func_71410_x().func_110432_I().func_148256_e().getId();
    }

    @Nullable
    public PlayerState getState(UUID player) {
        return this.states.get(player);
    }

    public void clearStates() {
        this.states.clear();
    }
}

