/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.plugins.impl.VoicechatServerApiImpl;
import de.maxhenkel.voicechat.service.Service;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public abstract class CommonCompatibilityManager {
    public static CommonCompatibilityManager INSTANCE = Service.get(CommonCompatibilityManager.class);

    public abstract String getModVersion();

    public abstract String getModName();

    public abstract Path getGameDirectory();

    public abstract void emitServerVoiceChatConnectedEvent(EntityPlayerMP var1);

    public abstract void emitServerVoiceChatDisconnectedEvent(UUID var1);

    public abstract void emitPlayerCompatibilityCheckSucceeded(EntityPlayerMP var1);

    public abstract void onServerVoiceChatConnected(Consumer<EntityPlayerMP> var1);

    public abstract void onServerVoiceChatDisconnected(Consumer<UUID> var1);

    public abstract void onServerStarting(Consumer<MinecraftServer> var1);

    public abstract void onServerStopping(Consumer<MinecraftServer> var1);

    public abstract void onPlayerLoggedIn(Consumer<EntityPlayerMP> var1);

    public abstract void onPlayerLoggedOut(Consumer<EntityPlayerMP> var1);

    public abstract void onPlayerHide(BiConsumer<EntityPlayerMP, EntityPlayerMP> var1);

    public abstract void onPlayerShow(BiConsumer<EntityPlayerMP, EntityPlayerMP> var1);

    public abstract void onPlayerCompatibilityCheckSucceeded(Consumer<EntityPlayerMP> var1);

    public abstract NetManager getNetManager();

    public abstract boolean isDevEnvironment();

    public abstract boolean isDedicatedServer();

    public abstract List<VoicechatPlugin> loadPlugins();

    public abstract PermissionManager createPermissionManager();

    public VoicechatServerApi getServerApi() {
        return VoicechatServerApiImpl.INSTANCE;
    }

    public Object createRawApiEntity(Entity entity) {
        return entity;
    }

    public Object createRawApiPlayer(EntityPlayer player) {
        return player;
    }

    public Object createRawApiLevel(WorldServer level) {
        return level;
    }

    public abstract boolean canSee(EntityPlayerMP var1, EntityPlayerMP var2);

    public void execute(MinecraftServer server, Runnable runnable) {
        server.func_152344_a(runnable);
    }
}

