/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class MicAmplificationSlider
extends DebouncedSlider {
    public static final int GAIN_WARNING_THRESHOLD = 10;
    private static final ITextComponent GAIN_WARNING = new TextComponentTranslation("message.voicechat.microphone_gain.warning", new Object[]{10}).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    private final GuiScreen parent;

    public MicAmplificationSlider(int id, GuiScreen parent, int xIn, int yIn, int widthIn, int heightIn) {
        super(id, xIn, yIn, widthIn, heightIn, MicAmplificationSlider.gainToValue(VoicechatClient.CLIENT_CONFIG.microphoneGain.get()));
        this.parent = parent;
        this.updateMessage();
    }

    @Override
    protected void updateMessage() {
        long gain = Math.round(MicAmplificationSlider.valueToGain(this.value));
        TextComponentTranslation message = new TextComponentTranslation("message.voicechat.microphone_gain", new Object[]{gain});
        if (gain > 10L && this.field_146124_l) {
            message.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        }
        this.field_146126_j = message.func_150254_d();
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY, float delta) {
        super.renderTooltips(mouseX, mouseY, delta);
        if (!this.func_146115_a()) {
            return;
        }
        long gain = Math.round(MicAmplificationSlider.valueToGain(this.value));
        if (gain > 10L && this.field_146124_l) {
            this.parent.func_146283_a(Minecraft.func_71410_x().field_71466_p.func_78271_c(GAIN_WARNING.func_150254_d(), 200), mouseX, mouseY);
        }
    }

    public void setActive(boolean active) {
        this.field_146124_l = active;
        this.updateMessage();
    }

    @Override
    public void applyDebounced() {
        VoicechatClient.CLIENT_CONFIG.microphoneGain.set(MicAmplificationSlider.valueToGain(this.value)).save();
    }

    private static double gainToValue(double gain) {
        return (gain - -40.0) / 64.0;
    }

    private static double valueToGain(double value) {
        return value * 64.0 + -40.0;
    }
}

