/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.ScreenBase;
import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceEntry;
import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceList;
import de.maxhenkel.voicechat.gui.audiodevice.MicrophoneAudioDeviceEntry;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.voice.client.microphone.MicrophoneManager;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class MicrophoneAudioDeviceList
extends AudioDeviceList {
    public static final ResourceLocation MICROPHONE_ICON = new ResourceLocation("voicechat", "textures/icons/microphone.png");
    public static final ITextComponent DEFAULT_MICROPHONE = new TextComponentTranslation("message.voicechat.default_microphone", new Object[0]);
    private final MicTestButton micTestButton;

    public MicrophoneAudioDeviceList(ScreenBase screen, int width, int height, int top) {
        super(width, height, top);
        this.defaultDeviceText = DEFAULT_MICROPHONE;
        this.icon = MICROPHONE_ICON;
        this.configEntry = VoicechatClient.CLIENT_CONFIG.microphone;
        this.micTestButton = new MicTestButton(10000, 0, 0, true);
        this.setAudioDevices(MicrophoneManager.deviceNames());
    }

    @Override
    public void func_148128_a(int mouseXIn, int mouseYIn, float partialTicks) {
        super.func_148128_a(mouseXIn, mouseYIn, partialTicks);
        this.micTestButton.updateLastRender();
    }

    @Override
    public AudioDeviceEntry createAudioDeviceEntry(String device, ITextComponent name, @Nullable ResourceLocation icon, Supplier<Boolean> isSelected) {
        return new MicrophoneAudioDeviceEntry(device, name, icon, isSelected, this.micTestButton);
    }
}

