/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.packet.PacketFullCapabilityData;
import com.supermartijn642.core.network.BasePacket;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class ChunkLoadingEventHandler {
    @SubscribeEvent
    public static void onPlayerEnterLevel(PlayerEvent.PlayerChangedDimensionEvent e) {
        if (!(e.player instanceof EntityPlayerMP)) {
            return;
        }
        ChunkLoadingCapability capability = ChunkLoadingCapability.get(e.player.func_130014_f_());
        ChunkLoaders.CHANNEL.sendToPlayer(e.player, (BasePacket)new PacketFullCapabilityData(capability.castServer().writeClientInfo()));
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (!(e.player instanceof EntityPlayerMP)) {
            return;
        }
        ChunkLoadingCapability capability = ChunkLoadingCapability.get(e.player.func_130014_f_());
        ChunkLoaders.CHANNEL.sendToPlayer(e.player, (BasePacket)new PacketFullCapabilityData(capability.castServer().writeClientInfo()));
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent e) {
        if (!(e.player instanceof EntityPlayerMP)) {
            return;
        }
        ChunkLoadingCapability capability = ChunkLoadingCapability.get(e.player.func_130014_f_());
        ChunkLoaders.CHANNEL.sendToPlayer(e.player, (BasePacket)new PacketFullCapabilityData(capability.castServer().writeClientInfo()));
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END || !(e.world instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)e.world;
        int tickSpeed = world.func_82736_K().func_180263_c("randomTickSpeed");
        if (tickSpeed > 0) {
            block0: for (ChunkPos pos : ChunkLoadingCapability.get((World)world).castServer().getChunksToBeTicked()) {
                for (int i = 0; i < world.field_73010_i.size(); ++i) {
                    EntityPlayerMP player = (EntityPlayerMP)world.field_73010_i.get(i);
                    if (player != null && !player.func_175149_v() && pos.func_185327_a((Entity)player) < 16384.0) continue block0;
                }
                ChunkLoadingEventHandler.tickEnvironment(world, pos, tickSpeed);
            }
        }
    }

    private static void tickEnvironment(WorldServer world, ChunkPos pos, int tickSpeed) {
        Chunk chunk = world.func_72964_e(pos.field_77276_a, pos.field_77275_b);
        int j = chunk.field_76635_g * 16;
        int k = chunk.field_76647_h * 16;
        for (ExtendedBlockStorage extendedblockstorage : chunk.func_76587_i()) {
            if (extendedblockstorage == Chunk.field_186036_a || !extendedblockstorage.func_76675_b()) continue;
            for (int i1 = 0; i1 < tickSpeed; ++i1) {
                int z;
                int y;
                int x = world.field_73012_v.nextInt(16);
                IBlockState iblockstate = extendedblockstorage.func_177485_a(x, y = world.field_73012_v.nextInt(16), z = world.field_73012_v.nextInt(16));
                Block block = iblockstate.func_177230_c();
                if (!block.func_149653_t()) continue;
                block.func_180645_a((World)world, new BlockPos(j + x, extendedblockstorage.func_76662_d() + y, k + z), iblockstate, world.field_73012_v);
            }
        }
    }
}

