/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderBlock;
import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistrationHandler;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;

public enum ChunkLoaderType {
    SINGLE(0, ChunkLoaderBlock.SINGLE_SHAPE, ChunkLoadersConfig.singleChunkLoaderRadius, false, "Single Chunk Loader"),
    BASIC(1, ChunkLoaderBlock.BASIC_SHAPE, ChunkLoadersConfig.basicChunkLoaderRadius, false, "Basic Chunk Loader"),
    ADVANCED(2, ChunkLoaderBlock.ADVANCED_SHAPE, ChunkLoadersConfig.advancedChunkLoaderRadius, true, "Advanced Chunk Loader"),
    ULTIMATE(3, ChunkLoaderBlock.ULTIMATE_SHAPE, ChunkLoadersConfig.ultimateChunkLoaderRadius, true, "Ultimate Chunk Loader");

    private final int index;
    private final String registryName;
    private final BlockShape shape;
    private final Supplier<Integer> range;
    private final boolean fullRotation;
    private final String englishTranslation;
    private BaseBlockEntityType<ChunkLoaderBlockEntity> blockEntityType;
    private ChunkLoaderBlock block;
    private BaseBlockItem item;

    public static ChunkLoaderType byIndex(int index) {
        for (ChunkLoaderType type : ChunkLoaderType.values()) {
            if (type.index != index) continue;
            return type;
        }
        return null;
    }

    private ChunkLoaderType(int index, BlockShape shape, Supplier<Integer> range, boolean fullRotation, String englishTranslation) {
        this.index = index;
        this.registryName = this.name().toLowerCase(Locale.ROOT) + "_chunk_loader";
        this.shape = shape;
        this.range = range;
        this.fullRotation = fullRotation;
        this.englishTranslation = englishTranslation;
    }

    public int getIndex() {
        return this.index;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public ChunkLoaderBlock getBlock() {
        return this.block;
    }

    public ChunkLoaderBlockEntity createBlockEntity() {
        return new ChunkLoaderBlockEntity(this);
    }

    public BaseBlockEntityType<ChunkLoaderBlockEntity> getBlockEntityType() {
        return this.blockEntityType;
    }

    public BaseBlockItem getItem() {
        return this.item;
    }

    public BlockShape getShape() {
        return this.shape;
    }

    public int getRange() {
        return this.range.get();
    }

    public int getGridSize() {
        return this.range.get() * 2 - 1;
    }

    public boolean getFullRotation() {
        return this.fullRotation;
    }

    public String getEnglishTranslation() {
        return this.englishTranslation;
    }

    public void registerBlock(RegistrationHandler.Helper<Block> helper) {
        if (this.block != null) {
            throw new IllegalStateException("Blocks have already been registered!");
        }
        this.block = new ChunkLoaderBlock(this);
        helper.register(this.registryName, (Object)this.block);
    }

    public void registerBlockEntity(RegistrationHandler.Helper<BaseBlockEntityType<?>> helper) {
        if (this.blockEntityType != null) {
            throw new IllegalStateException("Block entities have already been registered!");
        }
        if (this.block == null) {
            throw new IllegalStateException("Blocks must be registered before registering block entity types!");
        }
        this.blockEntityType = BaseBlockEntityType.create(this::createBlockEntity, (Block[])new Block[]{this.block});
        helper.register(this.registryName + "_tile", this.blockEntityType);
    }

    public void registerItem(RegistrationHandler.Helper<Item> helper) {
        if (this.item != null) {
            throw new IllegalStateException("Items have already been registered!");
        }
        if (this.block == null) {
            throw new IllegalStateException("Blocks must be registered before registering items!");
        }
        this.item = new BaseBlockItem((Block)this.block, ItemProperties.create().group((CreativeTabs)ChunkLoaders.GROUP));
        helper.register(this.registryName, (Object)this.item);
    }
}

