/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.render;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.transport.pipe.IPipeFlowRenderer;
import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.VecUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.pipe.flow.PipeFlowRedstoneFlux;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum PipeFlowRendererRf implements IPipeFlowRenderer<PipeFlowRedstoneFlux>
{
    INSTANCE;


    @Override
    public void render(PipeFlowRedstoneFlux flow, double x, double y, double z, float partialTicks, BufferBuilder bb) {
        double centrePower = 0.0;
        double[] power = new double[6];
        for (EnumFacing side : EnumFacing.values()) {
            PipeFlowRedstoneFlux.Section s = flow.getSection(side);
            int i = side.ordinal();
            power[i] = (double)s.displayPower / (double)MjAPI.MJ;
            centrePower = Math.max(centrePower, power[i]);
        }
        bb.func_178969_c(x, y, z);
        if (centrePower > 0.0) {
            for (EnumFacing side : EnumFacing.values()) {
                if (!flow.pipe.isConnected(side)) continue;
                int i = side.ordinal();
                PipeFlowRedstoneFlux.Section s = flow.getSection(side);
                double offset = PipeFlowRendererRf.computeOffset(s.clientDisplayFlowLast, s.clientDisplayFlow, partialTicks);
                PipeFlowRendererRf.renderSidePower(side, power[i], centrePower, offset, bb);
            }
            Vec3d offsetLast = flow.clientDisplayFlowCentreLast;
            Vec3d offsetThis = flow.clientDisplayFlowCentre;
            double offsetX = PipeFlowRendererRf.computeOffset(offsetLast.field_72450_a, offsetThis.field_72450_a, partialTicks);
            double offsetY = PipeFlowRendererRf.computeOffset(offsetLast.field_72448_b, offsetThis.field_72448_b, partialTicks);
            double offsetZ = PipeFlowRendererRf.computeOffset(offsetLast.field_72449_c, offsetThis.field_72449_c, partialTicks);
            PipeFlowRendererRf.renderCentrePower(centrePower, offsetX, offsetY, offsetZ, bb);
        }
        bb.func_178969_c(0.0, 0.0, 0.0);
    }

    private static double computeOffset(double tick0, double tick1, float partialTicks) {
        if (tick0 + 8.0 < tick1) {
            tick0 += 16.0;
        } else if (tick1 + 8.0 < tick0) {
            tick1 += 16.0;
        }
        double offset = MathUtil.interp(partialTicks, tick0, tick1);
        if (offset >= 16.0) {
            offset -= 16.0;
        }
        return offset;
    }

    private static void renderSidePower(EnumFacing side, double power, double centrePower, double offset, BufferBuilder bb) {
        if (power < 0.0) {
            return;
        }
        double radius = 0.248 * power;
        if (radius >= 0.248) {
            radius = 0.248;
        }
        TextureAtlasSprite sprite = BCTransportSprites.POWER_FLOW_OVERLOAD.getSprite();
        double centreRadius = 0.252 - 0.248 * centrePower;
        Vec3d centre = VecUtil.offset(VecUtil.VEC_HALF, side, 0.375 - centreRadius / 2.0);
        Vec3d radiusV = new Vec3d(radius, radius, radius);
        radiusV = VecUtil.replaceValue(radiusV, side.func_176740_k(), 0.125 + centreRadius / 2.0);
        Point3f centreF = new Point3f((float)centre.field_72450_a, (float)centre.field_72448_b, (float)centre.field_72449_c);
        Point3f radiusF = new Point3f((float)radiusV.field_72450_a, (float)radiusV.field_72448_b, (float)radiusV.field_72449_c);
        ModelUtil.UvFaceData uvs = new ModelUtil.UvFaceData();
        for (EnumFacing face : EnumFacing.values()) {
            if (face == side.func_176734_d()) continue;
            AxisAlignedBB box = new AxisAlignedBB(centre.func_178788_d(radiusV).func_186678_a(0.5), centre.func_178787_e(radiusV).func_186678_a(0.5));
            box = box.func_191194_a(VecUtil.offset(Vec3d.field_186680_a, side, offset * (double)side.func_176743_c().func_179524_a() / 32.0));
            ModelUtil.mapBoxToUvs(box, face, uvs);
            MutableQuad quad = ModelUtil.createFace(face, (Tuple3f)centreF, (Tuple3f)radiusF, uvs);
            quad.texFromSprite(sprite);
            quad.lighti(15, 15);
            quad.render(bb);
        }
    }

    private static void renderCentrePower(double power, double offsetX, double offsetY, double offsetZ, BufferBuilder bb) {
        boolean overload = false;
        float radius = 0.248f * (float)power;
        if (radius > 0.248f) {
            radius = 0.248f;
        }
        TextureAtlasSprite sprite = BCTransportSprites.POWER_FLOW_OVERLOAD.getSprite();
        Point3f centre = new Point3f(0.5f, 0.5f, 0.5f);
        Point3f radiusP = new Point3f(radius, radius, radius);
        ModelUtil.UvFaceData uvs = new ModelUtil.UvFaceData();
        for (EnumFacing face : EnumFacing.values()) {
            AxisAlignedBB box = new AxisAlignedBB(new Vec3d(0.5 - (double)radius, 0.5 - (double)radius, 0.5 - (double)radius).func_186678_a(0.5), new Vec3d(0.5 + (double)radius, 0.5 + (double)radius, 0.5 + (double)radius).func_186678_a(0.5));
            box = box.func_72317_d(offsetX / 32.0, offsetY / 32.0, offsetZ / 32.0);
            ModelUtil.mapBoxToUvs(box, face, uvs);
            MutableQuad quad = ModelUtil.createFace(face, (Tuple3f)centre, (Tuple3f)radiusP, uvs);
            quad.texFromSprite(sprite);
            quad.lighti(15, 15);
            quad.render(bb);
        }
    }
}

