/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantLong;
import java.util.Objects;

public class NodeFuncObjectBooleanToLong<A>
extends NodeFuncBase
implements INodeFunc.INodeFuncLong {
    public final IFuncObjectBooleanToLong<A> function;
    private final StringFunctionTri stringFunction;
    private final Class<A> argTypeA;

    public NodeFuncObjectBooleanToLong(String name, Class<A> argTypeA, IFuncObjectBooleanToLong<A> function) {
        this(argTypeA, function, (String a, String b) -> "[ " + NodeTypes.getName(argTypeA) + ", boolean -> long ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncObjectBooleanToLong(Class<A> argTypeA, IFuncObjectBooleanToLong<A> function, StringFunctionTri stringFunction) {
        this.argTypeA = argTypeA;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public NodeFuncObjectBooleanToLong<A> setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeLong getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeBoolean b = stack.popBoolean();
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return this.create(a, b);
    }

    public FuncObjectBooleanToLong create(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeBoolean argB) {
        return new FuncObjectBooleanToLong(argA, argB);
    }

    @FunctionalInterface
    public static interface IFuncObjectBooleanToLong<A> {
        public long apply(A var1, boolean var2);
    }

    public class FuncObjectBooleanToLong
    implements IExpressionNode.INodeLong,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeObject<A> argA;
        public final IExpressionNode.INodeBoolean argB;

        public FuncObjectBooleanToLong(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeBoolean argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public long evaluate() {
            return NodeFuncObjectBooleanToLong.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeLong inline() {
            if (!NodeFuncObjectBooleanToLong.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncObjectBooleanToLong(a, (IExpressionNode.INodeBoolean)b), (a, b) -> new FuncObjectBooleanToLong(a, (IExpressionNode.INodeBoolean)b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncObjectBooleanToLong(a, (IExpressionNode.INodeBoolean)b), (a, b) -> NodeConstantLong.of(NodeFuncObjectBooleanToLong.this.function.apply(a.evaluate(), b.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncObjectBooleanToLong.this.canInline) {
                if (NodeFuncObjectBooleanToLong.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncObjectBooleanToLong.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB);
        }

        public String toString() {
            return NodeFuncObjectBooleanToLong.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncObjectBooleanToLong.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncObjectBooleanToLong other = (FuncObjectBooleanToLong)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB);
        }
    }
}

