/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.recipe;

import buildcraft.lib.client.guide.parts.GuidePartFactory;
import buildcraft.lib.client.guide.parts.recipe.GuideAssemblyRecipes;
import buildcraft.lib.client.guide.parts.recipe.GuideCraftingRecipes;
import buildcraft.lib.client.guide.parts.recipe.GuideSmeltingRecipes;
import buildcraft.lib.client.guide.parts.recipe.IStackRecipes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;

public class RecipeLookupHelper {
    public static final Map<String, IStackRecipes> handlerTypes = new HashMap<String, IStackRecipes>();

    public static List<GuidePartFactory> getAllUsages(@Nonnull ItemStack stack, Profiler prof) {
        ArrayList<GuidePartFactory> list = new ArrayList<GuidePartFactory>();
        for (IStackRecipes handler : handlerTypes.values()) {
            prof.func_76320_a(handler.getClass().getName().replace('.', '/'));
            List<GuidePartFactory> recipes = handler.getUsages(stack);
            if (recipes != null) {
                list.addAll(recipes);
            }
            prof.func_76319_b();
        }
        return list;
    }

    public static List<GuidePartFactory> getAllRecipes(@Nonnull ItemStack stack, Profiler prof) {
        ArrayList<GuidePartFactory> list = new ArrayList<GuidePartFactory>();
        for (IStackRecipes handler : handlerTypes.values()) {
            prof.func_76320_a(handler.getClass().getName().replace('.', '/'));
            List<GuidePartFactory> recipes = handler.getRecipes(stack);
            if (recipes != null) {
                list.addAll(recipes);
            }
            prof.func_76319_b();
        }
        return list;
    }

    static {
        handlerTypes.put("smelting", GuideSmeltingRecipes.INSTANCE);
        handlerTypes.put("crafting", GuideCraftingRecipes.INSTANCE);
        handlerTypes.put("assembling", GuideAssemblyRecipes.INSTANCE);
    }
}

