/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import com.google.common.base.Predicate;
import its_meow.betteranimalsplus.common.entity.IVariantTypes;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModLootTables;
import its_meow.betteranimalsplus.init.ModTriggers;
import its_meow.betteranimalsplus.util.HeadTypes;
import java.util.Calendar;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityReindeer
extends EntityAnimal
implements IJumpingMount,
IVariantTypes {
    protected static final Predicate<Entity> IS_REINDEER_BREEDING = p_apply_1_ -> p_apply_1_ instanceof EntityReindeer && ((EntityReindeer)p_apply_1_).isBreeding();
    protected static final IAttribute JUMP_STRENGTH = new RangedAttribute((IAttribute)null, "reindeer.jumpStrength", 0.7, 0.0, 2.0).func_111117_a("Jump Strength").func_111112_a(true);
    protected static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(EntityReindeer.class, (DataSerializer)DataSerializers.field_187191_a);
    private int eatingCounter;
    private int openMouthCounter;
    private int jumpRearingCounter;
    public int tailCounter;
    public int sprintCounter;
    protected boolean reindeerJumping;
    protected float jumpPower;
    private boolean allowStandSliding;
    private float headLean;
    private float prevHeadLean;
    private float rearingAmount;
    private float prevRearingAmount;
    private float mouthOpenness;
    private float prevMouthOpenness;
    protected boolean canGallop = true;
    protected int gallopTime;
    public boolean parentRudolph = false;
    private static final DataParameter<Integer> TYPE_NUMBER = EntityDataManager.func_187226_a(EntityReindeer.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityReindeer(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.3964844f, 1.8f);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0, EntityReindeer.class));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
        this.field_70180_af.func_187214_a(TYPE_NUMBER, (Object)0);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = !itemstack.func_190926_b();
        if (flag && itemstack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (!this.func_70631_g_()) {
            if (player.func_70093_af()) {
                return false;
            }
            if (this.func_184207_aI()) {
                return super.func_184645_a(player, hand);
            }
        }
        if (flag) {
            if (this.handleEating(player, itemstack)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (itemstack.func_111282_a(player, (EntityLivingBase)this, hand)) {
                return true;
            }
        }
        if (this.func_70631_g_()) {
            return super.func_184645_a(player, hand);
        }
        this.mountTo(player);
        return true;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof EntityReindeer)) {
            return false;
        }
        return this.canMate() && ((EntityReindeer)otherAnimal).canMate();
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityReindeer reindeer = new EntityReindeer(this.field_70170_p);
        this.setOffspringAttributes(ageable, reindeer);
        if (ageable instanceof EntityReindeer) {
            EntityReindeer other = (EntityReindeer)ageable;
            if (other.getTypeNumber() > 4) {
                reindeer.setType(other.getTypeNumber());
            } else {
                reindeer.setType(this.getTypeNumber());
            }
            if (other.func_95999_t().equalsIgnoreCase("rudolph") || this.func_95999_t().equalsIgnoreCase("rudolph")) {
                reindeer.parentRudolph = true;
            }
        } else {
            reindeer.setType(this.getTypeNumber());
        }
        return reindeer;
    }

    protected boolean getReindeerWatchableBoolean(int p_110233_1_) {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & p_110233_1_) != 0;
    }

    protected void setReindeerWatchableBoolean(int p_110208_1_, boolean p_110208_2_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        if (p_110208_2_) {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 | p_110208_1_)));
        } else {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 & ~p_110208_1_)));
        }
    }

    public float getReindeerSize() {
        return 0.5f;
    }

    public void func_98054_a(boolean child) {
        this.func_98055_j(child ? this.getReindeerSize() : 1.0f);
    }

    public boolean isReindeerJumping() {
        return this.reindeerJumping;
    }

    public void setReindeerJumping(boolean jumping) {
        this.reindeerJumping = jumping;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return super.func_184652_a(player) && this.func_70668_bt() != EnumCreatureAttribute.UNDEAD;
    }

    protected void func_142017_o(float p_142017_1_) {
        if (p_142017_1_ > 6.0f && this.isEatingHaystack()) {
            this.setEatingHaystack(false);
        }
    }

    public boolean isEatingHaystack() {
        return this.getReindeerWatchableBoolean(16);
    }

    public boolean isRearing() {
        return this.getReindeerWatchableBoolean(32);
    }

    public boolean isBreeding() {
        return this.getReindeerWatchableBoolean(8);
    }

    public void setBreeding(boolean breeding) {
        this.setReindeerWatchableBoolean(8, breeding);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        return this.func_184207_aI() && entity != null && this.func_184215_y(entity) ? false : super.func_70097_a(source, amount);
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    private void eatingReindeer() {
        this.openReindeerMouth();
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187711_cp, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i;
        if (distance > 1.0f) {
            this.func_184185_a(SoundEvents.field_187723_ct, 0.4f, 1.0f);
        }
        if ((i = MathHelper.func_76123_f((float)((distance * 0.5f - 3.0f) * damageMultiplier))) > 0) {
            this.func_70097_a(DamageSource.field_76379_h, i);
            if (this.func_184207_aI()) {
                for (Entity entity : this.func_184182_bu()) {
                    entity.func_70097_a(DamageSource.field_76379_h, (float)i);
                }
            }
            BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            if (iblockstate.func_185904_a() != Material.field_151579_a && !this.func_174814_R()) {
                SoundType soundtype = block.getSoundType(block.func_176223_P(), this.field_70170_p, pos, (Entity)this);
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundtype.func_185844_d(), this.func_184176_by(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    @Nullable
    protected EntityReindeer getClosestReindeer(Entity entityIn, double distance) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : this.field_70170_p.func_175674_a(entityIn, entityIn.func_174813_aQ().func_72321_a(distance, distance, distance), IS_REINDEER_BREEDING)) {
            double d1 = entity1.func_70092_e(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v);
            if (!(d1 < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return (EntityReindeer)entity;
    }

    public double getReindeerJumpStrength() {
        return this.func_110148_a(JUMP_STRENGTH).func_111126_e();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        this.openReindeerMouth();
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.openReindeerMouth();
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.makeReindeerRear();
        }
        return null;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        this.openReindeerMouth();
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70610_aX()) {
            this.makeReindeerRear();
        }
        return null;
    }

    @Nullable
    protected SoundEvent getAngrySound() {
        this.openReindeerMouth();
        this.makeReindeerRear();
        return null;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (!blockIn.func_176223_P().func_185904_a().func_76224_d()) {
            SoundType soundtype = blockIn.getSoundType(blockIn.func_176223_P(), this.field_70170_p, pos, (Entity)this);
            if (this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC) {
                soundtype = Blocks.field_150431_aC.getSoundType(Blocks.field_150431_aC.func_176223_P(), this.field_70170_p, pos, (Entity)this);
            }
            if (this.func_184207_aI() && this.canGallop) {
                ++this.gallopTime;
                if (this.gallopTime > 5 && this.gallopTime % 3 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopTime <= 5) {
                    this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
                }
            } else if (soundtype == SoundType.field_185848_a) {
                this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            } else {
                this.func_184185_a(SoundEvents.field_187729_cv, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            }
        }
    }

    protected void playGallopSound(SoundType p_190680_1_) {
        this.func_184185_a(SoundEvents.field_187714_cq, p_190680_1_.func_185843_a() * 0.15f, p_190680_1_.func_185847_b());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(JUMP_STRENGTH);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.225f);
    }

    public int func_70641_bl() {
        return 6;
    }

    public int getMaxTemper() {
        return 100;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public int func_70627_aG() {
        return 400;
    }

    protected boolean handleEating(EntityPlayer player, ItemStack stack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        Item item = stack.func_77973_b();
        if (item == Items.field_151015_O || item == Items.field_151172_bF) {
            f = 2.0f;
            i = 20;
            if (!this.func_70631_g_() && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        } else if (item == Items.field_151102_aT) {
            f = 1.0f;
            i = 30;
        } else if (item == Item.func_150898_a((Block)Blocks.field_150407_cf)) {
            f = 20.0f;
            i = 180;
        } else if (item == Items.field_151034_e) {
            f = 3.0f;
            i = 60;
        } else if (item == Items.field_151150_bK) {
            f = 4.0f;
            i = 60;
            if (this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        } else if (item == Items.field_151153_ao) {
            f = 10.0f;
            i = 240;
            if (this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
            this.func_70691_i(f);
            flag = true;
        }
        if (this.func_70631_g_() && i > 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(i);
            }
            flag = true;
        }
        if (flag) {
            this.eatingReindeer();
        }
        return flag;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.field_70146_Z.nextInt(12) == 0) {
            ItemStack stack = new ItemStack((Item)HeadTypes.REINDEERHEAD.getItem(this.getTypeNumber()));
            this.func_70099_a(stack, 0.5f);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTables.reindeer;
    }

    protected void mountTo(EntityPlayer player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        this.setEatingHaystack(false);
        this.setRearing(false);
        if (player instanceof EntityPlayerMP) {
            ModTriggers.RIDE_REINDEER.trigger((EntityPlayerMP)player);
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() || this.isEatingHaystack() || this.isRearing();
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        super.func_70636_d();
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, this.field_70165_t + (double)this.field_70146_Z.nextInt(4) - 2.0, this.field_70163_u + (double)this.field_70146_Z.nextInt(4), this.field_70161_v + (double)this.field_70146_Z.nextInt(4) - 2.0, 0.0, (double)-0.005f, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.canEatGrass()) {
                if (!this.isEatingHaystack() && !this.func_184207_aI() && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u) - 1, MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == Blocks.field_150349_c) {
                    this.setEatingHaystack(true);
                }
                if (this.isEatingHaystack() && ++this.eatingCounter > 50) {
                    this.eatingCounter = 0;
                    this.setEatingHaystack(false);
                }
            }
            this.followMother();
        }
    }

    protected void followMother() {
        EntityReindeer reindeer;
        if (this.isBreeding() && this.func_70631_g_() && !this.isEatingHaystack() && (reindeer = this.getClosestReindeer((Entity)this, 16.0)) != null && this.func_70068_e((Entity)reindeer) > 4.0) {
            this.field_70699_by.func_75494_a((Entity)reindeer);
        }
    }

    public boolean canEatGrass() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.openMouthCounter > 0 && ++this.openMouthCounter > 30) {
            this.openMouthCounter = 0;
            this.setReindeerWatchableBoolean(64, false);
        }
        if (this.func_184186_bw() && this.jumpRearingCounter > 0 && ++this.jumpRearingCounter > 20) {
            this.jumpRearingCounter = 0;
            this.setRearing(false);
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        this.prevHeadLean = this.headLean;
        if (this.isEatingHaystack()) {
            this.headLean += (1.0f - this.headLean) * 0.4f + 0.05f;
            if (this.headLean > 1.0f) {
                this.headLean = 1.0f;
            }
        } else {
            this.headLean += (0.0f - this.headLean) * 0.4f - 0.05f;
            if (this.headLean < 0.0f) {
                this.headLean = 0.0f;
            }
        }
        this.prevRearingAmount = this.rearingAmount;
        if (this.isRearing()) {
            this.prevHeadLean = this.headLean = 0.0f;
            this.rearingAmount += (1.0f - this.rearingAmount) * 0.4f + 0.05f;
            if (this.rearingAmount > 1.0f) {
                this.rearingAmount = 1.0f;
            }
        } else {
            this.allowStandSliding = false;
            this.rearingAmount += (0.8f * this.rearingAmount * this.rearingAmount * this.rearingAmount - this.rearingAmount) * 0.6f - 0.05f;
            if (this.rearingAmount < 0.0f) {
                this.rearingAmount = 0.0f;
            }
        }
        this.prevMouthOpenness = this.mouthOpenness;
        if (this.getReindeerWatchableBoolean(64)) {
            this.mouthOpenness += (1.0f - this.mouthOpenness) * 0.7f + 0.05f;
            if (this.mouthOpenness > 1.0f) {
                this.mouthOpenness = 1.0f;
            }
        } else {
            this.mouthOpenness += (0.0f - this.mouthOpenness) * 0.7f - 0.05f;
            if (this.mouthOpenness < 0.0f) {
                this.mouthOpenness = 0.0f;
            }
        }
    }

    private void openReindeerMouth() {
        if (!this.field_70170_p.field_72995_K) {
            this.openMouthCounter = 1;
            this.setReindeerWatchableBoolean(64, true);
        }
    }

    public void setEatingHaystack(boolean p_110227_1_) {
        this.setReindeerWatchableBoolean(16, p_110227_1_);
    }

    public void setRearing(boolean rearing) {
        if (rearing) {
            this.setEatingHaystack(false);
        }
        this.setReindeerWatchableBoolean(32, rearing);
    }

    private void makeReindeerRear() {
        if (this.func_184186_bw()) {
            this.jumpRearingCounter = 1;
            this.setRearing(true);
        }
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.5f;
            forward = entitylivingbase.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
                this.gallopTime = 0;
            }
            if (this.field_70122_E && this.jumpPower == 0.0f && this.isRearing() && !this.allowStandSliding) {
                strafe = 0.0f;
                forward = 0.0f;
            }
            if (this.jumpPower > 0.0f && !this.isReindeerJumping() && this.field_70122_E) {
                this.field_70181_x = this.getReindeerJumpStrength() * (double)this.jumpPower;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.setReindeerJumping(true);
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f * this.jumpPower);
                    this.field_70179_y += (double)(0.4f * f1 * this.jumpPower);
                    this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
                }
                this.jumpPower = 0.0f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(strafe, vertical, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.field_70122_E) {
                this.jumpPower = 0.0f;
                this.setReindeerJumping(false);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public void func_96094_a(String name) {
        if (name.toLowerCase().equals("rudolph") && this.getTypeNumber() <= 4) {
            this.setType(this.getTypeNumber() + 4);
        }
        super.func_96094_a(name);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("EatingHaystack", this.isEatingHaystack());
        compound.func_74757_a("Bred", this.isBreeding());
        this.writeType(compound);
        compound.func_74757_a("IsParentRudolph", this.parentRudolph);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setEatingHaystack(compound.func_74767_n("EatingHaystack"));
        this.setBreeding(compound.func_74767_n("Bred"));
        this.parentRudolph = compound.func_74767_n("IsParentRudolph");
        IAttributeInstance iattributeinstance = this.func_110140_aT().func_111152_a("Speed");
        if (iattributeinstance != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(iattributeinstance.func_111125_b() * 0.25);
        }
        this.readType(compound);
        Calendar calendar = Calendar.getInstance();
        if (!(this.getTypeNumber() <= 4 || calendar.get(2) + 1 == 12 && calendar.get(5) >= 22 && calendar.get(5) <= 28 || this.func_95999_t().toLowerCase().equals("rudolph") || this.parentRudolph)) {
            this.setType(this.getTypeNumber() - 4);
        }
    }

    protected boolean canMate() {
        return !this.func_184207_aI() && !this.func_184218_aH() && !this.func_70631_g_() && this.func_110143_aJ() >= this.func_110138_aP() && this.func_70880_s();
    }

    protected void setOffspringAttributes(EntityAgeable p_190681_1_, EntityReindeer p_190681_2_) {
        double d0 = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + p_190681_1_.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + (double)this.getModifiedMaxHealth();
        p_190681_2_.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(d0 / 3.0);
        double d1 = this.func_110148_a(JUMP_STRENGTH).func_111125_b() + p_190681_1_.func_110148_a(JUMP_STRENGTH).func_111125_b() + this.getModifiedJumpStrength();
        p_190681_2_.func_110148_a(JUMP_STRENGTH).func_111128_a(d1 / 3.0);
        double d2 = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + p_190681_1_.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.getModifiedMovementSpeed();
        p_190681_2_.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(d2 / 3.0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    @SideOnly(value=Side.CLIENT)
    public float getGrassEatingAmount(float p_110258_1_) {
        return this.prevHeadLean + (this.headLean - this.prevHeadLean) * p_110258_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float getRearingAmount(float p_110223_1_) {
        return this.prevRearingAmount + (this.rearingAmount - this.prevRearingAmount) * p_110223_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float getMouthOpennessAngle(float p_110201_1_) {
        return this.prevMouthOpenness + (this.mouthOpenness - this.prevMouthOpenness) * p_110201_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_110206_u(int jumpPowerIn) {
        if (jumpPowerIn < 0) {
            jumpPowerIn = 0;
        } else {
            this.allowStandSliding = true;
            this.makeReindeerRear();
        }
        this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_184775_b(int p_184775_1_) {
        this.allowStandSliding = true;
        this.makeReindeerRear();
    }

    public void func_184777_r_() {
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnReindeerParticles(boolean p_110216_1_) {
        EnumParticleTypes enumparticletypes = p_110216_1_ ? EnumParticleTypes.HEART : EnumParticleTypes.SMOKE_NORMAL;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 7) {
            this.spawnReindeerParticles(true);
        } else if (id == 6) {
            this.spawnReindeerParticles(false);
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)passenger;
            this.field_70761_aq = entityliving.field_70761_aq;
        }
        if (this.prevRearingAmount > 0.0f) {
            float f3 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f1 = 0.7f * this.prevRearingAmount;
            float f2 = 0.15f * this.prevRearingAmount;
            passenger.func_70107_b(this.field_70165_t + (double)(f1 * f3), this.field_70163_u + this.func_70042_X() + passenger.func_70033_W() + (double)f2, this.field_70161_v - (double)(f1 * f));
            if (passenger instanceof EntityLivingBase) {
                ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    protected float getModifiedMaxHealth() {
        return 15.0f + (float)this.field_70146_Z.nextInt(8) + (float)this.field_70146_Z.nextInt(9);
    }

    protected double getModifiedJumpStrength() {
        return (double)0.4f + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2;
    }

    protected double getModifiedMovementSpeed() {
        return ((double)0.45f + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3) * 0.25;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    public boolean wearsArmor() {
        return false;
    }

    public boolean isArmor(ItemStack stack) {
        return false;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (!this.func_70631_g_()) {
            Calendar calendar = Calendar.getInstance();
            boolean isChristmasSeason = calendar.get(2) + 1 == 12 && calendar.get(5) >= 22 && calendar.get(5) <= 28;
            boolean redNosed = this.field_70146_Z.nextInt(9) == 0;
            int i = this.field_70146_Z.nextInt(4) + (isChristmasSeason && redNosed ? 5 : 1);
            boolean flag = false;
            if (livingdata instanceof IVariantTypes.TypeData) {
                i = ((IVariantTypes.TypeData)livingdata).typeData;
                flag = true;
            } else {
                livingdata = new IVariantTypes.TypeData(i);
            }
            this.setType(i);
            if (flag) {
                this.func_70873_a(-24000);
            }
        }
        return livingdata;
    }

    @Override
    public int getVariantMax() {
        return 0;
    }

    @Override
    public DataParameter<Integer> getDataKey() {
        return TYPE_NUMBER;
    }

    @Override
    public boolean isChildI() {
        return this.func_70631_g_();
    }

    @Override
    public Random getRNGI() {
        return this.func_70681_au();
    }

    @Override
    public EntityDataManager getDataManagerI() {
        return this.func_184212_Q();
    }

    protected boolean func_70692_ba() {
        return ModEntities.entityMap.containsKey("reindeer") ? ModEntities.entityMap.get((Object)"reindeer").despawn && !this.func_145818_k_() : false;
    }
}

