/*
 * Decompiled with CFR 0.152.
 */
package io.chocorean.authmod.model;

import io.chocorean.authmod.model.IPlayer;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class Player
implements IPlayer {
    private String password;
    @Email
    private String email;
    private boolean banned;
    @Size(min=36, max=36)
    private @Size(min=36, max=36) String uuid;
    @NotNull
    private String username;

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public IPlayer setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public IPlayer setEmail(String email) {
        this.email = email == null ? "" : email.trim();
        return this;
    }

    @Override
    public boolean isBanned() {
        return this.banned;
    }

    @Override
    public IPlayer setBanned(boolean ban) {
        this.banned = ban;
        return this;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public IPlayer setUuid(String uuid) {
        if (uuid == null) {
            this.uuid = "";
        } else {
            if (uuid.length() == 32) {
                uuid = String.format("%s-%s-%s-%s-%s", uuid.substring(0, 8), uuid.substring(8, 12), uuid.substring(12, 16), uuid.substring(16, 20), uuid.substring(20, 32));
            }
            this.uuid = uuid.length() == 36 ? uuid : "";
        }
        return this;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isPremium() {
        return this.getUuid().length() != 0;
    }

    @Override
    public IPlayer setUsername(String username) {
        this.username = username == null ? "" : username.trim();
        return this;
    }

    public String toString() {
        return String.format("{%s, %s}", this.getEmail(), this.getUsername());
    }
}

