/*
 * Decompiled with CFR 0.152.
 */
package io.chocorean.authmod.guard.datasource.db;

import io.chocorean.authmod.AuthMod;
import io.chocorean.authmod.guard.datasource.db.IConnectionFactory;
import io.chocorean.authmod.guard.datasource.db.IPlayersDAO;
import io.chocorean.authmod.model.IPlayer;
import io.chocorean.authmod.model.Player;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class PlayersDAO
implements IPlayersDAO<IPlayer> {
    private static final Logger LOGGER = AuthMod.LOGGER;
    private final String table;
    private final IConnectionFactory connectionFactory;
    private final Map<String, String> columns;
    private static final String EMAIL_COLUMN = "email";
    private static final String USERNAME_COLUMN = "username";
    private static final String UUID_COLUMN = "uuid";
    private static final String PASSWORD_COLUMN = "password";
    private static final String BANNED_COLUMN = "banned";

    public PlayersDAO(IConnectionFactory connectionFactory) throws SQLException {
        this("players", connectionFactory);
    }

    public PlayersDAO(IConnectionFactory connectionFactory, Map<String, String> columns) throws SQLException {
        this.table = "players";
        this.columns = columns;
        this.connectionFactory = connectionFactory;
        this.checkTable();
    }

    public PlayersDAO(String table, IConnectionFactory connectionFactory) throws SQLException {
        this.table = table;
        this.connectionFactory = connectionFactory;
        this.columns = new HashMap<String, String>();
        this.columns.put(EMAIL_COLUMN, EMAIL_COLUMN);
        this.columns.put(BANNED_COLUMN, BANNED_COLUMN);
        this.columns.put(PASSWORD_COLUMN, PASSWORD_COLUMN);
        this.columns.put(USERNAME_COLUMN, USERNAME_COLUMN);
        this.columns.put(UUID_COLUMN, UUID_COLUMN);
        this.checkTable();
    }

    private void checkTable() throws SQLException {
        try (Connection connection = this.connectionFactory.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("SELECT %s,%s,%s,%s,%s FROM %s", this.columns.getOrDefault(EMAIL_COLUMN, EMAIL_COLUMN), this.columns.getOrDefault(BANNED_COLUMN, BANNED_COLUMN), this.columns.getOrDefault(PASSWORD_COLUMN, PASSWORD_COLUMN), this.columns.getOrDefault(USERNAME_COLUMN, USERNAME_COLUMN), this.columns.getOrDefault(UUID_COLUMN, UUID_COLUMN), this.table));){
            stmt.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
    }

    @Override
    public void create(IPlayer player) throws SQLException {
        String query = String.format("INSERT INTO %s(%s, %s, %s, %s) VALUES(?, ?, ?, ?)", this.table, this.columns.get(EMAIL_COLUMN), this.columns.get(PASSWORD_COLUMN), this.columns.get(USERNAME_COLUMN), this.columns.get(UUID_COLUMN));
        try (Connection conn = this.connectionFactory.getConnection();
             PreparedStatement stmt = conn.prepareStatement(query);){
            stmt.setString(1, player.getEmail());
            stmt.setString(2, player.getPassword());
            stmt.setString(3, player.getUsername());
            if (player.getUuid() == null || player.getUuid().length() == 0) {
                stmt.setNull(4, 12);
            } else {
                stmt.setString(4, player.getUuid());
            }
            stmt.executeUpdate();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public IPlayer find(IPlayer player) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Player createPlayer(ResultSet rs) throws SQLException {
        Player player = null;
        if (rs != null && rs.next()) {
            player = new Player();
            player.setBanned(rs.getInt(this.columns.get(BANNED_COLUMN)) != 0);
            player.setEmail(rs.getString(this.columns.get(EMAIL_COLUMN)));
            player.setPassword(rs.getString(this.columns.get(PASSWORD_COLUMN)));
            player.setUsername(rs.getString(this.columns.get(USERNAME_COLUMN)));
            player.setUuid(rs.getString(this.columns.get(UUID_COLUMN)));
        }
        if (rs != null) {
            rs.close();
        }
        return player;
    }
}

