/*
 * Decompiled with CFR 0.152.
 */
package io.chocorean.authmod.guard.authentication;

import io.chocorean.authmod.exception.BannedPlayerException;
import io.chocorean.authmod.exception.InvalidEmailException;
import io.chocorean.authmod.exception.LoginException;
import io.chocorean.authmod.exception.PlayerNotFoundException;
import io.chocorean.authmod.exception.WrongPasswordException;
import io.chocorean.authmod.exception.WrongUsernameException;
import io.chocorean.authmod.guard.datasource.IDataSourceStrategy;
import io.chocorean.authmod.guard.payload.IPayload;
import io.chocorean.authmod.guard.payload.LoginPayload;
import io.chocorean.authmod.model.IPlayer;
import javax.validation.ConstraintViolation;
import org.mindrot.jbcrypt.BCrypt;

public class Authenticator {
    private final IDataSourceStrategy dataSource;

    public Authenticator(IDataSourceStrategy dataSourceStrategy) {
        this.dataSource = dataSourceStrategy;
    }

    public boolean login(LoginPayload payload) throws LoginException, InvalidEmailException {
        if (payload != null) {
            if (payload.isValid()) {
                IPlayer player = this.dataSource.find(payload.getEmail(), payload.getUsername());
                if (player == null) {
                    throw new PlayerNotFoundException();
                }
                if (!player.getUsername().equals(payload.getUsername())) {
                    throw new WrongUsernameException();
                }
                if (player.isBanned()) {
                    throw new BannedPlayerException();
                }
                boolean correct = BCrypt.checkpw(payload.getPassword(), player.getPassword());
                if (!correct) {
                    throw new WrongPasswordException();
                }
                return true;
            }
            for (ConstraintViolation<IPayload> c : payload.getErrors()) {
                if (c.getPropertyPath().toString().equals("email")) {
                    throw new InvalidEmailException();
                }
                if (!c.getPropertyPath().toString().equals("password")) continue;
                throw new WrongPasswordException();
            }
        }
        return false;
    }

    IDataSourceStrategy getDataSourceStrategy() {
        return this.dataSource;
    }
}

