/*
 * Decompiled with CFR 0.152.
 */
package io.chocorean.authmod.event;

import io.chocorean.authmod.config.AuthModConfig;
import io.chocorean.authmod.model.PlayerDescriptor;
import io.chocorean.authmod.model.PlayerPos;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketDisconnect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class Handler {
    private static final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(1);
    private static final Map<EntityPlayer, PlayerDescriptor> descriptors = new HashMap<EntityPlayer, PlayerDescriptor>();
    private static final Map<EntityPlayer, Boolean> logged = new HashMap<EntityPlayer, Boolean>();
    private static final String WELCOME = AuthModConfig.i18n.welcome;
    private static final String WAKE_UP = String.format(AuthModConfig.i18n.delay, Integer.toString(AuthModConfig.delay));

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer entity = event.player;
        BlockPos pos = entity.func_180425_c();
        float yaw = entity.field_70177_z;
        float pitch = entity.field_70125_A;
        PlayerPos pp = new PlayerPos(pos, yaw, pitch);
        PlayerDescriptor dc = new PlayerDescriptor(entity, pp);
        descriptors.put(entity, dc);
        scheduler.schedule(() -> {
            if (descriptors.containsKey(entity)) {
                descriptors.remove(entity);
                logged.remove(entity);
                ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketDisconnect((ITextComponent)new TextComponentString(WAKE_UP)));
            }
        }, (long)AuthModConfig.delay, TimeUnit.SECONDS);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        logged.remove(event.player);
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (descriptors.containsKey(event.player)) {
            PlayerPos pp = descriptors.get(event.player).getPosition();
            BlockPos pos = pp.getPosition();
            ((EntityPlayerMP)event.player).field_71135_a.func_147364_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), pp.getYaw(), pp.getPitch());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerEvent(PlayerEvent event) {
        EntityPlayer entity = event.getEntityPlayer();
        if (descriptors.containsKey(entity) && event.isCancelable()) {
            event.setCanceled(true);
            entity.func_145747_a((ITextComponent)new TextComponentString(WELCOME));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCommand(CommandEvent event) {
        String name = event.getCommand().func_71517_b();
        if (descriptors.containsKey(event.getSender()) && !name.equals("register") && !name.equals("login") && !name.equals("logged") && event.getSender() instanceof EntityPlayer && event.isCancelable()) {
            event.setCanceled(true);
            event.getSender().func_145747_a((ITextComponent)new TextComponentString(WELCOME));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onChatEvent(ServerChatEvent event) {
        EntityPlayerMP entity = event.getPlayer();
        if (event.isCancelable() && descriptors.containsKey(entity)) {
            event.setCanceled(true);
            event.getPlayer().func_145747_a((ITextComponent)new TextComponentString(WELCOME));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTossEvent(ItemTossEvent event) {
        EntityPlayer entity = event.getPlayer();
        if (event.isCancelable() && descriptors.containsKey(entity)) {
            event.setCanceled(true);
            entity.field_71071_by.func_70441_a(event.getEntityItem().func_92059_d());
            event.getPlayer().func_145747_a((ITextComponent)new TextComponentString(WELCOME));
        }
    }

    private static void handleLivingEvents(LivingEvent event, Entity entity) {
        if (event.getEntity() instanceof EntityPlayer && event.isCancelable() && descriptors.containsKey(entity)) {
            event.setCanceled(true);
            entity.func_145747_a((ITextComponent)new TextComponentString(WELCOME));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        Handler.handleLivingEvents((LivingEvent)event, event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        Handler.handleLivingEvents((LivingEvent)event, event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingEntityUseItemEvent(LivingEntityUseItemEvent event) {
        Handler.handleLivingEvents((LivingEvent)event, event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHealEvent(LivingHealEvent event) {
        Handler.handleLivingEvents((LivingEvent)event, event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        Handler.handleLivingEvents((LivingEvent)event, event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingSetTargetAttackEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityPlayer && descriptors.containsKey(event.getTarget())) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("authmod")) {
            ConfigManager.sync((String)"authmod", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public void authorizePlayer(EntityPlayer player) {
        logged.put(player, true);
        descriptors.remove(player);
    }

    public boolean isLogged(EntityPlayer player) {
        return logged.getOrDefault(player, false);
    }
}

