/*
 * Decompiled with CFR 0.152.
 */
package io.chocorean.authmod.config;

import net.minecraftforge.common.config.Config;

@Config(modid="authmod")
public class AuthModConfig {
    @Config.Comment(value={"Email will be asked to the player for registration and authentication"})
    public static boolean emailRequired = false;
    @Config.Comment(value={"If the player doesn't log in after this delay (the unit is the second), he will be kicked from the server."})
    public static int delay = 60;
    @Config.Comment(value={"Enable or disable the /login command (if disabled, the server will be opened to everyone)"})
    public static boolean enableAuthentication = true;
    @Config.Comment(value={"Enable or disable the /register command"})
    public static boolean enableRegistration = true;
    @Config.Comment(value={"The way you want to store player's data, choose between 'database' or 'file'.", "If the strategy is unknown, the server will be open for everyone."})
    public static Strategies dataSourceStrategy = Strategies.FILE;
    public static final DatabaseConfig database = new DatabaseConfig();
    public static final I18nConfig i18n = new I18nConfig();

    public static final class I18nConfig {
        @Config.Comment(value={"Message displayed when an error with database occurs. Check your server logs."})
        public String error = "Something was wrong. Please contact the admins.";
        @Config.Comment(value={"Message displayed to a player when he/she joins the server."})
        public String welcome = "Use /register to sign up or /login to sign in.";
        public String delay = "Wake up, you have only %s seconds to log in.";
        @Config.Comment(value={"Message displayed when a player tries to connect while being banned."})
        public String loginBanned = "You've been banned. Please contact the admins.";
        @Config.Comment(value={"Usage for /login"})
        public String loginUsage = "/login <email> <password> - Allows you to authenticate on the server";
        @Config.Comment(value={"Message displayed to a player when he/she attempts to sign in with an incorrect email."})
        public String loginInvalidEmail = "Your email is not valid.";
        @Config.Comment(value={"Message displayed when a player tries to connect without having registered."})
        public String loginUnknown = "%s is not registered on this server.";
        @Config.Comment(value={"Message displayed to a player when he/she successfully signs in."})
        public String loginSuccess = "Have fun!";
        @Config.Comment(value={"Message displayed to a player when he/she typed a wrong password."})
        public String loginWrongPassword = "Wrong password. Please try again.";
        @Config.Comment(value={"Message displayed to a player when he/she typed a wrong password."})
        public String loginWrongUuid = "Wrong UUID. Please be sure you use the same UUID when you registered your account.";
        @Config.Comment(value={"Message displayed to a player when he/she attempts to sign in with wrong username"})
        public String loginWrongUsername = "Your username does not correspond to your credentials.";
        @Config.Comment(value={"Message displayed when a player tries to sign up with an already-registered account."})
        public String registerExist = "Someone has already registered with this username or email.";
        @Config.Comment(value={"Usage for /register"})
        public String registerUsage = "/register <email> <password> <password>- Be careful when choosing it, you'll be asked to login each time you play.";
        @Config.Comment(value={"Alternative usage for /register"})
        public String registerAlternativeUsage = "/register <password> <password>- Be careful when choosing it, you'll be asked to login each time you play.";
        @Config.Comment(value={"Message displayed to a player when he/she successfully registered."})
        public String registerSuccess = "You are registered and authenticated, have fun!";
        @Config.Comment(value={"Message displayed to a player when he/she fails to login."})
        public String registerWrongPasswordConfirmation = "The password confirmation doesn't match. Please retry.";
        @Config.Comment(value={"Message displayed to a player when he/she tries to register while being already logged in."})
        public String registerAlreadyLogged = "You are already logged in, no need to register !";
        @Config.Comment(value={"Message displayed to a player when he/she tries to register with a short password."})
        public String registerPasswordTooShort = "Your password should be at least 5-character long.";
        public String loggedYes = "Yes";
        public String loggedNo = "No";
        @Config.Comment(value={"Usage for /logged"})
        public String loggedUsage = "/logged - tells you whether you are authenticated or not";
    }

    public static final class DatabaseConfig {
        @Config.Comment(value={"Column name for the email address"})
        public String emailField = "email";
        @Config.Comment(value={"Column name telling whether the player is banned or not"})
        public String bannedField = "banned";
        @Config.Comment(value={"Column name for the username"})
        public String usernameField = "username";
        @Config.Comment(value={"Column name for the player's uuid"})
        public String uuidField = "uuid";
        @Config.Comment(value={"Column name containing the encrypted password"})
        public String passwordField = "password";
        @Config.Comment(value={"Name of the database"})
        public String database = "minecraft";
        @Config.Comment(value={"SQL dialect used"})
        public String dialect = "mariadb";
        @Config.Comment(value={"Host hosting the database"})
        public String host = "mariadb";
        @Config.Comment(value={"Database user"})
        public String user = "root";
        @Config.Comment(value={"Database user's password"})
        public String password = "root";
        @Config.Comment(value={"Port to be used"})
        public int port = 3306;
        @Config.Comment(value={"SQL table to be used"})
        public String table = "players";
    }

    public static enum Strategies {
        FILE,
        DATABASE;

    }
}

