/*
 * Decompiled with CFR 0.152.
 */
package io.chocorean.authmod.command;

import io.chocorean.authmod.AuthMod;
import io.chocorean.authmod.command.LoginCommand;
import io.chocorean.authmod.config.AuthModConfig;
import io.chocorean.authmod.event.Handler;
import io.chocorean.authmod.exception.InvalidEmailException;
import io.chocorean.authmod.exception.InvalidPasswordException;
import io.chocorean.authmod.exception.PlayerAlreadyExistException;
import io.chocorean.authmod.exception.RegistrationException;
import io.chocorean.authmod.exception.WrongPasswordConfirmationException;
import io.chocorean.authmod.guard.datasource.IDataSourceStrategy;
import io.chocorean.authmod.guard.payload.RegistrationPayload;
import io.chocorean.authmod.guard.registration.Registrator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.logging.log4j.Logger;

public class RegisterCommand
implements ICommand {
    private static final Logger LOGGER = AuthMod.LOGGER;
    private final List<String> aliases;
    private final Registrator registrator;
    private final Handler handler;
    private final boolean emailRequired;

    public RegisterCommand(Handler handler, IDataSourceStrategy strategy, boolean emailRequired) {
        this.handler = handler;
        this.aliases = new ArrayList<String>();
        this.aliases.add("reg");
        this.registrator = new Registrator(strategy);
        this.emailRequired = emailRequired;
    }

    public RegisterCommand(Handler handler, IDataSourceStrategy strategy) {
        this(handler, strategy, false);
    }

    public String func_71517_b() {
        return "register";
    }

    public String func_71518_a(ICommandSender sender) {
        return this.emailRequired ? AuthModConfig.i18n.registerUsage : AuthModConfig.i18n.registerAlternativeUsage;
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        EntityPlayer player = (EntityPlayer)sender;
        String playerName = player.getDisplayNameString();
        LOGGER.info(String.format("%s is using /register", playerName));
        if (args.length == (this.emailRequired ? 3 : 2)) {
            if (!this.handler.isLogged(player)) {
                try {
                    LOGGER.info(String.format("Forging payload for player %s", playerName));
                    RegistrationPayload payload = this.createPayload(player, args);
                    LOGGER.info(String.format("Registering payload for player %s", playerName));
                    this.registrator.register(payload);
                    LOGGER.info(String.format("Authorizing player %s", playerName));
                    this.handler.authorizePlayer(player);
                    sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.registerSuccess));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
                }
                catch (InvalidEmailException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.loginInvalidEmail));
                }
                catch (PlayerAlreadyExistException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.registerExist));
                }
                catch (WrongPasswordConfirmationException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.registerWrongPasswordConfirmation));
                }
                catch (InvalidPasswordException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.registerPasswordTooShort));
                }
                catch (RegistrationException e) {
                    LOGGER.error(e.getMessage());
                    sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.error));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.registerAlreadyLogged));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        return new ArrayList<String>();
    }

    public boolean func_82358_a(String[] args, int index) {
        return true;
    }

    public int compareTo(ICommand iCommand) {
        return this.func_71517_b().compareTo(iCommand.func_71517_b());
    }

    private RegistrationPayload createPayload(EntityPlayer player, String[] args) {
        return new RegistrationPayload(LoginCommand.createPayload(this.emailRequired, player, args), this.emailRequired ? args[2] : args[1]);
    }
}

