/*
 * Decompiled with CFR 0.152.
 */
package io.chocorean.authmod.command;

import com.mojang.authlib.GameProfile;
import io.chocorean.authmod.AuthMod;
import io.chocorean.authmod.config.AuthModConfig;
import io.chocorean.authmod.event.Handler;
import io.chocorean.authmod.exception.BannedPlayerException;
import io.chocorean.authmod.exception.InvalidEmailException;
import io.chocorean.authmod.exception.LoginException;
import io.chocorean.authmod.exception.PlayerNotFoundException;
import io.chocorean.authmod.exception.WrongPasswordException;
import io.chocorean.authmod.exception.WrongUsernameException;
import io.chocorean.authmod.guard.authentication.Authenticator;
import io.chocorean.authmod.guard.datasource.IDataSourceStrategy;
import io.chocorean.authmod.guard.payload.LoginPayload;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.logging.log4j.Logger;

public class LoginCommand
implements ICommand {
    private static final Logger LOGGER = AuthMod.LOGGER;
    private final List<String> aliases;
    private final Authenticator authenticator;
    private final Handler handler;
    private final boolean emailRequired;

    public LoginCommand(Handler handler, IDataSourceStrategy strategy) {
        this(handler, strategy, false);
    }

    public LoginCommand(Handler handler, IDataSourceStrategy strategy, boolean emailRequired) {
        this.handler = handler;
        this.aliases = new ArrayList<String>();
        this.aliases.add("log");
        this.authenticator = new Authenticator(strategy);
        this.emailRequired = emailRequired;
    }

    public String func_71517_b() {
        return "login";
    }

    public String func_71518_a(ICommandSender sender) {
        return AuthModConfig.i18n.loginUsage;
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        EntityPlayer player = (EntityPlayer)sender;
        LOGGER.info(String.format("%s is using /login", player.getDisplayNameString()));
        if (args.length == (this.emailRequired ? 2 : 1)) {
            if (!this.handler.isLogged(player)) {
                LoginPayload payload = LoginCommand.createPayload(this.emailRequired, player, args);
                LOGGER.info(payload.toString() + " is going to log in");
                try {
                    if (this.authenticator.login(payload)) {
                        this.handler.authorizePlayer(player);
                        LOGGER.info(player.getDisplayNameString() + " authenticated");
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.loginSuccess));
                }
                catch (WrongUsernameException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.loginWrongUsername));
                }
                catch (WrongPasswordException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.loginWrongPassword));
                }
                catch (BannedPlayerException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.loginBanned));
                }
                catch (PlayerNotFoundException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(String.format(AuthModConfig.i18n.loginUnknown, player.getDisplayNameString())));
                }
                catch (InvalidEmailException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.loginInvalidEmail));
                }
                catch (LoginException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(AuthModConfig.i18n.error));
                    LOGGER.error(e.getMessage());
                }
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    static LoginPayload createPayload(boolean emailRequired, EntityPlayer player, String[] args) {
        LoginPayload payload = new LoginPayload();
        payload.setEmailRequired(emailRequired);
        payload.setEmail(emailRequired ? args[0] : null);
        payload.setPassword(emailRequired ? args[1] : args[0]);
        payload.setUsername(player.getDisplayNameString());
        return payload.setUuid(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        return new ArrayList<String>();
    }

    public boolean func_82358_a(String[] args, int index) {
        return true;
    }

    public int compareTo(ICommand iCommand) {
        return this.func_71517_b().compareTo(iCommand.func_71517_b());
    }
}

